/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.interpolators.SineInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Tickable;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;

public class Background
extends Feature {
    private static final long serialVersionUID = 1L;
    public static final int PAUSE_DURATION = 20;
    public static final int SPAWN_DURATION = 20;
    public static final int WAIT_DURATION = 20;
    private static final int PHASE_PAUSE = 0;
    private static final int PHASE_SPAWN = 1;
    private static final int PHASE_NORMAL = 2;
    private static final int PHASE_WAIT = 3;
    private static final int PHASE_CLEANUP = 4;
    private static final int PHASE_DONE = 5;
    private static final ArrayList BACKGROUNDS = new ArrayList(20);
    private static final ArrayList ARENAS = new ArrayList(4);
    private boolean arena;
    private String music;
    private List sections;
    private Color color;
    private transient ALBuffer musicResource;

    public Background(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List children = XMLUtil.getChildren((Element)element, (String)"section");
        this.sections = new LinkedList();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            Section section = new Section();
            section.load(child, loader);
            this.sections.add(section);
        }
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        Iterator i = this.sections.iterator();
        while (i.hasNext()) {
            Section section = (Section)((Object)i.next());
            section.create();
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        Iterator i = this.sections.iterator();
        while (i.hasNext()) {
            Section section = (Section)((Object)i.next());
            section.destroy();
        }
    }

    public void spawn(Screen screen) {
        Iterator i = this.sections.iterator();
        while (i.hasNext()) {
            Section section = (Section)((Object)i.next());
            section.spawn(screen);
        }
        if (this.musicResource != null) {
            Game.playMusic((ALBuffer)this.musicResource, (int)120);
        } else {
            Game.playMusic(null, (int)120);
        }
    }

    public void advance() {
        Iterator i = this.sections.iterator();
        while (i.hasNext()) {
            Section section = (Section)((Object)i.next());
            section.advance();
        }
    }

    public void remove() {
        Iterator i = this.sections.iterator();
        while (i.hasNext()) {
            Section section = (Section)((Object)i.next());
            section.cleanup();
        }
    }

    public void cleanup() {
        Iterator i = this.sections.iterator();
        while (i.hasNext()) {
            Section section = (Section)((Object)i.next());
            section.remove();
        }
    }

    public static Background getBackground(int level) {
        try {
            Background ret = (Background)((Object)BACKGROUNDS.get((level - 1) % BACKGROUNDS.size()));
            if (!ret.isCreated()) {
                ret.create();
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.out.println("got an " + e.getClass() + " : " + e);
            throw new RuntimeException("Failed to get background " + level);
        }
    }

    public static Background getArena(int level) {
        return (Background)((Object)ARENAS.get(level % ARENAS.size()));
    }

    public Color getColor() {
        return this.color;
    }

    protected void doRegister() {
        if (this.arena) {
            ARENAS.add(this);
        } else {
            BACKGROUNDS.add(this);
        }
    }

    protected void doDeregister() {
        if (this.arena) {
            ARENAS.remove((Object)this);
        } else {
            BACKGROUNDS.remove((Object)this);
        }
    }

    private static class Section
    extends Feature
    implements Tickable {
        String appearance;
        String image;
        int x;
        int y;
        int layer;
        int direction;
        transient AnimatedAppearanceResource appearanceResource;
        transient Sprite sprite;
        transient Screen screen;
        transient int phase;
        transient int xx;
        transient int yy;
        transient int dx;
        transient int dy;
        transient int fx;
        transient int fy;
        transient int tick;

        Section() {
            this.setSubResource(true);
            this.setAutoCreated();
        }

        protected void doDestroy() {
            super.doDestroy();
            this.remove();
        }

        void cleanup() {
            this.phase = 3;
            this.tick = 0;
        }

        void advance() {
            this.phase = 1;
            this.tick = 0;
            this.sprite = this.screen.allocateSprite((Object)this);
            if (this.sprite != null) {
                this.sprite.setLocation(this.dx, this.dy, 0);
                this.sprite.setLayer(this.layer);
                if (this.appearanceResource != null) {
                    this.sprite.setAppearance((AnimatedAppearance)this.appearanceResource);
                }
            } else {
                this.remove();
            }
        }

        public void tick() {
            switch (this.phase) {
                case 0: {
                    ++this.tick;
                    if (this.tick < 20) break;
                    this.advance();
                    break;
                }
                case 1: {
                    ++this.tick;
                    float ratio = (float)this.tick / 20.0f;
                    this.xx = (int)SineInterpolator.instance.interpolate((float)this.dx, (float)this.x, ratio);
                    this.yy = (int)SineInterpolator.instance.interpolate((float)this.dy, (float)this.y, ratio);
                    this.sprite.setLocation(this.xx, this.yy, 0);
                    if (this.tick < 20) break;
                    this.phase = 2;
                    this.tick = 0;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    ++this.tick;
                    if (this.tick < 20) break;
                    this.phase = 4;
                    this.tick = 0;
                    break;
                }
                case 4: {
                    ++this.tick;
                    float ratio2 = (float)this.tick / 20.0f;
                    if (this.sprite == null) {
                        this.remove();
                        break;
                    }
                    this.xx = (int)SineInterpolator.instance.interpolate((float)this.x, (float)this.fx, ratio2);
                    this.yy = (int)SineInterpolator.instance.interpolate((float)this.y, (float)this.fy, ratio2);
                    this.sprite.setLocation(this.xx, this.yy, 0);
                    if (this.tick < 20) break;
                    this.phase = 5;
                    this.tick = 0;
                    break;
                }
                case 5: {
                    this.remove();
                }
            }
        }

        public boolean isActive() {
            return this.phase != 5;
        }

        public void spawn(Screen screen) {
            if (this.sprite != null) {
                return;
            }
            this.phase = 0;
            this.tick = 0;
            this.screen = screen;
            int d = this.direction;
            if (d == 0) {
                d = Util.random((int)1, (int)4);
            }
            switch (d) {
                case 1: {
                    this.dx = this.x - Game.getWidth();
                    this.dy = this.y;
                    this.fx = this.x + Game.getWidth();
                    this.fy = this.y;
                    break;
                }
                case 2: {
                    this.dx = this.x + Game.getWidth();
                    this.dy = this.y;
                    this.fx = this.x - Game.getWidth();
                    this.fy = this.y;
                    break;
                }
                case 3: {
                    this.dx = this.x;
                    this.dy = this.y - Game.getHeight();
                    this.fx = this.x;
                    this.fy = this.y + Game.getHeight();
                    break;
                }
                case 4: {
                    this.dx = this.x;
                    this.dy = this.y + Game.getHeight();
                    this.fx = this.x;
                    this.fy = this.y - Game.getHeight();
                }
            }
            screen.addTickable((Tickable)this);
        }

        public void remove() {
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.sprite = null;
            }
            this.phase = 5;
        }
    }
}

