/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.util.Util;
import invaders.Behaviour;
import invaders.Bullet;
import invaders.Entity;
import invaders.GameScreen;
import invaders.Invaders;
import invaders.Laser;
import invaders.Parachute;
import invaders.Player;
import invaders.Res;
import invaders.SFX;
import invaders.Smartbomb;
import invaders.Turret;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.LabelEffect;
import net.puppygames.applet.widgets.PowerDisplay;
import org.lwjgl.util.Color;

public class Gidrah
extends Entity {
    private static final long serialVersionUID = 1L;
    private static final float BOSS_SPAWN_SPEED = 0.5f;
    private static final int BOSS_SPAWN_END = 200;
    private static final LinkedList GIDRAHS = new LinkedList();
    private static final float MAX_VY = -3.0f;
    private static final float ACCELERATION = 0.02f;
    private static final float DECELERATION = 0.99f;
    private static final float VX_RANGE = 0.5f;
    private static final int CRITICAL_HIT_COUNT = 19;
    private static final int PARACHUTE_COUNT = 29;
    private static int criticalHitCounter;
    private static int parachuteCounter;
    private transient Behaviour behaviour;
    private Behaviour.Instance behaviourInstance;
    private int hitPoints;
    private int initialHitPoints;
    private boolean dontNoseDive;
    private Gidrah master;
    private int initialRow;
    private boolean critical;
    private float nosediveVX;
    private float nosediveVY;
    private transient Emitter criticalHitEmitter;
    private int flashTick;
    private Turret[] turret;
    private Smartbomb hitBySmartBomb;
    private boolean autoRemove = true;
    private transient SoundEffect soundEffect;
    private int phase;
    private static final int PHASE_SPAWN = 0;
    private static final int PHASE_NORMAL = 1;
    private Bullet immune;
    private transient PowerDisplay powerDisplayInstance;
    private transient ALBuffer soundResource;
    static /* synthetic */ Class class$0;

    public Gidrah(Behaviour behaviour, int initialRow) {
        this.behaviour = behaviour;
        this.initialRow = initialRow;
        int totalMultiplier = Invaders.getGameState().getTotalMultiplier();
        this.hitPoints = behaviour.getHitPoints() + totalMultiplier / 30;
        if (behaviour.isBoss()) {
            this.hitPoints += totalMultiplier;
        }
        this.initialHitPoints = this.hitPoints;
    }

    public void setSound(ALBuffer soundResource) {
        this.soundResource = soundResource;
        if (this.soundEffect != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.soundEffect.stop((Object)clazz);
            this.soundEffect = null;
        }
        if (this.soundResource != null) {
            this.soundEffect = Game.allocateSound((ALBuffer)this.soundResource);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.behaviour.getName());
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            this.behaviour = (Behaviour)Resources.get((String)stream.readUTF());
            stream.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void doSpawn() {
        GIDRAHS.add(this);
        this.behaviourInstance = this.behaviour.init(this, this.initialRow);
        if (this.behaviour.isBoss()) {
            this.setLocation(Game.getWidth() / 2, (float)Game.getHeight() + this.getRadius());
            this.powerDisplayInstance = Res.getBossPowerDisplay().spawn((Screen)GameScreen.getInstance());
            this.powerDisplayInstance.setUsed(10);
        }
        this.init(this.getX(), this.getY());
    }

    protected void doRespawn() {
        GIDRAHS.add(this);
        this.behaviour.reinit(this);
        if (this.behaviour.isBoss()) {
            this.powerDisplayInstance = Res.getBossPowerDisplay().spawn((Screen)GameScreen.getInstance());
            this.powerDisplayInstance.setUsed(10);
            this.powerDisplayInstance.setVisible(false);
        }
        if (this.critical) {
            this.createCriticalHitEmitter();
        }
    }

    protected void doRemove() {
        if (this.behaviourInstance != null) {
            this.behaviourInstance.onRemove();
        }
        GIDRAHS.remove(this);
        if (this.criticalHitEmitter != null) {
            this.criticalHitEmitter.remove();
        }
        if (this.powerDisplayInstance != null) {
            this.powerDisplayInstance.cleanup();
            this.powerDisplayInstance = null;
        }
        if (this.soundEffect != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.soundEffect.stop((Object)clazz);
            this.soundEffect = null;
        }
    }

    public static LinkedList getGidrahs() {
        return GIDRAHS;
    }

    public void setBehaviour(Behaviour.Instance behaviour) {
        this.behaviourInstance = behaviour;
    }

    public Behaviour getBehaviour() {
        return this.behaviour;
    }

    public Behaviour.Instance getBehaviourInstance() {
        return this.behaviourInstance;
    }

    public void setHitPoints(int hitPoints) {
        this.hitPoints = hitPoints;
    }

    public boolean canCollide() {
        if (this.behaviour.isBoss()) {
            return this.phase == 1;
        }
        return this.behaviourInstance.canCollide();
    }

    public boolean canCollideWithLaser() {
        return this.canCollide();
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithGidrah(this);
    }

    public void onCollisionWithBullet(Bullet bullet) {
        if (bullet == this.immune) {
            return;
        }
        this.damage(bullet.getDamage(), true);
        this.immune = bullet;
    }

    public void onCollisionWithSmartbomb(Smartbomb smartBomb) {
        if (this.hitBySmartBomb == smartBomb || this.behaviour.isBoss()) {
            return;
        }
        this.hitBySmartBomb = smartBomb;
        this.damage(30, false);
    }

    public void onCollisionWithLaser(Laser laser) {
        this.damage(1, true);
    }

    private void damage(int points, boolean awardMoney) {
        ++parachuteCounter;
        if (!(this.dontNoseDive || Invaders.getGameState().getLevel() <= 0 || this.behaviour.isBoss() || this.critical || ++criticalHitCounter <= 19 - Invaders.getGameState().getMultiplier())) {
            criticalHitCounter = 0;
            this.criticalHit();
            this.hitPoints = points + 1;
        }
        this.hitPoints -= points;
        this.setFlash(true);
        this.flashTick = 2;
        if (this.hitPoints <= 0) {
            this.kill(true, awardMoney);
        } else {
            SFX.ricochet();
            Emitter emitter = this.behaviour.getRicochetEmitter().spawn((Screen)GameScreen.getInstance());
            emitter.setLocation(this.getX(), this.getY());
            if (this.powerDisplayInstance != null) {
                this.powerDisplayInstance.setUsed(10 * this.hitPoints / this.initialHitPoints);
            }
            this.behaviourInstance.onDamaged();
        }
    }

    public void criticalHit() {
        this.critical = true;
        if (parachuteCounter > 29 - Invaders.getGameState().getMultiplier()) {
            parachuteCounter = 0;
            new Parachute(this);
        }
        this.createCriticalHitEmitter();
        this.setAngle(Util.random((int)-8192, (int)8192));
        this.nosediveVX = this.behaviourInstance.getVX() + (float)(Math.random() * 0.5 * 2.0 - 0.5);
        this.nosediveVY = -0.1f;
    }

    private void createCriticalHitEmitter() {
        if (this.criticalHitEmitter != null) {
            return;
        }
        this.criticalHitEmitter = Res.getCriticalHitEmitter().spawn((Screen)GameScreen.getInstance());
        this.criticalHitEmitter.setFloor(19.0f);
        this.criticalHitEmitter.setLocation(this.getX(), this.getY());
    }

    public void onCollisionWithPlayer(Player player) {
        if (this.behaviour != null && !this.behaviour.isBoss()) {
            this.kill(false, true);
        }
    }

    private void kill(boolean award, boolean awardMoney) {
        if (!this.isActive()) {
            return;
        }
        Invaders.getGameState().bumpSaucer();
        if (this.powerDisplayInstance != null) {
            this.powerDisplayInstance.cleanup();
            this.powerDisplayInstance = null;
        }
        if (award) {
            int mult = this.behaviour.isBoss() ? 1 : Invaders.getGameState().getMultiplier();
            int bounty = this.behaviour.isBoss() ? 1000 : this.behaviour.getPoints();
            int pts = this.behaviour.getPoints() * mult;
            Invaders.getGameState().addScore(pts);
            if (awardMoney) {
                Invaders.getGameState().addMoney(bounty);
            }
            if (mult > 1 && awardMoney) {
                LabelEffect effect = new LabelEffect(Res.getSmallFont(), String.valueOf(pts), Color.WHITE, Color.RED, 45, 15);
                effect.spawn((Screen)GameScreen.getInstance());
                effect.setLocation((float)((int)this.getX()), (float)((int)this.getY() + 7));
                effect.setVelocity(0.0f, 0.5f);
                effect.setAcceleration(0.0f, -0.0075f);
                LabelEffect effect2 = new LabelEffect(Res.getSmallFont(), "$" + String.valueOf(bounty), Color.WHITE, Color.YELLOW, 45, 15);
                effect2.spawn((Screen)GameScreen.getInstance());
                effect2.setLocation((float)((int)this.getX()), (float)((int)this.getY() - 7));
                effect2.setVelocity(0.0f, 0.5f);
                effect2.setAcceleration(0.0f, -0.0075f);
                if (this.critical) {
                    LabelEffect effect3 = new LabelEffect(Res.getSmallFont(), "SKILL BONUS 500x" + mult, Color.WHITE, Color.RED, 45, 15);
                    effect3.spawn((Screen)GameScreen.getInstance());
                    effect3.setLocation((float)((int)this.getX()), (float)((int)this.getY() - 20));
                    effect3.setVelocity(0.0f, 0.5f);
                    effect3.setAcceleration(0.0f, -0.0075f);
                    SFX.skillBonus();
                    Invaders.getGameState().addScore(500 * mult);
                }
            } else {
                LabelEffect effect = new LabelEffect(Res.getSmallFont(), String.valueOf(pts), Color.WHITE, Color.RED, 45, 15);
                effect.spawn((Screen)GameScreen.getInstance());
                effect.setLocation((float)((int)this.getX()), (float)((int)this.getY()));
                effect.setVelocity(0.0f, 0.5f);
                effect.setAcceleration(0.0f, -0.0075f);
                if (this.critical && awardMoney) {
                    LabelEffect effect3 = new LabelEffect(Res.getSmallFont(), mult > 1 ? "SKILL BONUS 500x" + mult : "SKILL BONUS 500", Color.WHITE, Color.RED, 45, 15);
                    effect3.spawn((Screen)GameScreen.getInstance());
                    effect3.setLocation((float)((int)this.getX()), (float)((int)this.getY() - 10));
                    effect3.setVelocity(0.0f, 0.5f);
                    effect3.setAcceleration(0.0f, -0.0075f);
                    SFX.skillBonus();
                    Invaders.getGameState().addScore(500);
                }
            }
            this.behaviourInstance.onKilled();
        }
        this.behaviour.deathNoise();
        Emitter e = this.behaviour.getExplosionEmitter().spawn((Screen)GameScreen.getInstance());
        e.setLocation(this.getX(), this.getY());
        this.remove();
    }

    public float getRadius() {
        return this.behaviour.getRadius();
    }

    protected void doTick() {
        if (this.behaviour.isBoss() && this.phase == 0) {
            this.setLocation(this.getX(), this.getY() - 0.5f);
            if (this.powerDisplayInstance != null) {
                this.powerDisplayInstance.setLocation((int)this.getX() - 29, (int)this.getY() + 36);
            }
            if (this.getY() <= 200.0f) {
                this.phase = 1;
                this.behaviourInstance.init();
            } else {
                return;
            }
        }
        if (this.flashTick > 0) {
            --this.flashTick;
            if (this.flashTick == 0) {
                this.setFlash(false);
            }
        }
        if (this.critical) {
            if (this.nosediveVY > -3.0f) {
                this.nosediveVY -= 0.02f;
            }
            this.nosediveVX *= 0.99f;
            this.setLocation(this.getX() + this.nosediveVX, this.getY() + this.nosediveVY);
            this.criticalHitEmitter.setLocation(this.getX(), this.getY());
            if (this.getY() <= 19.0f + this.getRadius()) {
                this.kill(false, true);
            }
        } else {
            this.behaviourInstance.tick();
        }
        if (this.powerDisplayInstance != null) {
            this.powerDisplayInstance.setLocation((int)this.getX() - 30, (int)this.getY() + 36);
        }
    }

    public final void setMaster(Gidrah master) {
        this.master = master;
    }

    public final Gidrah getMaster() {
        return this.master;
    }

    public int getInitialRow() {
        return this.initialRow;
    }

    public void setAutoRemove(boolean autoRemove) {
        this.autoRemove = autoRemove;
    }

    protected boolean autoRemove() {
        return this.autoRemove;
    }

    private void init(float x, float y) {
        this.setLocation(x, y);
        this.behaviourInstance.init();
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setDontNoseDive(boolean dontNoseDive) {
        this.dontNoseDive = dontNoseDive;
    }
}

