/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.util.plugins;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class PluginLoader
extends URLClassLoader {
    static final boolean DEBUG = false;
    File parentDir;
    boolean localDLLs = true;
    static /* synthetic */ Class class$0;

    public PluginLoader(File jf) throws MalformedURLException {
        super(new URL[]{jf.toURL()}, Thread.currentThread().getContextClassLoader());
        this.parentDir = jf.getParentFile();
        if (System.getProperty("net.java.games.util.plugins.nolocalnative") != null) {
            this.localDLLs = false;
        }
    }

    protected String findLibrary(String libname) {
        if (this.localDLLs) {
            String libpath = String.valueOf(this.parentDir.getPath()) + File.separator + System.mapLibraryName(libname);
            return libpath;
        }
        return super.findLibrary(libname);
    }

    public boolean attemptPluginDefine(Class pc) {
        return !pc.isInterface() && this.classImplementsPlugin(pc);
    }

    private boolean classImplementsPlugin(Class testClass) {
        if (testClass == null) {
            return false;
        }
        Class<?>[] implementedInterfaces = testClass.getInterfaces();
        int i = 0;
        while (i < implementedInterfaces.length) {
            Class<?> clazz = implementedInterfaces[i];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("net.java.games.util.plugins.Plugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < implementedInterfaces.length) {
            if (this.classImplementsPlugin(implementedInterfaces[i])) {
                return true;
            }
            ++i;
        }
        return this.classImplementsPlugin(testClass.getSuperclass());
    }
}

