/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.AbstractComponent;
import net.java.games.input.Component;
import net.java.games.input.InputController;
import net.java.games.input.InputControllerElement;
import net.java.games.input.Mouse;
import net.java.games.input.OSXEnvironmentPlugin;

public class OSXMouse
extends Mouse
implements InputController {
    private OSXEnvironmentPlugin plugin;
    private long lpDevice;
    private long lpQueue;
    private int buttonCount = 0;

    public OSXMouse(OSXEnvironmentPlugin plugin, long lpDevice, String productName) {
        super(productName);
        this.plugin = plugin;
        this.lpDevice = lpDevice;
        this.openDevice();
        this.buttons = new ButtonsImpl();
        this.ball = new BallImpl();
    }

    public void openDevice() {
        this.lpQueue = this.plugin.openDevice(this.lpDevice, 32);
    }

    public void closeDevice() {
        this.plugin.closeDevice(this.lpDevice, this.lpQueue);
    }

    public boolean poll() {
        this.plugin.pollDevice(this.lpQueue);
        return true;
    }

    public void addControllerElement(InputControllerElement element) {
        block0 : switch (element.getUsagePage()) {
            case 9: {
                ++this.buttonCount;
                System.out.println("Adding button [" + this.buttonCount + "]");
                ((ButtonsImpl)this.buttons).addButton(element);
                break;
            }
            case 1: {
                switch (element.getUsage()) {
                    case 1: {
                        System.out.println("Adding pointer - this will contain axis");
                        break block0;
                    }
                    case 48: {
                        ((BallImpl)this.ball).addXAxis(element);
                        System.out.println("Adding X Axis");
                        break block0;
                    }
                    case 49: {
                        ((BallImpl)this.ball).addYAxis(element);
                        System.out.println("Adding Y Axis");
                        break block0;
                    }
                    case 56: {
                        ((BallImpl)this.ball).addWheelAxis(element);
                        System.out.println("Adding wheel");
                    }
                }
            }
        }
    }

    class BallImpl
    extends Mouse.Ball {
        public BallImpl() {
            super(String.valueOf(OSXMouse.this.getName()) + " ball");
        }

        public void addXAxis(InputControllerElement element) {
            this.x = new BallAxis(Component.Identifier.Axis.X, element);
        }

        public void addYAxis(InputControllerElement element) {
            this.y = new BallAxis(Component.Identifier.Axis.Y, element);
        }

        public void addWheelAxis(InputControllerElement element) {
            this.wheel = new BallAxis(Component.Identifier.Axis.SLIDER, element);
        }
    }

    class ButtonsImpl
    extends Mouse.Buttons {
        public ButtonsImpl() {
            super(String.valueOf(OSXMouse.this.getName()) + " buttons");
        }

        public void addButton(InputControllerElement element) {
            if (this.left == null) {
                this.left = new ButtonImpl(Component.Identifier.Button.LEFT, element);
            } else if (this.right == null) {
                this.right = new ButtonImpl(Component.Identifier.Button.RIGHT, element);
            } else if (this.middle == null) {
                this.middle = new ButtonImpl(Component.Identifier.Button.MIDDLE, element);
            }
        }
    }

    class ButtonImpl
    extends Mouse.Button {
        private long hidCookie;
        private boolean isRelative;

        public ButtonImpl(Component.Identifier.Button id, InputControllerElement element) {
            super(id.getName(), id);
            this.hidCookie = element.getHidCookie();
            this.isRelative = element.isRelative();
        }

        public float getPollData() {
            return OSXMouse.this.plugin.pollElement(OSXMouse.this.lpDevice, this.hidCookie);
        }

        public boolean isRelative() {
            return this.isRelative;
        }
    }

    class BallAxis
    extends AbstractComponent {
        private long hidCookie;
        private boolean isRelative;

        public BallAxis(Component.Identifier.Axis id, InputControllerElement element) {
            super(id.getName(), id);
            this.hidCookie = element.getHidCookie();
            this.isRelative = element.isRelative();
        }

        public float getPollData() {
            return OSXMouse.this.plugin.pollElement(OSXMouse.this.lpDevice, this.hidCookie);
        }

        public boolean isRelative() {
            return this.isRelative;
        }

        public boolean isAnalog() {
            return true;
        }
    }
}

