/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.util.HashMap;
import net.java.games.input.Component;
import net.java.games.input.InputController;
import net.java.games.input.InputControllerElement;
import net.java.games.input.Keyboard;
import net.java.games.input.OSXEnvironmentPlugin;
import net.java.games.input.StandardKeyboard;

public class OSXKeyboard
extends StandardKeyboard
implements InputController {
    private static final int[] CROSSTABLE;
    private OSXEnvironmentPlugin plugin;
    private long lpDevice;
    private long lpQueue;
    private HashMap keys = new HashMap();
    private static int[] COOKIETABLE;

    static {
        int[] nArray = new int[124];
        nArray[1] = 41;
        nArray[2] = 30;
        nArray[3] = 31;
        nArray[4] = 32;
        nArray[5] = 33;
        nArray[6] = 34;
        nArray[7] = 35;
        nArray[8] = 36;
        nArray[9] = 37;
        nArray[10] = 38;
        nArray[11] = 39;
        nArray[12] = 45;
        nArray[13] = 46;
        nArray[14] = 42;
        nArray[15] = 43;
        nArray[16] = 20;
        nArray[17] = 26;
        nArray[18] = 8;
        nArray[19] = 21;
        nArray[20] = 23;
        nArray[21] = 28;
        nArray[22] = 24;
        nArray[23] = 12;
        nArray[24] = 18;
        nArray[25] = 19;
        nArray[26] = 47;
        nArray[27] = 48;
        nArray[28] = 40;
        nArray[29] = 224;
        nArray[30] = 4;
        nArray[31] = 22;
        nArray[32] = 7;
        nArray[33] = 9;
        nArray[34] = 10;
        nArray[35] = 11;
        nArray[36] = 13;
        nArray[37] = 14;
        nArray[38] = 15;
        nArray[39] = 51;
        nArray[40] = 52;
        nArray[41] = 53;
        nArray[42] = 225;
        nArray[43] = 49;
        nArray[44] = 29;
        nArray[45] = 27;
        nArray[46] = 6;
        nArray[47] = 25;
        nArray[48] = 5;
        nArray[49] = 17;
        nArray[50] = 16;
        nArray[51] = 54;
        nArray[52] = 55;
        nArray[53] = 56;
        nArray[54] = 229;
        nArray[55] = 85;
        nArray[56] = 226;
        nArray[57] = 44;
        nArray[58] = 57;
        nArray[59] = 58;
        nArray[60] = 59;
        nArray[61] = 60;
        nArray[62] = 61;
        nArray[63] = 62;
        nArray[64] = 63;
        nArray[65] = 64;
        nArray[66] = 65;
        nArray[67] = 66;
        nArray[68] = 67;
        nArray[69] = 83;
        nArray[70] = 71;
        nArray[71] = 95;
        nArray[72] = 96;
        nArray[73] = 97;
        nArray[74] = 86;
        nArray[75] = 92;
        nArray[76] = 93;
        nArray[77] = 94;
        nArray[78] = 87;
        nArray[79] = 89;
        nArray[80] = 90;
        nArray[81] = 91;
        nArray[82] = 98;
        nArray[83] = 99;
        nArray[84] = 68;
        nArray[85] = 69;
        nArray[86] = 104;
        nArray[87] = 105;
        nArray[88] = 106;
        nArray[89] = 135;
        nArray[90] = 136;
        nArray[91] = 137;
        nArray[92] = 138;
        nArray[93] = 103;
        nArray[94] = 139;
        nArray[95] = 140;
        nArray[96] = 141;
        nArray[97] = 159;
        nArray[98] = 142;
        nArray[99] = 120;
        nArray[100] = 143;
        nArray[101] = 144;
        nArray[102] = 88;
        nArray[103] = 228;
        nArray[104] = 133;
        nArray[105] = 84;
        nArray[106] = 154;
        nArray[107] = 230;
        nArray[108] = 72;
        nArray[109] = 74;
        nArray[110] = 82;
        nArray[111] = 157;
        nArray[112] = 80;
        nArray[113] = 79;
        nArray[114] = 77;
        nArray[115] = 81;
        nArray[116] = 162;
        nArray[117] = 73;
        nArray[118] = 76;
        nArray[119] = 227;
        nArray[120] = 231;
        nArray[121] = 101;
        nArray[122] = 102;
        nArray[123] = 102;
        CROSSTABLE = nArray;
        COOKIETABLE = new int[CROSSTABLE.length];
    }

    public OSXKeyboard(OSXEnvironmentPlugin plugin, long lpDevice, String productName) {
        super(productName);
        this.plugin = plugin;
        this.lpDevice = lpDevice;
        this.openDevice();
    }

    public void openDevice() {
        this.lpQueue = this.plugin.openDevice(this.lpDevice, 256);
    }

    public void closeDevice() {
        this.plugin.closeDevice(this.lpDevice, this.lpQueue);
    }

    public void addControllerElement(InputControllerElement element) {
        System.out.println("Adding keyboard elements usage page[" + element.getUsagePage() + "] usage [" + element.getUsage() + "] type [" + element.getElementType() + "]");
        switch (element.getUsagePage()) {
            case 7: {
                System.out.println("Found keyboard element");
                if (element.getElementType() == 2) {
                    System.out.println("Registering button-key (usage page [" + element.getUsagePage() + "], usage[" + element.getUsage() + "],  elementType [" + element.getElementType() + "], hidCookie [" + element.getHidCookie() + "])");
                    if (this.keys.get(new Long(element.getUsage())) == null) {
                        this.plugin.registerDeviceElement(this.lpQueue, element.getHidCookie());
                        this.keys.put(new Long(element.getUsage()), element);
                        System.out.println("Registered key [" + element.getHidCookie() + "]");
                        break;
                    }
                    System.out.println("Ignoring key [" + element.getHidCookie() + "] already enumerated.");
                    break;
                }
                System.out.println("Ignoring non-button-key (usage page [" + element.getUsagePage() + "], usage[" + element.getUsage() + "],  elementType [" + element.getElementType() + "], hidCookie [" + element.getHidCookie() + "])");
            }
        }
    }

    public boolean poll() {
        this.plugin.pollDevice(this.lpQueue);
        return true;
    }

    protected boolean isKeyPressed(Keyboard.Key key) {
        Component.Identifier.Key id = (Component.Identifier.Key)key.getIdentifier();
        int keyIndex = id.getKeyIndex();
        int usage = CROSSTABLE[keyIndex];
        InputControllerElement element = (InputControllerElement)this.keys.get(new Long(usage));
        if (element != null) {
            int value = this.plugin.pollElement(this.lpDevice, element.getHidCookie());
            System.out.println("Key Poll result [" + value + "]");
            return value == 1;
        }
        return false;
    }
}

