/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.util.ArrayList;
import java.util.List;
import net.java.games.input.AbstractComponent;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.InputController;
import net.java.games.input.InputControllerElement;
import net.java.games.input.OSXEnvironmentPlugin;

public class OSXJoystick
extends AbstractController
implements InputController {
    private OSXEnvironmentPlugin plugin;
    private long lpDevice;
    private long lpQueue;
    private int buttonCount = 0;
    private List buttons = new ArrayList();
    private Axis xAxis = null;
    private Axis yAxis = null;
    private Axis zAxis = null;
    private Axis xAxisRotation = null;
    private Axis yAxisRotation = null;
    private Axis zAxisRotation = null;
    private Axis slider = null;
    private Axis hat = null;

    public OSXJoystick(OSXEnvironmentPlugin plugin, long lpDevice, String productName) {
        super(productName);
        this.plugin = plugin;
        this.lpDevice = lpDevice;
        this.openDevice();
    }

    public Controller.Type getType() {
        return Controller.Type.STICK;
    }

    public boolean poll() {
        this.plugin.pollDevice(this.lpQueue);
        return true;
    }

    public void openDevice() {
        this.lpQueue = this.plugin.openDevice(this.lpDevice, 32);
    }

    public void closeDevice() {
        this.plugin.closeDevice(this.lpDevice, this.lpQueue);
    }

    public void pollDevice() {
        this.plugin.pollDevice(this.lpQueue);
    }

    public Component[] getComponents() {
        ArrayList<Axis> cpList = new ArrayList<Axis>(this.buttons);
        if (this.xAxis != null) {
            cpList.add(this.xAxis);
        }
        if (this.yAxis != null) {
            cpList.add(this.yAxis);
        }
        if (this.zAxis != null) {
            cpList.add(this.zAxis);
        }
        if (this.xAxisRotation != null) {
            cpList.add(this.xAxisRotation);
        }
        if (this.yAxisRotation != null) {
            cpList.add(this.yAxisRotation);
        }
        if (this.zAxisRotation != null) {
            cpList.add(this.zAxisRotation);
        }
        if (this.slider != null) {
            cpList.add(this.slider);
        }
        if (this.hat != null) {
            cpList.add(this.hat);
        }
        Component[] ca = new Component[cpList.size()];
        return cpList.toArray(ca);
    }

    public void addControllerElement(InputControllerElement element) {
        switch (element.getElementType()) {
            case 2: {
                Button button = null;
                switch (this.buttonCount) {
                    case 0: {
                        button = new Button(Component.Identifier.Button.TRIGGER, element);
                        break;
                    }
                    case 1: {
                        button = new Button(Component.Identifier.Button._2, element);
                        break;
                    }
                    case 2: {
                        button = new Button(Component.Identifier.Button._3, element);
                        break;
                    }
                    case 3: {
                        button = new Button(Component.Identifier.Button._4, element);
                        break;
                    }
                    case 4: {
                        button = new Button(Component.Identifier.Button._5, element);
                        break;
                    }
                    case 5: {
                        button = new Button(Component.Identifier.Button._6, element);
                        break;
                    }
                    case 6: {
                        button = new Button(Component.Identifier.Button._7, element);
                        break;
                    }
                    case 7: {
                        button = new Button(Component.Identifier.Button._8, element);
                        break;
                    }
                    case 8: {
                        button = new Button(Component.Identifier.Button._9, element);
                        break;
                    }
                    default: {
                        String name = String.valueOf(this.buttonCount + 1);
                        button = new Button(new Component.Identifier.Button(name), element);
                    }
                }
                this.buttons.add(button);
                ++this.buttonCount;
                System.out.println("Adding button [" + this.buttonCount + "]");
                break;
            }
            case 1: 
            case 3: {
                switch (element.getUsage()) {
                    case 48: {
                        this.xAxis = new Axis(Component.Identifier.Axis.X, element);
                        break;
                    }
                    case 49: {
                        this.yAxis = new Axis(Component.Identifier.Axis.Y, element);
                        break;
                    }
                    case 50: {
                        this.zAxis = new Axis(Component.Identifier.Axis.Z, element);
                        break;
                    }
                    case 51: {
                        this.xAxisRotation = new Axis(Component.Identifier.Axis.RX, element);
                        break;
                    }
                    case 52: {
                        this.yAxisRotation = new Axis(Component.Identifier.Axis.RY, element);
                        break;
                    }
                    case 53: {
                        this.zAxisRotation = new Axis(Component.Identifier.Axis.RZ, element);
                        break;
                    }
                    case 54: {
                        this.slider = new Axis(Component.Identifier.Axis.SLIDER, element);
                        break;
                    }
                    case 57: {
                        this.hat = new Axis(Component.Identifier.Axis.POV, element);
                        break;
                    }
                    default: {
                        System.out.println("*Unknown axis");
                    }
                }
                System.out.println("*Adding axis");
                break;
            }
            case 4: {
                System.out.println("*Adding scancode");
                break;
            }
            case 129: {
                System.out.println("*Adding forcefeedback");
                break;
            }
            case 257: {
                System.out.println("*Adding feature");
                break;
            }
            case 513: {
                System.out.println("*Adding collection");
            }
        }
    }

    class Button
    extends AbstractComponent {
        private long hidCookie;
        private boolean isRelative;

        public Button(Component.Identifier.Button id, InputControllerElement element) {
            super(id.getName(), id);
            this.hidCookie = element.getHidCookie();
            this.isRelative = element.isRelative();
        }

        public float getPollData() {
            return OSXJoystick.this.plugin.pollElement(OSXJoystick.this.lpDevice, this.hidCookie);
        }

        public boolean isRelative() {
            return this.isRelative;
        }
    }

    class Axis
    extends AbstractComponent {
        private long hidCookie;
        private boolean isRelative;

        public Axis(Component.Identifier id, InputControllerElement element) {
            super(id.getName(), id);
            this.hidCookie = element.getHidCookie();
            this.isRelative = element.isRelative();
        }

        public float getPollData() {
            return OSXJoystick.this.plugin.pollElement(OSXJoystick.this.lpDevice, this.hidCookie);
        }

        public boolean isRelative() {
            return this.isRelative;
        }
    }
}

