/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.AbstractController;
import net.java.games.input.InputController;
import net.java.games.input.InputControllerElement;
import net.java.games.input.OSXEnvironmentPlugin;

public class OSXGamepad
extends AbstractController
implements InputController {
    private OSXEnvironmentPlugin plugin;
    private long lpDevice;
    private long lpQueue;

    public OSXGamepad(OSXEnvironmentPlugin plugin, long lpDevice, String productName) {
        super(productName);
        this.plugin = plugin;
        this.lpDevice = lpDevice;
        this.openDevice();
    }

    public boolean poll() {
        this.plugin.pollDevice(this.lpQueue);
        return true;
    }

    public void openDevice() {
        this.lpQueue = this.plugin.openDevice(this.lpDevice, 32);
    }

    public void closeDevice() {
        this.plugin.closeDevice(this.lpDevice, this.lpQueue);
    }

    public void pollDevice() {
        this.plugin.pollDevice(this.lpQueue);
    }

    public void addControllerElement(InputControllerElement element) {
        switch (element.getElementType()) {
            case 1: {
                System.out.println("*Adding misc component");
                break;
            }
            case 2: {
                System.out.println("*Adding button");
                break;
            }
            case 3: {
                System.out.println("*Adding axis");
                break;
            }
            case 4: {
                System.out.println("*Adding scancode");
                break;
            }
            case 129: {
                System.out.println("*Adding forcefeedback");
                break;
            }
            case 257: {
                System.out.println("*Adding feature");
                break;
            }
            case 513: {
                System.out.println("*Adding collection");
            }
        }
    }
}

