/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.util.HashMap;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.InputController;
import net.java.games.input.InputControllerElement;
import net.java.games.input.OSXGamepad;
import net.java.games.input.OSXJoystick;
import net.java.games.input.OSXKeyboard;
import net.java.games.input.OSXMouse;
import net.java.games.util.plugins.Plugin;

public class OSXEnvironmentPlugin
extends ControllerEnvironment
implements Plugin {
    public static final int HID_DEVICE_MOUSE = 2;
    public static final int HID_DEVICE_JOYSTICK = 4;
    public static final int HID_DEVICE_GAMEPAD = 5;
    public static final int HID_DEVICE_KEYBOARD = 6;
    public static final int HID_USAGE_POINTER = 1;
    public static final int HID_USAGE_XAXIS = 48;
    public static final int HID_USAGE_YAXIS = 49;
    public static final int HID_USAGE_ZAXIS = 50;
    public static final int HID_USAGE_XAXIS_ROTATION = 51;
    public static final int HID_USAGE_YAXIS_ROTATION = 52;
    public static final int HID_USAGE_ZAXIS_ROTATION = 53;
    public static final int HID_USAGE_SLIDER = 54;
    public static final int HID_USAGE_DIAL = 55;
    public static final int HID_USAGE_WHEEL = 56;
    public static final int HID_USAGE_HAT = 57;
    public static final int HID_USAGE_DPAD_UP = 144;
    public static final int HID_USAGE_DPAD_DOWN = 145;
    public static final int HID_USAGE_DPAD_LEFT = 146;
    public static final int HID_USAGE_DPAD_RIGHT = 147;
    public static final int HID_USAGE_KEYBOARD_ERRORROLLOVER = 1;
    public static final int HID_USAGE_KEYBOARD_POSTFAIL = 2;
    public static final int HID_USAGE_KEYBOARD_ERRORUNDEFINED = 3;
    public static final int HID_USAGE_KEYBOARD_A = 4;
    public static final int HID_USAGE_KEYBOARD_B = 5;
    public static final int HID_USAGE_KEYBOARD_C = 6;
    public static final int HID_USAGE_KEYBOARD_D = 7;
    public static final int HID_USAGE_KEYBOARD_E = 8;
    public static final int HID_USAGE_KEYBOARD_F = 9;
    public static final int HID_USAGE_KEYBOARD_G = 10;
    public static final int HID_USAGE_KEYBOARD_H = 11;
    public static final int HID_USAGE_KEYBOARD_I = 12;
    public static final int HID_USAGE_KEYBOARD_J = 13;
    public static final int HID_USAGE_KEYBOARD_K = 14;
    public static final int HID_USAGE_KEYBOARD_L = 15;
    public static final int HID_USAGE_KEYBOARD_M = 16;
    public static final int HID_USAGE_KEYBOARD_N = 17;
    public static final int HID_USAGE_KEYBOARD_O = 18;
    public static final int HID_USAGE_KEYBOARD_P = 19;
    public static final int HID_USAGE_KEYBOARD_Q = 20;
    public static final int HID_USAGE_KEYBOARD_R = 21;
    public static final int HID_USAGE_KEYBOARD_S = 22;
    public static final int HID_USAGE_KEYBOARD_T = 23;
    public static final int HID_USAGE_KEYBOARD_U = 24;
    public static final int HID_USAGE_KEYBOARD_V = 25;
    public static final int HID_USAGE_KEYBOARD_W = 26;
    public static final int HID_USAGE_KEYBOARD_X = 27;
    public static final int HID_USAGE_KEYBOARD_Y = 28;
    public static final int HID_USAGE_KEYBOARD_Z = 29;
    public static final int HID_USAGE_KEYBOARD_1 = 30;
    public static final int HID_USAGE_KEYBOARD_2 = 31;
    public static final int HID_USAGE_KEYBOARD_3 = 32;
    public static final int HID_USAGE_KEYBOARD_4 = 33;
    public static final int HID_USAGE_KEYBOARD_5 = 34;
    public static final int HID_USAGE_KEYBOARD_6 = 35;
    public static final int HID_USAGE_KEYBOARD_7 = 36;
    public static final int HID_USAGE_KEYBOARD_8 = 37;
    public static final int HID_USAGE_KEYBOARD_9 = 38;
    public static final int HID_USAGE_KEYBOARD_0 = 39;
    public static final int HID_USAGE_KEYBOARD_ENTER = 40;
    public static final int HID_USAGE_KEYBOARD_ESCAPE = 41;
    public static final int HID_USAGE_KEYBOARD_BACKSPACE = 42;
    public static final int HID_USAGE_KEYBOARD_TAB = 43;
    public static final int HID_USAGE_KEYBOARD_SPACEBAR = 44;
    public static final int HID_USAGE_KEYBOARD_HYPHEN = 45;
    public static final int HID_USAGE_KEYBOARD_EQUALSIGN = 46;
    public static final int HID_USAGE_KEYBOARD_OPENBRACKET = 47;
    public static final int HID_USAGE_KEYBOARD_CLOSEBRACKET = 48;
    public static final int HID_USAGE_KEYBOARD_BACKSLASH = 49;
    public static final int HID_USAGE_KEYBOARD_NONUSPOUNT = 50;
    public static final int HID_USAGE_KEYBOARD_SEMICOLON = 51;
    public static final int HID_USAGE_KEYBOARD_QUOTE = 52;
    public static final int HID_USAGE_KEYBOARD_TILDE = 53;
    public static final int HID_USAGE_KEYBOARD_COMMA = 54;
    public static final int HID_USAGE_KEYBOARD_PERIOD = 55;
    public static final int HID_USAGE_KEYBOARD_SLASH = 56;
    public static final int HID_USAGE_KEYBOARD_CAPSLOCK = 57;
    public static final int HID_USAGE_KEYBOARD_F1 = 58;
    public static final int HID_USAGE_KEYBOARD_F2 = 59;
    public static final int HID_USAGE_KEYBOARD_F3 = 60;
    public static final int HID_USAGE_KEYBOARD_F4 = 61;
    public static final int HID_USAGE_KEYBOARD_F5 = 62;
    public static final int HID_USAGE_KEYBOARD_F6 = 63;
    public static final int HID_USAGE_KEYBOARD_F7 = 64;
    public static final int HID_USAGE_KEYBOARD_F8 = 65;
    public static final int HID_USAGE_KEYBOARD_F9 = 66;
    public static final int HID_USAGE_KEYBOARD_F10 = 67;
    public static final int HID_USAGE_KEYBOARD_F11 = 68;
    public static final int HID_USAGE_KEYBOARD_F12 = 69;
    public static final int HID_USAGE_KEYBOARD_PRINTSCREEN = 70;
    public static final int HID_USAGE_KEYBOARD_SCROLLLOCK = 71;
    public static final int HID_USAGE_KEYBOARD_PAUSE = 72;
    public static final int HID_USAGE_KEYBOARD_INSERT = 73;
    public static final int HID_USAGE_KEYBOARD_HOME = 74;
    public static final int HID_USAGE_KEYBOARD_PAGEUP = 75;
    public static final int HID_USAGE_KEYBOARD_DELETE = 76;
    public static final int HID_USAGE_KEYBOARD_END = 77;
    public static final int HID_USAGE_KEYBOARD_PAGEDOWN = 78;
    public static final int HID_USAGE_KEYBOARD_RIGHTARROW = 79;
    public static final int HID_USAGE_KEYBOARD_LEFTARROW = 80;
    public static final int HID_USAGE_KEYBOARD_DOWNARROW = 81;
    public static final int HID_USAGE_KEYBOARD_UPARROW = 82;
    public static final int HID_USAGE_KEYPAD_NUMLOCK = 83;
    public static final int HID_USAGE_KEYPAD_SLASH = 84;
    public static final int HID_USAGE_KEYPAD_ASTERICK = 85;
    public static final int HID_USAGE_KEYPAD_HYPHEN = 86;
    public static final int HID_USAGE_KEYPAD_PLUS = 87;
    public static final int HID_USAGE_KEYPAD_ENTER = 88;
    public static final int HID_USAGE_KEYPAD_1 = 89;
    public static final int HID_USAGE_KEYPAD_2 = 90;
    public static final int HID_USAGE_KEYPAD_3 = 91;
    public static final int HID_USAGE_KEYPAD_4 = 92;
    public static final int HID_USAGE_KEYPAD_5 = 93;
    public static final int HID_USAGE_KEYPAD_6 = 94;
    public static final int HID_USAGE_KEYPAD_7 = 95;
    public static final int HID_USAGE_KEYPAD_8 = 96;
    public static final int HID_USAGE_KEYPAD_9 = 97;
    public static final int HID_USAGE_KEYPAD_0 = 98;
    public static final int HID_USAGE_KEYPAD_PERIOD = 99;
    public static final int HID_USAGE_KEYBOARD_NONUSBACKSLASH = 100;
    public static final int HID_USAGE_KEYBOARD_APPLICATION = 101;
    public static final int HID_USAGE_KEYBOARD_POWER = 102;
    public static final int HID_USAGE_KEYPAD_EQUALSIGN = 103;
    public static final int HID_USAGE_KEYBOARD_F13 = 104;
    public static final int HID_USAGE_KEYBOARD_F14 = 105;
    public static final int HID_USAGE_KEYBOARD_F15 = 106;
    public static final int HID_USAGE_KEYBOARD_F16 = 107;
    public static final int HID_USAGE_KEYBOARD_F17 = 108;
    public static final int HID_USAGE_KEYBOARD_F18 = 109;
    public static final int HID_USAGE_KEYBOARD_F19 = 110;
    public static final int HID_USAGE_KEYBOARD_F20 = 111;
    public static final int HID_USAGE_KEYBOARD_F21 = 112;
    public static final int HID_USAGE_KEYBOARD_F22 = 113;
    public static final int HID_USAGE_KEYBOARD_F23 = 114;
    public static final int HID_USAGE_KEYBOARD_F24 = 115;
    public static final int HID_USAGE_KEYBOARD_EXECUTE = 116;
    public static final int HID_USAGE_KEYBOARD_HELP = 117;
    public static final int HID_USAGE_KEYBOARD_MENU = 118;
    public static final int HID_USAGE_KEYBOARD_SELECT = 119;
    public static final int HID_USAGE_KEYBOARD_STOP = 120;
    public static final int HID_USAGE_KEYBOARD_AGAIN = 121;
    public static final int HID_USAGE_KEYBOARD_UNDO = 122;
    public static final int HID_USAGE_KEYBOARD_CUT = 123;
    public static final int HID_USAGE_KEYBOARD_COPY = 124;
    public static final int HID_USAGE_KEYBOARD_PASTE = 125;
    public static final int HID_USAGE_KEYBOARD_FIND = 126;
    public static final int HID_USAGE_KEYBOARD_MUTE = 127;
    public static final int HID_USAGE_KEYBOARD_VOLUMEUP = 128;
    public static final int HID_USAGE_KEYBOARD_VOLUMEDOWN = 129;
    public static final int HID_USAGE_KEYBOARD_LOCKINGCAPSLOCK = 130;
    public static final int HID_USAGE_KEYBOARD_LOCKINGNUMLOCK = 131;
    public static final int HID_USAGE_KEYBOARD_LOCKINGSCROLLLOCK = 132;
    public static final int HID_USAGE_KEYPAD_COMMA = 133;
    public static final int HID_USAGE_KEYPAD_EQUALSSIGNAS400 = 134;
    public static final int HID_USAGE_KEYBOARD_INTERNATIONAL1 = 135;
    public static final int HID_USAGE_KEYBOARD_INTERNATIONAL2 = 136;
    public static final int HID_USAGE_KEYBOARD_INTERNATIONAL3 = 137;
    public static final int HID_USAGE_KEYBOARD_INTERNATIONAL4 = 138;
    public static final int HID_USAGE_KEYBOARD_INTERNATIONAL5 = 139;
    public static final int HID_USAGE_KEYBOARD_INTERNATIONAL6 = 140;
    public static final int HID_USAGE_KEYBOARD_INTERNATIONAL7 = 141;
    public static final int HID_USAGE_KEYBOARD_INTERNATIONAL8 = 142;
    public static final int HID_USAGE_KEYBOARD_INTERNATIONAL9 = 143;
    public static final int HID_USAGE_KEYBOARD_LANG1 = 144;
    public static final int HID_USAGE_KEYBOARD_LANG2 = 145;
    public static final int HID_USAGE_KEYBOARD_LANG3 = 146;
    public static final int HID_USAGE_KEYBOARD_LANG4 = 147;
    public static final int HID_USAGE_KEYBOARD_LANG5 = 148;
    public static final int HID_USAGE_KEYBOARD_LANG6 = 149;
    public static final int HID_USAGE_KEYBOARD_LANG7 = 150;
    public static final int HID_USAGE_KEYBOARD_LANG8 = 151;
    public static final int HID_USAGE_KEYBOARD_LANG9 = 152;
    public static final int HID_USAGE_KEYBOARD_ALTERNATEERASE = 153;
    public static final int HID_USAGE_KEYBOARD_SYSREQORATTENTION = 154;
    public static final int HID_USAGE_KEYBOARD_CANCEL = 155;
    public static final int HID_USAGE_KEYBOARD_CLEAR = 156;
    public static final int HID_USAGE_KEYBOARD_PRIOR = 157;
    public static final int HID_USAGE_KEYBOARD_RETURN = 158;
    public static final int HID_USAGE_KEYBOARD_SEPARATOR = 159;
    public static final int HID_USAGE_KEYBOARD_OUT = 160;
    public static final int HID_USAGE_KEYBOARD_OPER = 161;
    public static final int HID_USAGE_KEYBOARD_CLEARORAGAIN = 162;
    public static final int HID_USAGE_KEYBOARD_CRSELORPROPS = 163;
    public static final int HID_USAGE_KEYBOARD_EXSEL = 164;
    public static final int HID_USAGE_KEYBOARD_LEFTCONTROL = 224;
    public static final int HID_USAGE_KEYBOARD_LEFTSHIFT = 225;
    public static final int HID_USAGE_KEYBOARD_LEFTALT = 226;
    public static final int HID_USAGE_KEYBOARD_LEFTGUI = 227;
    public static final int HID_USAGE_KEYBOARD_RIGHTCONTROL = 228;
    public static final int HID_USAGE_KEYBOARD_RIGHTSHIFT = 229;
    public static final int HID_USAGE_KEYBOARD_RIGHTALT = 230;
    public static final int HID_USAGE_KEYBOARD_RIGHTGUI = 231;
    public static final int HID_USAGE_KEYBOARD__RESERVED = 65535;
    public static final int HID_USAGEPAGE_UNDEFINED = 0;
    public static final int HID_USAGEPAGE_GENERICDESKTOP = 1;
    public static final int HID_USAGEPAGE_SIMULATION = 2;
    public static final int HID_USAGEPAGE_VR = 3;
    public static final int HID_USAGEPAGE_SPORT = 4;
    public static final int HID_USAGEPAGE_GAME = 5;
    public static final int HID_USAGEPAGE_KEYBOARD = 7;
    public static final int HID_USAGEPAGE_LED = 8;
    public static final int HID_USAGEPAGE_BUTTON = 9;
    public static final int HID_USAGEPAGE_ORDINAL = 10;
    public static final int HID_USAGEPAGE_TELEPHONY = 11;
    public static final int HID_USAGEPAGE_CONSUMER = 12;
    public static final int HID_USAGEPAGE_DIGITIZER = 13;
    public static final int HID_USAGEPAGE_PID = 15;
    public static final int HID_USAGEPAGE_UNICODE = 16;
    public static final int HID_USAGEPAGE_ALPHANUMERIC_DISPLAY = 20;
    public static final int HID_USAGEPAGE_POWERDEVICE = 132;
    public static final int HID_USAGEPAGE_BATTERY_SYSTEM = 133;
    public static final int HID_USAGEPAGE_BARCODE_SCANNER = 140;
    public static final int HID_USAGEPAGE_SCALE = 141;
    public static final int HID_USAGEPAGE_CAMERA_CONTROL = 144;
    public static final int HID_USAGEPAGE_ARCADE = 145;
    public static final int HID_USAGEPAGE_VENDOR_DEFINED_START = 65280;
    public static final int HID_ELEMENTTYPE_INPUT_MISC = 1;
    public static final int HID_ELEMENTTYPE_INPUT_BUTTON = 2;
    public static final int HID_ELEMENTTYPE_INPUT_AXIS = 3;
    public static final int HID_ELEMENTTYPE_INPUT_SCANCODES = 4;
    public static final int HID_ELEMENTTYPE_OUTPUT = 129;
    public static final int HID_ELEMENTTYPE_FEATURE = 257;
    public static final int HID_ELEMENTTYPE_COLLECTION = 513;
    private HashMap devices = new HashMap();

    static {
        System.loadLibrary("jinput");
    }

    public native void hidCreate();

    public native void hidDispose();

    public native void enumDevices();

    public native long openDevice(long var1, int var3);

    public native void closeDevice(long var1, long var3);

    public native int pollDevice(long var1);

    public native int pollElement(long var1, long var3);

    public native void registerDeviceElement(long var1, long var3);

    public native void deregisterDeviceElement(long var1, long var3);

    public OSXEnvironmentPlugin() {
        System.out.println("net.java.games.input.OSXEnvironmentPlugin instance created");
        System.out.println("Creating HID engine");
        this.hidCreate();
        System.out.println("Enumerating devices");
        this.enumDevices();
    }

    public void finalize() {
        System.out.println("Disposing HID engine");
        this.hidDispose();
    }

    public Controller[] getControllers() {
        return this.devices.values().toArray(new Controller[0]);
    }

    public Controller createController(long lpDevice, String productName, int usage) {
        switch (usage) {
            case 2: {
                System.out.println("Found mouse [" + productName + "] device address [" + lpDevice + "]");
                return new OSXMouse(this, lpDevice, productName);
            }
            case 4: {
                System.out.println("Found joystick [" + productName + "] device address [" + lpDevice + "]");
                return new OSXJoystick(this, lpDevice, productName);
            }
            case 5: {
                System.out.println("Found gamepad [" + productName + "] device address [" + lpDevice + "]");
                return new OSXGamepad(this, lpDevice, productName);
            }
            case 6: {
                System.out.println("Found keyboard [" + productName + "] device address [" + lpDevice + "]");
                return new OSXKeyboard(this, lpDevice, productName);
            }
        }
        System.out.println("Found device of unknown or unsupported type. Usage[" + usage + "], ProductName[" + productName + "] - ignoring");
        return null;
    }

    private void addController(long lpDevice, String productName, int usage) {
        Controller controller = null;
        controller = this.createController(lpDevice, productName, usage);
        if (controller != null) {
            this.devices.put(new Long(lpDevice), controller);
        }
    }

    private void addControllerElement(long lpDevice, long elementCookie, int elementType, int usage, int usagePage, int rawMin, int rawMax, int scaledMin, int scaledMax, int dataBitSize, boolean isRelative, boolean isWrapping, boolean isNonLinear, boolean hasPreferredState, boolean hasNullState) {
        InputControllerElement element = new InputControllerElement(elementCookie, elementType, usage, usagePage, rawMin, rawMax, scaledMin, scaledMax, dataBitSize, isRelative, isWrapping, isNonLinear, hasPreferredState, hasNullState);
        InputController inputController = (InputController)this.devices.get(new Long(lpDevice));
        if (inputController != null) {
            inputController.addControllerElement(element);
        }
    }

    public void testDevice(long lpDevice) {
        System.out.println("Opening device ");
        long lpQueue = this.openDevice(lpDevice, 32);
        int i = 0;
        while (i < 50) {
            try {
                this.pollDevice(lpQueue);
                Thread.sleep(10L);
            }
            catch (Exception e) {
                System.out.println("Interrupted" + e);
            }
            ++i;
        }
        System.out.println("Closing device");
        this.closeDevice(lpDevice, lpQueue);
    }

    public static void main(String[] args) {
        System.out.println("Started net.java.games.input.OSXEnvironmentPlugin");
        OSXEnvironmentPlugin newjni = new OSXEnvironmentPlugin();
        Controller[] controllers = newjni.getControllers();
        int i = 0;
        while (i < controllers.length) {
            System.out.println("Controller [" + controllers[i].getName() + "] enumerated...");
            ++i;
        }
        System.out.println("Done");
    }
}

