/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.AbstractComponent;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Controller;

public abstract class Mouse
extends AbstractController {
    protected Ball ball;
    protected Buttons buttons;

    protected Mouse(String name) {
        super(name);
    }

    public Controller[] getControllers() {
        if (this.children.length == 0 && this.ball != null && this.buttons != null) {
            this.children = new Controller[]{this.ball, this.buttons};
        }
        return this.children;
    }

    public Ball getBall() {
        return this.ball;
    }

    public Buttons getButtons() {
        return this.buttons;
    }

    public Controller.Type getType() {
        return Controller.Type.MOUSE;
    }

    public abstract class Ball
    extends AbstractController {
        protected Component x;
        protected Component y;
        protected Component wheel;

        protected Ball(String name) {
            super(name);
        }

        public Controller.Type getType() {
            return Controller.Type.BALL;
        }

        public Component getX() {
            return this.x;
        }

        public Component getY() {
            return this.y;
        }

        public Component getWheel() {
            return this.wheel;
        }

        public Component[] getComponents() {
            if (this.components.length == 0 && this.x != null && this.y != null) {
                this.components = this.wheel == null ? new Component[]{this.x, this.y} : new Component[]{this.x, this.y, this.wheel};
            }
            return this.components;
        }

        public boolean poll() {
            return Mouse.this.poll();
        }
    }

    public abstract class Buttons
    extends AbstractController {
        protected Button left;
        protected Button right;
        protected Button middle;
        protected Button side;
        protected Button extra;
        protected Button forward;
        protected Button back;

        protected Buttons(String name) {
            super(name);
        }

        public Controller.Type getType() {
            return Controller.Type.BUTTONS;
        }

        public Button getLeft() {
            return this.left;
        }

        public Button getRight() {
            return this.right;
        }

        public Button getMiddle() {
            return this.middle;
        }

        public Button getSide() {
            return this.side;
        }

        public Button getExtra() {
            return this.extra;
        }

        public Button getForward() {
            return this.forward;
        }

        public Button getBack() {
            return this.back;
        }

        public Component[] getComponents() {
            if (this.components.length == 0 && this.left != null) {
                this.components = this.right == null ? new Component[]{this.left} : (this.middle == null ? new Component[]{this.left, this.right} : (this.side == null ? new Component[]{this.left, this.right, this.middle} : (this.extra == null ? new Component[]{this.left, this.right, this.middle, this.side} : (this.forward == null ? new Component[]{this.left, this.right, this.middle, this.side, this.extra} : (this.back == null ? new Component[]{this.left, this.right, this.middle, this.side, this.extra, this.forward} : new Component[]{this.left, this.right, this.middle, this.side, this.extra, this.forward, this.back})))));
            }
            return this.components;
        }

        public boolean poll() {
            return Mouse.this.poll();
        }
    }

    public abstract class Button
    extends AbstractComponent {
        protected Button(String name, Component.Identifier.Button id) {
            super(name, id);
        }
    }
}

