/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.Component;
import net.java.games.input.Controller;

public class LinuxNativeTypesMap {
    private static LinuxNativeTypesMap INSTANCE = new LinuxNativeTypesMap();
    private String[] keyNames = new String[511];
    private String[] relAxesNames;
    private String[] absAxesNames;
    private Component.Identifier[] relAxesIDs;
    private Component.Identifier[] absAxesIDs;
    private Component.Identifier[] buttonIDs;

    private LinuxNativeTypesMap() {
    }

    public static void init() {
        INSTANCE.reInit();
    }

    private void reInit() {
        this.keyNames[1] = "Escape";
        this.keyNames[2] = "1";
        this.keyNames[3] = "2";
        this.keyNames[4] = "3";
        this.keyNames[5] = "4";
        this.keyNames[6] = "5";
        this.keyNames[7] = "6";
        this.keyNames[8] = "7";
        this.keyNames[9] = "8";
        this.keyNames[10] = "9";
        this.keyNames[11] = "0";
        this.keyNames[12] = "-";
        this.keyNames[13] = "=";
        this.keyNames[14] = "Backspace";
        this.keyNames[15] = "Tab";
        this.keyNames[16] = "Q";
        this.keyNames[17] = "W";
        this.keyNames[18] = "E";
        this.keyNames[19] = "R";
        this.keyNames[20] = "T";
        this.keyNames[21] = "Y";
        this.keyNames[22] = "U";
        this.keyNames[23] = "I";
        this.keyNames[24] = "O";
        this.keyNames[25] = "P";
        this.keyNames[26] = "[";
        this.keyNames[27] = "]";
        this.keyNames[28] = "Enter";
        this.keyNames[29] = "LH Control";
        this.keyNames[30] = "A";
        this.keyNames[31] = "S";
        this.keyNames[32] = "D";
        this.keyNames[33] = "F";
        this.keyNames[34] = "G";
        this.keyNames[35] = "H";
        this.keyNames[36] = "J";
        this.keyNames[37] = "K";
        this.keyNames[38] = "L";
        this.keyNames[39] = ";";
        this.keyNames[40] = "'";
        this.keyNames[41] = "`";
        this.keyNames[42] = "LH Shift";
        this.keyNames[43] = "\\";
        this.keyNames[44] = "Z";
        this.keyNames[45] = "X";
        this.keyNames[46] = "C";
        this.keyNames[47] = "V";
        this.keyNames[48] = "B";
        this.keyNames[49] = "N";
        this.keyNames[50] = "M";
        this.keyNames[51] = ",";
        this.keyNames[52] = ".";
        this.keyNames[53] = "/";
        this.keyNames[54] = "RH Shift";
        this.keyNames[55] = "*";
        this.keyNames[56] = "LH Alt";
        this.keyNames[57] = "Space";
        this.keyNames[58] = "CapsLock";
        this.keyNames[59] = "F1";
        this.keyNames[60] = "F2";
        this.keyNames[61] = "F3";
        this.keyNames[62] = "F4";
        this.keyNames[63] = "F5";
        this.keyNames[64] = "F6";
        this.keyNames[65] = "F7";
        this.keyNames[66] = "F8";
        this.keyNames[67] = "F9";
        this.keyNames[68] = "F10";
        this.keyNames[69] = "NumLock";
        this.keyNames[70] = "ScrollLock";
        this.keyNames[71] = "KeyPad 7";
        this.keyNames[72] = "KeyPad 8";
        this.keyNames[73] = "Keypad 9";
        this.keyNames[74] = "KeyPad Minus";
        this.keyNames[75] = "KeyPad 4";
        this.keyNames[76] = "KeyPad 5";
        this.keyNames[77] = "KeyPad 6";
        this.keyNames[78] = "KeyPad Plus";
        this.keyNames[79] = "KeyPad 1";
        this.keyNames[80] = "KeyPad 2";
        this.keyNames[81] = "KeyPad 3";
        this.keyNames[82] = "KeyPad 0";
        this.keyNames[83] = "KeyPad decimal point";
        this.keyNames[84] = "Huh?";
        this.keyNames[85] = "F13";
        this.keyNames[86] = "Beats me...";
        this.keyNames[87] = "F11";
        this.keyNames[88] = "F12";
        this.keyNames[89] = "F14";
        this.keyNames[90] = "F15";
        this.keyNames[91] = "F16";
        this.keyNames[92] = "F17";
        this.keyNames[93] = "F18";
        this.keyNames[94] = "F19";
        this.keyNames[95] = "F20";
        this.keyNames[96] = "Keypad Enter";
        this.keyNames[97] = "RH Control";
        this.keyNames[98] = "KeyPad Forward Slash";
        this.keyNames[99] = "System Request";
        this.keyNames[100] = "RH Alternate";
        this.keyNames[101] = "Line Feed";
        this.keyNames[102] = "Home";
        this.keyNames[103] = "Up";
        this.keyNames[104] = "Page Up";
        this.keyNames[105] = "Left";
        this.keyNames[106] = "Right";
        this.keyNames[107] = "End";
        this.keyNames[108] = "Down";
        this.keyNames[109] = "Page Down";
        this.keyNames[110] = "Insert";
        this.keyNames[111] = "Delete";
        this.keyNames[112] = "Macro";
        this.keyNames[113] = "Mute";
        this.keyNames[114] = "Volume Down";
        this.keyNames[115] = "Volume Up";
        this.keyNames[116] = "Power";
        this.keyNames[117] = "KeyPad Equal";
        this.keyNames[118] = "KeyPad +/-";
        this.keyNames[119] = "Pause";
        this.keyNames[120] = "F21";
        this.keyNames[121] = "F22";
        this.keyNames[122] = "F23";
        this.keyNames[123] = "F24";
        this.keyNames[124] = "KeyPad comma";
        this.keyNames[125] = "LH Meta";
        this.keyNames[126] = "RH Meta";
        this.keyNames[127] = "Compose";
        this.keyNames[128] = "Stop";
        this.keyNames[129] = "Again";
        this.keyNames[130] = "Properties";
        this.keyNames[131] = "Undo";
        this.keyNames[132] = "Front";
        this.keyNames[133] = "Copy";
        this.keyNames[134] = "Open";
        this.keyNames[135] = "Paste";
        this.keyNames[136] = "Find";
        this.keyNames[137] = "Cut";
        this.keyNames[138] = "Help";
        this.keyNames[139] = "Menu";
        this.keyNames[140] = "Calculator";
        this.keyNames[141] = "Setup";
        this.keyNames[142] = "Sleep";
        this.keyNames[143] = "Wakeup";
        this.keyNames[144] = "File";
        this.keyNames[145] = "Send File";
        this.keyNames[146] = "Delete File";
        this.keyNames[147] = "Transfer";
        this.keyNames[148] = "Program 1";
        this.keyNames[149] = "Program 2";
        this.keyNames[150] = "Web Browser";
        this.keyNames[151] = "DOS mode";
        this.keyNames[152] = "Coffee";
        this.keyNames[153] = "Direction";
        this.keyNames[154] = "Window cycle";
        this.keyNames[155] = "Mail";
        this.keyNames[156] = "Book Marks";
        this.keyNames[157] = "Computer";
        this.keyNames[158] = "Back";
        this.keyNames[159] = "Forward";
        this.keyNames[160] = "Close CD";
        this.keyNames[161] = "Eject CD";
        this.keyNames[162] = "Eject / Close CD";
        this.keyNames[163] = "Next Song";
        this.keyNames[164] = "Play and Pause";
        this.keyNames[165] = "Previous Song";
        this.keyNames[166] = "Stop CD";
        this.keyNames[167] = "Record";
        this.keyNames[168] = "Rewind";
        this.keyNames[169] = "Phone";
        this.keyNames[170] = "ISO";
        this.keyNames[171] = "Config";
        this.keyNames[172] = "Home";
        this.keyNames[173] = "Refresh";
        this.keyNames[174] = "Exit";
        this.keyNames[175] = "Move";
        this.keyNames[176] = "Edit";
        this.keyNames[177] = "Scroll Up";
        this.keyNames[178] = "Scroll Down";
        this.keyNames[179] = "KeyPad LH parenthesis";
        this.keyNames[180] = "KeyPad RH parenthesis";
        this.keyNames[181] = "Intl 1";
        this.keyNames[182] = "Intl 2";
        this.keyNames[183] = "Intl 3";
        this.keyNames[184] = "Intl 4";
        this.keyNames[185] = "Intl 5";
        this.keyNames[186] = "Intl 6";
        this.keyNames[187] = "Intl 7";
        this.keyNames[188] = "Intl 8";
        this.keyNames[189] = "Intl 9";
        this.keyNames[190] = "Language 1";
        this.keyNames[191] = "Language 2";
        this.keyNames[192] = "Language 3";
        this.keyNames[193] = "Language 4";
        this.keyNames[194] = "Language 5";
        this.keyNames[195] = "Language 6";
        this.keyNames[196] = "Language 7";
        this.keyNames[197] = "Language 8";
        this.keyNames[198] = "Language 9";
        this.keyNames[200] = "Play CD";
        this.keyNames[201] = "Pause CD";
        this.keyNames[202] = "Program 3";
        this.keyNames[203] = "Program 4";
        this.keyNames[205] = "Suspend";
        this.keyNames[206] = "Close";
        this.keyNames[240] = "Specifically unknown";
        this.keyNames[224] = "Brightness Down";
        this.keyNames[225] = "Brightness Up";
        this.keyNames[256] = "Button 0";
        this.keyNames[257] = "Button 1";
        this.keyNames[258] = "Button 2";
        this.keyNames[259] = "Button 3";
        this.keyNames[260] = "Button 4";
        this.keyNames[261] = "Button 5";
        this.keyNames[262] = "Button 6";
        this.keyNames[263] = "Button 7";
        this.keyNames[264] = "Button 8";
        this.keyNames[265] = "Button 9";
        this.keyNames[272] = "Left Button";
        this.keyNames[273] = "Right Button";
        this.keyNames[274] = "Middle Button";
        this.keyNames[275] = "Side Button";
        this.keyNames[276] = "Extra Button";
        this.keyNames[277] = "Forward Button";
        this.keyNames[278] = "Back Button";
        this.keyNames[288] = "Trigger Button";
        this.keyNames[289] = "Thumb Button";
        this.keyNames[290] = "Second Thumb Button";
        this.keyNames[291] = "Top Button";
        this.keyNames[292] = "Second Top Button";
        this.keyNames[293] = "Pinkie Button";
        this.keyNames[294] = "Base Button";
        this.keyNames[295] = "Second Base Button";
        this.keyNames[296] = "Third Base Button";
        this.keyNames[297] = "Fourth Base Button";
        this.keyNames[298] = "Fifth Base Button";
        this.keyNames[299] = "Sixth Base Button";
        this.keyNames[303] = "Dead Button";
        this.keyNames[304] = "Button A";
        this.keyNames[305] = "Button B";
        this.keyNames[306] = "Button C";
        this.keyNames[307] = "Button X";
        this.keyNames[308] = "Button Y";
        this.keyNames[309] = "Button Z";
        this.keyNames[310] = "Thumb Left Button";
        this.keyNames[311] = "Thumb Right Button ";
        this.keyNames[312] = "Second Thumb Left Button";
        this.keyNames[313] = "Second Thumb Right Button ";
        this.keyNames[314] = "Select Button";
        this.keyNames[316] = "Mode Button";
        this.keyNames[317] = "Another Left Thumb Button ";
        this.keyNames[318] = "Another Right Thumb Button ";
        this.keyNames[320] = "Digitiser Pen Tool";
        this.keyNames[321] = "Digitiser Rubber Tool";
        this.keyNames[322] = "Digitiser Brush Tool";
        this.keyNames[323] = "Digitiser Pencil Tool";
        this.keyNames[324] = "Digitiser Airbrush Tool";
        this.keyNames[325] = "Digitiser Finger Tool";
        this.keyNames[326] = "Digitiser Mouse Tool";
        this.keyNames[327] = "Digitiser Lens Tool";
        this.keyNames[330] = "Digitiser Touch Button ";
        this.keyNames[331] = "Digitiser Stylus Button ";
        this.keyNames[332] = "Second Digitiser Stylus Button ";
        this.buttonIDs = new Component.Identifier[511];
        this.buttonIDs[1] = Component.Identifier.Key.ESCAPE;
        this.buttonIDs[2] = Component.Identifier.Key._1;
        this.buttonIDs[3] = Component.Identifier.Key._2;
        this.buttonIDs[4] = Component.Identifier.Key._3;
        this.buttonIDs[5] = Component.Identifier.Key._4;
        this.buttonIDs[6] = Component.Identifier.Key._5;
        this.buttonIDs[7] = Component.Identifier.Key._6;
        this.buttonIDs[8] = Component.Identifier.Key._7;
        this.buttonIDs[9] = Component.Identifier.Key._8;
        this.buttonIDs[10] = Component.Identifier.Key._9;
        this.buttonIDs[11] = Component.Identifier.Key._0;
        this.buttonIDs[12] = Component.Identifier.Key.MINUS;
        this.buttonIDs[13] = Component.Identifier.Key.EQUALS;
        this.buttonIDs[14] = Component.Identifier.Key.BACK;
        this.buttonIDs[15] = Component.Identifier.Key.TAB;
        this.buttonIDs[16] = Component.Identifier.Key.Q;
        this.buttonIDs[17] = Component.Identifier.Key.W;
        this.buttonIDs[18] = Component.Identifier.Key.E;
        this.buttonIDs[19] = Component.Identifier.Key.R;
        this.buttonIDs[20] = Component.Identifier.Key.T;
        this.buttonIDs[21] = Component.Identifier.Key.Y;
        this.buttonIDs[22] = Component.Identifier.Key.U;
        this.buttonIDs[23] = Component.Identifier.Key.I;
        this.buttonIDs[24] = Component.Identifier.Key.O;
        this.buttonIDs[25] = Component.Identifier.Key.P;
        this.buttonIDs[26] = Component.Identifier.Key.LBRACKET;
        this.buttonIDs[27] = Component.Identifier.Key.RBRACKET;
        this.buttonIDs[28] = Component.Identifier.Key.RETURN;
        this.buttonIDs[29] = Component.Identifier.Key.LCONTROL;
        this.buttonIDs[30] = Component.Identifier.Key.A;
        this.buttonIDs[31] = Component.Identifier.Key.S;
        this.buttonIDs[32] = Component.Identifier.Key.D;
        this.buttonIDs[33] = Component.Identifier.Key.F;
        this.buttonIDs[34] = Component.Identifier.Key.G;
        this.buttonIDs[35] = Component.Identifier.Key.H;
        this.buttonIDs[36] = Component.Identifier.Key.J;
        this.buttonIDs[37] = Component.Identifier.Key.K;
        this.buttonIDs[38] = Component.Identifier.Key.L;
        this.buttonIDs[39] = Component.Identifier.Key.SEMICOLON;
        this.buttonIDs[40] = Component.Identifier.Key.APOSTROPHE;
        this.buttonIDs[41] = Component.Identifier.Key.GRAVE;
        this.buttonIDs[42] = Component.Identifier.Key.LSHIFT;
        this.buttonIDs[43] = Component.Identifier.Key.BACKSLASH;
        this.buttonIDs[44] = Component.Identifier.Key.Z;
        this.buttonIDs[45] = Component.Identifier.Key.X;
        this.buttonIDs[46] = Component.Identifier.Key.C;
        this.buttonIDs[47] = Component.Identifier.Key.V;
        this.buttonIDs[48] = Component.Identifier.Key.B;
        this.buttonIDs[49] = Component.Identifier.Key.N;
        this.buttonIDs[50] = Component.Identifier.Key.M;
        this.buttonIDs[51] = Component.Identifier.Key.COMMA;
        this.buttonIDs[52] = Component.Identifier.Key.PERIOD;
        this.buttonIDs[53] = Component.Identifier.Key.SLASH;
        this.buttonIDs[54] = Component.Identifier.Key.RSHIFT;
        this.buttonIDs[55] = Component.Identifier.Key.MULTIPLY;
        this.buttonIDs[56] = Component.Identifier.Key.LALT;
        this.buttonIDs[57] = Component.Identifier.Key.SPACE;
        this.buttonIDs[58] = Component.Identifier.Key.CAPITAL;
        this.buttonIDs[59] = Component.Identifier.Key.F1;
        this.buttonIDs[60] = Component.Identifier.Key.F2;
        this.buttonIDs[61] = Component.Identifier.Key.F3;
        this.buttonIDs[62] = Component.Identifier.Key.F4;
        this.buttonIDs[63] = Component.Identifier.Key.F5;
        this.buttonIDs[64] = Component.Identifier.Key.F6;
        this.buttonIDs[65] = Component.Identifier.Key.F7;
        this.buttonIDs[66] = Component.Identifier.Key.F8;
        this.buttonIDs[67] = Component.Identifier.Key.F9;
        this.buttonIDs[68] = Component.Identifier.Key.F10;
        this.buttonIDs[69] = Component.Identifier.Key.NUMLOCK;
        this.buttonIDs[70] = Component.Identifier.Key.SCROLL;
        this.buttonIDs[71] = Component.Identifier.Key.NUMPAD7;
        this.buttonIDs[72] = Component.Identifier.Key.NUMPAD8;
        this.buttonIDs[73] = Component.Identifier.Key.NUMPAD9;
        this.buttonIDs[74] = Component.Identifier.Key.SUBTRACT;
        this.buttonIDs[75] = Component.Identifier.Key.NUMPAD4;
        this.buttonIDs[76] = Component.Identifier.Key.NUMPAD5;
        this.buttonIDs[77] = Component.Identifier.Key.NUMPAD6;
        this.buttonIDs[78] = Component.Identifier.Key.ADD;
        this.buttonIDs[79] = Component.Identifier.Key.NUMPAD1;
        this.buttonIDs[80] = Component.Identifier.Key.NUMPAD2;
        this.buttonIDs[81] = Component.Identifier.Key.NUMPAD3;
        this.buttonIDs[82] = Component.Identifier.Key.NUMPAD0;
        this.buttonIDs[83] = Component.Identifier.Key.DECIMAL;
        this.buttonIDs[84] = null;
        this.buttonIDs[85] = Component.Identifier.Key.F13;
        this.buttonIDs[86] = null;
        this.buttonIDs[87] = Component.Identifier.Key.F11;
        this.buttonIDs[88] = Component.Identifier.Key.F12;
        this.buttonIDs[89] = Component.Identifier.Key.F14;
        this.buttonIDs[90] = Component.Identifier.Key.F15;
        this.buttonIDs[91] = null;
        this.buttonIDs[92] = null;
        this.buttonIDs[93] = null;
        this.buttonIDs[94] = null;
        this.buttonIDs[95] = null;
        this.buttonIDs[96] = Component.Identifier.Key.NUMPADENTER;
        this.buttonIDs[97] = Component.Identifier.Key.RCONTROL;
        this.buttonIDs[98] = Component.Identifier.Key.DIVIDE;
        this.buttonIDs[99] = Component.Identifier.Key.SYSRQ;
        this.buttonIDs[100] = Component.Identifier.Key.RALT;
        this.buttonIDs[101] = null;
        this.buttonIDs[102] = Component.Identifier.Key.HOME;
        this.buttonIDs[103] = Component.Identifier.Key.UP;
        this.buttonIDs[104] = Component.Identifier.Key.PAGEUP;
        this.buttonIDs[105] = Component.Identifier.Key.LEFT;
        this.buttonIDs[106] = Component.Identifier.Key.RIGHT;
        this.buttonIDs[107] = Component.Identifier.Key.END;
        this.buttonIDs[108] = Component.Identifier.Key.DOWN;
        this.buttonIDs[109] = Component.Identifier.Key.PAGEDOWN;
        this.buttonIDs[110] = Component.Identifier.Key.INSERT;
        this.buttonIDs[111] = Component.Identifier.Key.DELETE;
        this.buttonIDs[119] = Component.Identifier.Key.PAUSE;
        this.buttonIDs[117] = Component.Identifier.Key.NUMPADEQUAL;
        this.buttonIDs[142] = Component.Identifier.Key.SLEEP;
        this.buttonIDs[240] = Component.Identifier.Key.UNLABELED;
        this.buttonIDs[256] = Component.Identifier.Button._0;
        this.buttonIDs[257] = Component.Identifier.Button._1;
        this.buttonIDs[258] = Component.Identifier.Button._2;
        this.buttonIDs[259] = Component.Identifier.Button._3;
        this.buttonIDs[260] = Component.Identifier.Button._4;
        this.buttonIDs[261] = Component.Identifier.Button._5;
        this.buttonIDs[262] = Component.Identifier.Button._6;
        this.buttonIDs[263] = Component.Identifier.Button._7;
        this.buttonIDs[264] = Component.Identifier.Button._8;
        this.buttonIDs[265] = Component.Identifier.Button._9;
        this.buttonIDs[272] = Component.Identifier.Button.LEFT;
        this.buttonIDs[273] = Component.Identifier.Button.RIGHT;
        this.buttonIDs[274] = Component.Identifier.Button.MIDDLE;
        this.buttonIDs[275] = Component.Identifier.Button.SIDE;
        this.buttonIDs[276] = Component.Identifier.Button.EXTRA;
        this.buttonIDs[277] = Component.Identifier.Button.FORWARD;
        this.buttonIDs[278] = Component.Identifier.Button.BACK;
        this.buttonIDs[288] = Component.Identifier.Button.TRIGGER;
        this.buttonIDs[289] = Component.Identifier.Button.THUMB;
        this.buttonIDs[290] = Component.Identifier.Button.THUMB2;
        this.buttonIDs[291] = Component.Identifier.Button.TOP;
        this.buttonIDs[292] = Component.Identifier.Button.TOP2;
        this.buttonIDs[293] = Component.Identifier.Button.PINKIE;
        this.buttonIDs[294] = Component.Identifier.Button.BASE;
        this.buttonIDs[295] = Component.Identifier.Button.BASE2;
        this.buttonIDs[296] = Component.Identifier.Button.BASE3;
        this.buttonIDs[297] = Component.Identifier.Button.BASE4;
        this.buttonIDs[298] = Component.Identifier.Button.BASE5;
        this.buttonIDs[299] = Component.Identifier.Button.BASE6;
        this.buttonIDs[303] = Component.Identifier.Button.DEAD;
        this.buttonIDs[304] = Component.Identifier.Button.A;
        this.buttonIDs[305] = Component.Identifier.Button.B;
        this.buttonIDs[306] = Component.Identifier.Button.C;
        this.buttonIDs[307] = Component.Identifier.Button.X;
        this.buttonIDs[308] = Component.Identifier.Button.Y;
        this.buttonIDs[309] = Component.Identifier.Button.Z;
        this.buttonIDs[310] = Component.Identifier.Button.LEFT_THUMB;
        this.buttonIDs[311] = Component.Identifier.Button.RIGHT_THUMB;
        this.buttonIDs[312] = Component.Identifier.Button.LEFT_THUMB2;
        this.buttonIDs[313] = Component.Identifier.Button.RIGHT_THUMB2;
        this.buttonIDs[314] = Component.Identifier.Button.SELECT;
        this.buttonIDs[316] = Component.Identifier.Button.MODE;
        this.buttonIDs[317] = Component.Identifier.Button.LEFT_THUMB3;
        this.buttonIDs[318] = Component.Identifier.Button.RIGHT_THUMB3;
        this.buttonIDs[320] = Component.Identifier.Button.TOOL_PEN;
        this.buttonIDs[321] = Component.Identifier.Button.TOOL_RUBBER;
        this.buttonIDs[322] = Component.Identifier.Button.TOOL_BRUSH;
        this.buttonIDs[323] = Component.Identifier.Button.TOOL_PENCIL;
        this.buttonIDs[324] = Component.Identifier.Button.TOOL_AIRBRUSH;
        this.buttonIDs[325] = Component.Identifier.Button.TOOL_FINGER;
        this.buttonIDs[326] = Component.Identifier.Button.TOOL_MOUSE;
        this.buttonIDs[327] = Component.Identifier.Button.TOOL_LENS;
        this.buttonIDs[330] = Component.Identifier.Button.TOUCH;
        this.buttonIDs[331] = Component.Identifier.Button.STYLUS;
        this.buttonIDs[332] = Component.Identifier.Button.STYLUS2;
        this.relAxesNames = new String[15];
        this.relAxesNames[0] = "X axis";
        this.relAxesNames[1] = "Y axis";
        this.relAxesNames[2] = "Z axis";
        this.relAxesNames[6] = "Horizontal wheel";
        this.relAxesNames[7] = "Dial";
        this.relAxesNames[8] = "Vertical wheel";
        this.relAxesNames[9] = "Miscellaneous";
        this.relAxesIDs = new Component.Identifier[15];
        this.relAxesIDs[0] = Component.Identifier.Axis.X;
        this.relAxesIDs[1] = Component.Identifier.Axis.Y;
        this.relAxesIDs[2] = Component.Identifier.Axis.Z;
        this.relAxesIDs[8] = Component.Identifier.Axis.SLIDER;
        this.relAxesIDs[6] = Component.Identifier.Axis.SLIDER;
        this.relAxesIDs[7] = Component.Identifier.Axis.SLIDER;
        this.relAxesIDs[9] = Component.Identifier.Axis.SLIDER;
        this.absAxesNames = new String[63];
        this.absAxesNames[0] = "X axis";
        this.absAxesNames[1] = "Y axis";
        this.absAxesNames[2] = "Z axis";
        this.absAxesNames[3] = "X rate axis";
        this.absAxesNames[4] = "Y rate axis";
        this.absAxesNames[5] = "Z rate axis";
        this.absAxesNames[6] = "Throttle";
        this.absAxesNames[7] = "Rudder";
        this.absAxesNames[8] = "Wheel";
        this.absAxesNames[9] = "Accelerator";
        this.absAxesNames[10] = "Brake";
        this.absAxesNames[16] = "Hat 1";
        this.absAxesNames[17] = "Hat 1";
        this.absAxesNames[18] = "Hat 2";
        this.absAxesNames[19] = "Hat 2";
        this.absAxesNames[20] = "Hat 3";
        this.absAxesNames[21] = "Hat 3";
        this.absAxesNames[22] = "Hat 4";
        this.absAxesNames[23] = "Hat 4";
        this.absAxesNames[24] = "Pressure";
        this.absAxesNames[25] = "Distance";
        this.absAxesNames[26] = "X axis tilt";
        this.absAxesNames[27] = "Y axis tilt";
        this.absAxesNames[40] = "Miscellaneous";
        this.absAxesIDs = new Component.Identifier[63];
        this.absAxesIDs[0] = Component.Identifier.Axis.X;
        this.absAxesIDs[1] = Component.Identifier.Axis.Y;
        this.absAxesIDs[2] = Component.Identifier.Axis.Z;
        this.absAxesIDs[3] = Component.Identifier.Axis.RX;
        this.absAxesIDs[4] = Component.Identifier.Axis.RY;
        this.absAxesIDs[5] = Component.Identifier.Axis.RZ;
        this.absAxesIDs[6] = Component.Identifier.Axis.SLIDER;
        this.absAxesIDs[7] = Component.Identifier.Axis.RZ;
        this.absAxesIDs[8] = Component.Identifier.Axis.Y;
        this.absAxesIDs[9] = Component.Identifier.Axis.SLIDER;
        this.absAxesIDs[10] = Component.Identifier.Axis.SLIDER;
        this.absAxesIDs[16] = Component.Identifier.Axis.POV;
        this.absAxesIDs[17] = Component.Identifier.Axis.POV;
        this.absAxesIDs[18] = Component.Identifier.Axis.POV;
        this.absAxesIDs[19] = Component.Identifier.Axis.POV;
        this.absAxesIDs[20] = Component.Identifier.Axis.POV;
        this.absAxesIDs[21] = Component.Identifier.Axis.POV;
        this.absAxesIDs[22] = Component.Identifier.Axis.POV;
        this.absAxesIDs[23] = Component.Identifier.Axis.POV;
        this.absAxesIDs[24] = null;
        this.absAxesIDs[25] = null;
        this.absAxesIDs[26] = null;
        this.absAxesIDs[27] = null;
        this.absAxesIDs[40] = null;
    }

    public static Controller.PortType getPortType(int nativeid) {
        switch (nativeid) {
            case 20: {
                return Controller.PortType.GAME;
            }
            case 17: {
                return Controller.PortType.I8042;
            }
            case 21: {
                return Controller.PortType.PARALLEL;
            }
            case 19: {
                return Controller.PortType.SERIAL;
            }
            case 3: {
                return Controller.PortType.USB;
            }
        }
        return Controller.PortType.UNKNOWN;
    }

    public static String getButtonName(int nativeID) {
        String retval = LinuxNativeTypesMap.INSTANCE.keyNames[nativeID];
        return retval;
    }

    public static String getRelAxisName(int nativeID) {
        String retval = LinuxNativeTypesMap.INSTANCE.relAxesNames[nativeID];
        if (retval == null) {
            LinuxNativeTypesMap.INSTANCE.relAxesNames[nativeID] = retval = "Unknown relative axis id";
        }
        return retval;
    }

    public static String getAbsAxisName(int nativeID) {
        String retval = LinuxNativeTypesMap.INSTANCE.absAxesNames[nativeID];
        if (retval == null) {
            LinuxNativeTypesMap.INSTANCE.absAxesNames[nativeID] = retval = "Unknown absolute axis id " + nativeID;
        }
        return retval;
    }

    public static Component.Identifier getRelAxisID(int nativeID) {
        Component.Identifier retval = LinuxNativeTypesMap.INSTANCE.relAxesIDs[nativeID];
        if (retval == null) {
            LinuxNativeTypesMap.INSTANCE.relAxesIDs[nativeID] = retval = Component.Identifier.Axis.SLIDER_VELOCITY;
        }
        return retval;
    }

    public static Component.Identifier getAbsAxisID(int nativeID) {
        Component.Identifier retval = null;
        try {
            retval = LinuxNativeTypesMap.INSTANCE.absAxesIDs[nativeID];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("INSTANCE.absAxesIDs is only " + LinuxNativeTypesMap.INSTANCE.absAxesIDs.length + " long, so " + nativeID + " not contained");
        }
        if (retval == null) {
            LinuxNativeTypesMap.INSTANCE.absAxesIDs[nativeID] = retval = Component.Identifier.Axis.SLIDER;
        }
        return retval;
    }

    public static Component.Identifier getButtonID(int nativeID) {
        Component.Identifier retval = LinuxNativeTypesMap.INSTANCE.buttonIDs[nativeID];
        if (retval == null) {
            LinuxNativeTypesMap.INSTANCE.buttonIDs[nativeID] = retval = Component.Identifier.Key.UNKNOWN;
        }
        return retval;
    }
}

