/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.Component;
import net.java.games.input.LinuxDevice;
import net.java.games.input.Mouse;

public class LinuxMouse
extends Mouse {
    private LinuxDevice device;

    public LinuxMouse(LinuxDevice device) {
        super(device.getName());
        this.device = device;
        Component[] components = device.getComponents();
        Component x = null;
        Component y = null;
        Component wheel = null;
        LinuxMouseButton left = null;
        LinuxMouseButton right = null;
        LinuxMouseButton middle = null;
        LinuxMouseButton side = null;
        LinuxMouseButton extra = null;
        LinuxMouseButton forward = null;
        LinuxMouseButton back = null;
        int i = components.length - 1;
        while (i >= 0) {
            Component tempAxis = components[i];
            if (tempAxis.isRelative()) {
                if (tempAxis.getIdentifier() == Component.Identifier.Axis.X) {
                    x = tempAxis;
                } else if (tempAxis.getIdentifier() == Component.Identifier.Axis.Y) {
                    y = tempAxis;
                } else if (tempAxis.getIdentifier() == Component.Identifier.Axis.SLIDER) {
                    wheel = tempAxis;
                }
            } else if (!tempAxis.isAnalog()) {
                if (tempAxis.getIdentifier() == Component.Identifier.Button.LEFT) {
                    left = new LinuxMouseButton(tempAxis);
                } else if (tempAxis.getIdentifier() == Component.Identifier.Button.RIGHT) {
                    right = new LinuxMouseButton(tempAxis);
                } else if (tempAxis.getIdentifier() == Component.Identifier.Button.MIDDLE) {
                    middle = new LinuxMouseButton(tempAxis);
                } else if (tempAxis.getIdentifier() == Component.Identifier.Button.SIDE) {
                    side = new LinuxMouseButton(tempAxis);
                } else if (tempAxis.getIdentifier() == Component.Identifier.Button.EXTRA) {
                    extra = new LinuxMouseButton(tempAxis);
                } else if (tempAxis.getIdentifier() == Component.Identifier.Button.FORWARD) {
                    forward = new LinuxMouseButton(tempAxis);
                } else if (tempAxis.getIdentifier() == Component.Identifier.Button.BACK) {
                    back = new LinuxMouseButton(tempAxis);
                }
            }
            --i;
        }
        this.ball = new LinuxMouseBall(x, y, wheel);
        this.buttons = new LinuxMouseButtons(left, right, middle, side, extra, forward, back);
    }

    public boolean poll() {
        return this.device.poll();
    }

    private class LinuxMouseBall
    extends Mouse.Ball {
        public LinuxMouseBall(Component x, Component y, Component wheel) {
            super(LinuxMouse.this, String.valueOf(LinuxMouse.this.getName()) + " ball");
            this.x = x;
            this.y = y;
            this.wheel = wheel;
        }
    }

    private class LinuxMouseButtons
    extends Mouse.Buttons {
        public LinuxMouseButtons(Mouse.Button left, Mouse.Button right, Mouse.Button middle, Mouse.Button side, Mouse.Button extra, Mouse.Button forward, Mouse.Button back) {
            super(LinuxMouse.this, String.valueOf(LinuxMouse.this.getName()) + " buttons");
            this.left = left;
            this.right = right;
            this.middle = middle;
            this.side = side;
            this.extra = extra;
            this.forward = forward;
            this.back = back;
        }
    }

    private class LinuxMouseButton
    extends Mouse.Button {
        private Component realAxis;

        public LinuxMouseButton(Component axis) {
            super(LinuxMouse.this, axis.getName(), (Component.Identifier.Button)axis.getIdentifier());
            this.realAxis = axis;
        }

        public boolean isRelative() {
            return false;
        }

        public float getPollData() {
            return this.realAxis.getPollData();
        }
    }
}

