/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.AbstractComponent;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Keyboard;
import net.java.games.input.LinuxNativeTypesMap;
import net.java.games.input.StandardKeyboard;

public class LinuxKeyboard
extends StandardKeyboard {
    private int[] keyData;
    private int[] dummyRelAxesData;
    private int[] dummyAbsAxesData;
    private int[] keyMap;
    private int[] supportedKeys;
    private int numKeys;
    private Controller.PortType portType;
    private int nativeID;

    public LinuxKeyboard(int nativeID, String name, int numButtons, int numRelAxes, int numAbsAxes) {
        super(name);
        throw new RuntimeException("Error, should not get here");
    }

    protected boolean isKeyPressed(Keyboard.Key key) {
        return this.keyData[this.keyMap[((Component.Identifier.Key)key.getIdentifier()).getKeyIndex()]] > 0;
    }

    public boolean poll() {
        int retval = this.nativePoll(this.nativeID, this.keyData, this.dummyRelAxesData, this.dummyAbsAxesData);
        return retval >= 0;
    }

    private void setupKeyMap() {
        int i = 0;
        while (i < Component.Identifier.Key.LAST.getKeyIndex()) {
            this.keyMap[i] = this.numKeys;
            ++i;
        }
        i = 0;
        while (i < this.numKeys) {
            int tempNativeID = this.supportedKeys[i];
            Component.Identifier.Key tempKeyID = Component.Identifier.Key.VOID;
            try {
                tempKeyID = (Component.Identifier.Key)LinuxNativeTypesMap.getButtonID(tempNativeID);
            }
            catch (ClassCastException e) {
                System.out.println("LinuxNativeTypesMap.getButtonID() returned " + LinuxNativeTypesMap.getButtonID(tempNativeID).getClass().toString());
            }
            if (tempKeyID.getKeyIndex() < this.keyMap.length) {
                this.keyMap[tempKeyID.getKeyIndex()] = i;
            }
            ++i;
        }
    }

    private void renameKeys() {
        Component[] tempAxes = this.getComponents();
        int i = 0;
        while (i < tempAxes.length) {
            Component tempAxis = tempAxes[i];
            int nativeKeyID = this.supportedKeys[this.keyMap[((Component.Identifier.Key)tempAxis.getIdentifier()).getKeyIndex()]];
            if (nativeKeyID != 240) {
                String tempName = LinuxNativeTypesMap.getButtonName(nativeKeyID);
                ((AbstractComponent)tempAxis).setName(tempName);
            }
            ++i;
        }
    }

    private void getSupportedButtons(int[] supportedButtons) {
        this.getNativeSupportedButtons(this.nativeID, supportedButtons);
    }

    private native void getNativeSupportedButtons(int var1, int[] var2);

    private native int nativePoll(int var1, int[] var2, int[] var3, int[] var4);

    private native int getNativePortType(int var1);
}

