/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.AbstractController;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.LinuxDevice;
import net.java.games.input.LinuxMouse;
import net.java.games.input.LinuxNativeTypesMap;
import net.java.games.util.plugins.Plugin;

public class LinuxEnvironmentPlugin
extends ControllerEnvironment
implements Plugin {
    private Controller[] controllers;

    static {
        if (LinuxEnvironmentPlugin.isSupported()) {
            System.loadLibrary("jinput-linux");
        }
    }

    public LinuxEnvironmentPlugin() {
        if (LinuxEnvironmentPlugin.isSupported()) {
            LinuxNativeTypesMap.init();
            this.init();
            this.createControllers();
        } else {
            this.controllers = new Controller[0];
        }
    }

    public static boolean isSupported() {
        System.out.println("OS name is: " + System.getProperty("os.name"));
        if (System.getProperty("os.name").indexOf("Linux") != -1) {
            System.out.println("Linux plugin is supported");
            return true;
        }
        System.out.println("Linux plugin is not supported");
        return false;
    }

    public Controller[] getControllers() {
        return this.controllers;
    }

    private void createControllers() {
        int numDevices = this.getNumberOfDevices();
        Controller[] tempControllers = new Controller[numDevices];
        int numRealDevices = 0;
        int i = 0;
        while (i < numDevices) {
            Controller tempController = this.createDevice(i);
            if (tempController != null && (tempController.getComponents().length > 0 || tempController.getControllers().length > 0)) {
                tempControllers[numRealDevices] = tempController;
                ++numRealDevices;
            }
            ++i;
        }
        this.controllers = new Controller[numRealDevices];
        i = 0;
        while (i < numRealDevices) {
            this.controllers[i] = tempControllers[i];
            ++i;
        }
    }

    private Controller createDevice(int deviceNumber) {
        String name = this.getDeviceName(deviceNumber);
        int numAbsAxes = this.getNumAbsAxes(deviceNumber);
        int numRelAxes = this.getNumRelAxes(deviceNumber);
        int numButtons = this.getNumButtons(deviceNumber);
        AbstractController device = null;
        int mouseCharacteristic = 0;
        int keyboardCharacteristic = 0;
        int joystickCharacteristic = 0;
        if (name.toLowerCase().indexOf("mouse") >= 0) {
            ++mouseCharacteristic;
        }
        if (name.toLowerCase().indexOf("keyboard") >= 0) {
            ++keyboardCharacteristic;
        }
        if (name.toLowerCase().indexOf("joystick") >= 0) {
            ++joystickCharacteristic;
        }
        mouseCharacteristic = numRelAxes >= 2 ? ++mouseCharacteristic : --mouseCharacteristic;
        joystickCharacteristic = numAbsAxes >= 2 ? ++joystickCharacteristic : --joystickCharacteristic;
        keyboardCharacteristic = numButtons > 64 ? ++keyboardCharacteristic : --keyboardCharacteristic;
        device = mouseCharacteristic > keyboardCharacteristic && mouseCharacteristic > joystickCharacteristic ? new LinuxMouse(new LinuxDevice(deviceNumber, name, numButtons, numRelAxes, numAbsAxes)) : (keyboardCharacteristic > mouseCharacteristic && keyboardCharacteristic > joystickCharacteristic ? new LinuxDevice(deviceNumber, name, numButtons, numRelAxes, numAbsAxes, Controller.Type.KEYBOARD) : (joystickCharacteristic > keyboardCharacteristic && joystickCharacteristic > mouseCharacteristic ? new LinuxDevice(deviceNumber, name, numButtons, numRelAxes, numAbsAxes) : new LinuxDevice(deviceNumber, name, numButtons, numRelAxes, numAbsAxes)));
        return device;
    }

    private native String getDeviceName(int var1);

    private native int getNumAbsAxes(int var1);

    private native int getNumRelAxes(int var1);

    private native int getNumButtons(int var1);

    private native int init();

    private native int getNumberOfDevices();
}

