/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.util.ArrayList;
import net.java.games.input.AbstractComponent;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.LinuxAxis;
import net.java.games.input.LinuxNativeTypesMap;

public class LinuxDevice
extends AbstractController {
    private String name;
    private int nativeID;
    private Controller.PortType portType;
    private LinuxAxis[] buttons;
    private LinuxAxis[] relAxes;
    private LinuxAxis[] absAxes;
    private LinuxHat[] hats;
    private int[] hatAxisIDs = new int[8];
    private int numButtons;
    private int numRelAxes;
    private int numAbsAxes;
    private int numHats = 0;
    private int[] buttonData;
    private int[] relAxesData;
    private int[] absAxesData;
    private Controller.Type typeGuess = Controller.Type.UNKNOWN;
    private ArrayList axesArray = new ArrayList();

    public LinuxDevice(int nativeID, String name, int numButtons, int numRelAxes, int numAbsAxes, Controller.Type type) {
        this(nativeID, name, numButtons, numRelAxes, numAbsAxes);
        this.typeGuess = type;
    }

    public LinuxDevice(int nativeID, String name, int numButtons, int numRelAxes, int numAbsAxes) {
        super(name);
        this.children = AbstractController.NO_CONTROLLERS;
        this.rumblers = AbstractController.NO_RUMBLERS;
        this.nativeID = nativeID;
        this.portType = LinuxNativeTypesMap.getPortType(this.getNativePortType(nativeID));
        int i = 0;
        while (i < 8) {
            this.hatAxisIDs[i] = -1;
            ++i;
        }
        this.numButtons = numButtons;
        this.numRelAxes = numRelAxes;
        this.numAbsAxes = numAbsAxes;
        this.numHats = 0;
        this.buttonData = new int[numButtons];
        this.relAxesData = new int[numRelAxes];
        this.absAxesData = new int[numAbsAxes];
        this.createButtons(numButtons);
        this.createRelAxes(numRelAxes);
        this.createAbsAxes(numAbsAxes);
        this.createHats();
        i = 0;
        while (i < numAbsAxes) {
            if (this.absAxes[i] != null) {
                this.axesArray.add(this.absAxes[i]);
            }
            ++i;
        }
        i = 0;
        while (i < numRelAxes) {
            if (this.relAxes[i] != null) {
                this.axesArray.add(this.relAxes[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.numHats) {
            if (this.hats[i] != null) {
                this.axesArray.add(this.hats[i]);
            }
            ++i;
        }
        i = 0;
        while (i < numButtons) {
            if (this.buttons[i] != null) {
                this.axesArray.add(this.buttons[i]);
            }
            ++i;
        }
        this.components = this.axesArray.toArray(this.components);
        this.guessType();
    }

    public Controller.PortType getPortType() {
        return this.portType;
    }

    public Controller.Type getType() {
        return this.typeGuess;
    }

    private void createButtons(int numButtons) {
        int[] supportedButtons = new int[numButtons];
        this.buttons = new LinuxAxis[numButtons];
        if (numButtons > 0) {
            this.getSupportedButtons(supportedButtons);
            int i = 0;
            while (i < numButtons) {
                this.buttons[i] = this.createButton(i, supportedButtons[i]);
                ++i;
            }
        }
    }

    private void createRelAxes(int numRelAxes) {
        int[] supportedRelAxes = new int[numRelAxes];
        this.getSupportedRelAxes(supportedRelAxes);
        this.relAxes = new LinuxAxis[numRelAxes];
        int i = 0;
        while (i < numRelAxes) {
            this.relAxes[i] = this.createRelAxis(i, supportedRelAxes[i]);
            ++i;
        }
    }

    private void createAbsAxes(int numAbsAxes) {
        int[] supportedAbsAxes = new int[numAbsAxes];
        this.getSupportedAbsAxes(supportedAbsAxes);
        this.absAxes = new LinuxAxis[numAbsAxes];
        int i = 0;
        while (i < numAbsAxes) {
            if (supportedAbsAxes[i] == 16) {
                this.hatAxisIDs[0] = i;
            } else if (supportedAbsAxes[i] == 17) {
                this.hatAxisIDs[1] = i;
            } else if (supportedAbsAxes[i] == 18) {
                this.hatAxisIDs[2] = i;
            } else if (supportedAbsAxes[i] == 19) {
                this.hatAxisIDs[3] = i;
            } else if (supportedAbsAxes[i] == 20) {
                this.hatAxisIDs[4] = i;
            } else if (supportedAbsAxes[i] == 21) {
                this.hatAxisIDs[5] = i;
            } else if (supportedAbsAxes[i] == 22) {
                this.hatAxisIDs[6] = i;
            } else if (supportedAbsAxes[i] == 23) {
                this.hatAxisIDs[7] = i;
            } else {
                this.absAxes[i] = this.createAbsAxis(i, supportedAbsAxes[i]);
            }
            ++i;
        }
    }

    private void createHats() {
        LinuxHat[] tempHats = new LinuxHat[4];
        int i = 0;
        while (i < 4) {
            int x = i * 2;
            int y = x + 1;
            if (this.hatAxisIDs[x] != -1 || this.hatAxisIDs[y] != -1) {
                String hatName = "Hat " + i;
                tempHats[this.numHats] = this.createHat(hatName, this.hatAxisIDs[x], this.hatAxisIDs[y]);
                ++this.numHats;
            }
            ++i;
        }
        this.hats = new LinuxHat[this.numHats];
        i = 0;
        while (i < this.numHats) {
            this.hats[i] = tempHats[i];
            ++i;
        }
    }

    private void guessType() {
        String tempName;
        int joystickCharacteristic = 0;
        int digitiserCharacteristic = 0;
        int gamepadCharacteristic = 0;
        int miscCharacteristic = 0;
        int mouseCharacteristic = 0;
        int[] supportedButtons = new int[this.numButtons];
        this.getSupportedButtons(supportedButtons);
        int i = 0;
        while (i < this.numButtons) {
            switch (supportedButtons[i]) {
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 292: 
                case 293: 
                case 294: 
                case 295: 
                case 296: 
                case 297: 
                case 298: 
                case 299: 
                case 303: {
                    ++joystickCharacteristic;
                    break;
                }
                case 304: 
                case 305: 
                case 306: 
                case 307: 
                case 308: 
                case 309: 
                case 310: 
                case 311: 
                case 312: 
                case 313: 
                case 314: 
                case 316: 
                case 317: 
                case 318: {
                    ++gamepadCharacteristic;
                    break;
                }
                case 256: 
                case 257: 
                case 258: 
                case 259: 
                case 260: 
                case 261: 
                case 262: 
                case 263: 
                case 264: 
                case 265: {
                    ++miscCharacteristic;
                    break;
                }
                case 272: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 277: 
                case 278: {
                    ++mouseCharacteristic;
                    break;
                }
                case 320: 
                case 321: 
                case 322: 
                case 323: 
                case 324: 
                case 325: 
                case 326: 
                case 327: 
                case 330: 
                case 331: 
                case 332: {
                    ++digitiserCharacteristic;
                }
            }
            ++i;
        }
        if (joystickCharacteristic > 0 && joystickCharacteristic >= digitiserCharacteristic && joystickCharacteristic >= gamepadCharacteristic && joystickCharacteristic >= miscCharacteristic && joystickCharacteristic >= mouseCharacteristic) {
            this.typeGuess = Controller.Type.STICK;
        } else if (gamepadCharacteristic > 0 && gamepadCharacteristic >= digitiserCharacteristic && gamepadCharacteristic >= joystickCharacteristic && gamepadCharacteristic >= miscCharacteristic && gamepadCharacteristic >= mouseCharacteristic) {
            this.typeGuess = Controller.Type.GAMEPAD;
        } else if (digitiserCharacteristic > 0 && digitiserCharacteristic >= gamepadCharacteristic && digitiserCharacteristic >= joystickCharacteristic && digitiserCharacteristic >= miscCharacteristic && digitiserCharacteristic >= mouseCharacteristic) {
            this.typeGuess = Controller.Type.TRACKPAD;
        } else if (miscCharacteristic > 0 && miscCharacteristic >= gamepadCharacteristic && miscCharacteristic >= joystickCharacteristic && miscCharacteristic >= miscCharacteristic && miscCharacteristic >= mouseCharacteristic) {
            this.typeGuess = Controller.Type.STICK;
        } else if (mouseCharacteristic > 0 && mouseCharacteristic >= digitiserCharacteristic && mouseCharacteristic >= joystickCharacteristic && mouseCharacteristic >= miscCharacteristic && mouseCharacteristic >= gamepadCharacteristic) {
            this.typeGuess = Controller.Type.MOUSE;
        }
        if (this.typeGuess == Controller.Type.STICK && ((tempName = this.getName().toLowerCase()).indexOf("gamepad") > -1 || tempName.indexOf("game pad") > -1)) {
            this.typeGuess = Controller.Type.GAMEPAD;
        }
    }

    private LinuxAxis createButton(int buttonNumber, int nativeButtonType) {
        Component.Identifier id = LinuxNativeTypesMap.getButtonID(nativeButtonType);
        String name = LinuxNativeTypesMap.getButtonName(nativeButtonType);
        if (name == null) {
            name = "Uknown button";
            id = Component.Identifier.Button.UNKNOWN;
        }
        return new LinuxAxis(this, buttonNumber, name, id, 0.0f, false, true, false);
    }

    private LinuxAxis createRelAxis(int axisNumber, int nativeType) {
        Component.Identifier id = LinuxNativeTypesMap.getRelAxisID(nativeType);
        String name = LinuxNativeTypesMap.getRelAxisName(nativeType);
        return new LinuxAxis(this, axisNumber, name, id, 0.0f, true, false, true);
    }

    private LinuxAxis createAbsAxis(int axisNumber, int nativeType) {
        Component.Identifier id = LinuxNativeTypesMap.getAbsAxisID(nativeType);
        String name = LinuxNativeTypesMap.getAbsAxisName(nativeType);
        if (this.getName().equals("Analog 3-axis 4-button joystick") && this.portType == Controller.PortType.GAME && id == Component.Identifier.Axis.RZ && name.equals("Rudder")) {
            id = Component.Identifier.Axis.SLIDER;
            name = "Throttle";
        }
        return new LinuxAxis(this, axisNumber, name, id, this.getAbsAxisFuzz(axisNumber), true, false, this.getAbsAxisMinimum(axisNumber), this.getAbsAxisMaximum(axisNumber));
    }

    private LinuxHat createHat(String name, int xAxisID, int yAxisID) {
        return new LinuxHat(this, name, xAxisID, yAxisID);
    }

    public boolean poll() {
        int retval = this.nativePoll(this.nativeID, this.buttonData, this.relAxesData, this.absAxesData);
        return retval >= 0;
    }

    public float getButtonValue(int buttonID) {
        if (this.buttonData[buttonID] > 0) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float getAbsAxisValue(int axisID) {
        return this.absAxesData[axisID];
    }

    public float getRelAxisValue(int axisID) {
        return this.relAxesData[axisID];
    }

    public float getAbsAxisFuzz(int axisID) {
        return this.getNativeAbsAxisFuzz(this.nativeID, axisID);
    }

    public float getAbsAxisMaximum(int axisID) {
        return this.getNativeAbsAxisMaximum(this.nativeID, axisID);
    }

    public float getAbsAxisMinimum(int axisID) {
        return this.getNativeAbsAxisMinimum(this.nativeID, axisID);
    }

    private void getSupportedButtons(int[] supportedButtons) {
        if (supportedButtons.length == 0) {
            return;
        }
        this.getNativeSupportedButtons(this.nativeID, supportedButtons);
    }

    private void getSupportedAbsAxes(int[] suportedAbsAxes) {
        this.getNativeSupportedAbsAxes(this.nativeID, suportedAbsAxes);
    }

    private void getSupportedRelAxes(int[] supportedRelAxes) {
        this.getNativeSupportedRelAxes(this.nativeID, supportedRelAxes);
    }

    private native void getNativeSupportedAbsAxes(int var1, int[] var2);

    private native void getNativeSupportedRelAxes(int var1, int[] var2);

    private native void getNativeSupportedButtons(int var1, int[] var2);

    private native int nativePoll(int var1, int[] var2, int[] var3, int[] var4);

    private native int getNativeAbsAxisFuzz(int var1, int var2);

    private native int getNativeAbsAxisMaximum(int var1, int var2);

    private native int getNativeAbsAxisMinimum(int var1, int var2);

    private native int getNativePortType(int var1);

    public static class LinuxHat
    extends AbstractComponent {
        private LinuxDevice controller;
        private int xAxisID;
        private int yAxisID;
        private float value;

        public LinuxHat(LinuxDevice controller, String name, int xAxisID, int yAxisID) {
            super(name, Component.Identifier.Axis.POV);
            System.out.println("Creating a Hat for device " + controller.getName() + " named " + name + " from axis " + xAxisID + " and " + yAxisID);
            this.controller = controller;
            this.xAxisID = xAxisID;
            this.yAxisID = yAxisID;
        }

        public boolean isRelative() {
            return false;
        }

        public boolean isAnalog() {
            return false;
        }

        public boolean isNormalised() {
            return true;
        }

        public float getPollData() {
            if (this.isPolling()) {
                this.updateData();
            }
            return this.value;
        }

        private void updateData() {
            int newXAxisValue = (int)this.controller.getAbsAxisValue(this.xAxisID);
            int newYAxisValue = (int)this.controller.getAbsAxisValue(this.yAxisID);
            if (newXAxisValue == 0 && newYAxisValue == 0) {
                this.value = 0.0f;
            } else if (newXAxisValue > 0 && newYAxisValue < 0) {
                this.value = 0.375f;
            } else if (newXAxisValue > 0 && newYAxisValue == 0) {
                this.value = 0.5f;
            } else if (newXAxisValue > 0 && newYAxisValue > 0) {
                this.value = 0.625f;
            } else if (newXAxisValue == 0 && newYAxisValue > 0) {
                this.value = 0.75f;
            } else if (newXAxisValue < 0 && newYAxisValue > 0) {
                this.value = 0.875f;
            } else if (newXAxisValue < 0 && newYAxisValue == 0) {
                this.value = 1.0f;
            } else if (newXAxisValue < 0 && newYAxisValue < 0) {
                this.value = 0.125f;
            } else if (newXAxisValue == 0 && newYAxisValue < 0) {
                this.value = 0.25f;
            }
        }
    }
}

