/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.AbstractComponent;
import net.java.games.input.Component;
import net.java.games.input.LinuxDevice;

public class LinuxAxis
extends AbstractComponent {
    private LinuxDevice controller;
    private int axisID;
    private float nullZone = 0.0f;
    private boolean isAnalog = true;
    private boolean isNormalized = false;
    private boolean isRelative = false;
    private boolean needsNormalising = false;
    private float minAxisValue;
    private float maxAxisValue;
    private float value = 0.0f;

    public LinuxAxis(LinuxDevice controller, int axisID, String name, Component.Identifier id, float deadzone, boolean isAnalog, boolean isNormalized, boolean isRelative) {
        super(name, id);
        this.controller = controller;
        this.axisID = axisID;
        this.nullZone = deadzone;
        this.isAnalog = isAnalog;
        this.isNormalized = isNormalized;
        this.isRelative = isRelative;
    }

    public LinuxAxis(LinuxDevice controller, int axisID, String name, Component.Identifier id, float deadzone, boolean isAnalog, boolean isRelative, float minAxisValue, float maxAxisValue) {
        super(name, id);
        this.controller = controller;
        this.axisID = axisID;
        this.nullZone = deadzone;
        this.isAnalog = isAnalog;
        this.isNormalized = false;
        this.isRelative = isRelative;
        this.needsNormalising = true;
        this.minAxisValue = minAxisValue;
        this.maxAxisValue = maxAxisValue;
    }

    public boolean isRelative() {
        return this.isRelative;
    }

    public float getDeadZone() {
        return this.nullZone;
    }

    public boolean isAnalog() {
        return this.isAnalog;
    }

    public float getPollData() {
        if (this.isPolling()) {
            this.updateValue();
        }
        return this.value;
    }

    private void updateValue() {
        if (this.isAnalog) {
            float tempVal = this.isRelative ? this.controller.getRelAxisValue(this.axisID) : this.controller.getAbsAxisValue(this.axisID);
            if (this.needsNormalising) {
                if (this.isRelative) {
                    if (tempVal > 1.0f) {
                        tempVal = 1.0f;
                    } else if (tempVal < -1.0f) {
                        tempVal = -1.0f;
                    }
                    this.value = tempVal;
                } else {
                    float center = (this.maxAxisValue - this.minAxisValue) / 2.0f;
                    this.value = (tempVal - this.minAxisValue - center) / center;
                }
            } else {
                this.value = tempVal;
            }
        } else {
            this.value = this.controller.getButtonValue(this.axisID);
        }
    }

    public boolean isNormalized() {
        return this.isNormalized || this.needsNormalising;
    }
}

