/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.AbstractComponent;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Mouse;

class DirectInputMouse
extends Mouse {
    private static final int DIDEVTYPEMOUSE_UNKNOWN = 1;
    private static final int DIDEVTYPEMOUSE_TRADITIONAL = 2;
    private static final int DIDEVTYPEMOUSE_FINGERSTICK = 3;
    private static final int DIDEVTYPEMOUSE_TOUCHPAD = 4;
    private static final int DIDEVTYPEMOUSE_TRACKBALL = 5;
    private long lpDevice;
    private Controller.Type type;
    private byte[] mouseData = new byte[20];

    private DirectInputMouse(long lpDevice, int subtype, String productName, String instanceName) {
        super(String.valueOf(productName) + " " + instanceName);
        this.lpDevice = lpDevice;
        this.buttons = new ButtonsImpl();
        this.ball = new BallImpl();
        switch (subtype) {
            case 3: {
                this.type = Controller.Type.FINGERSTICK;
                break;
            }
            case 4: {
                this.type = Controller.Type.TRACKPAD;
                break;
            }
            case 5: {
                this.type = Controller.Type.TRACKBALL;
                break;
            }
            default: {
                this.type = Controller.Type.MOUSE;
            }
        }
        this.renameAxes(lpDevice);
    }

    private void renameAxis(Component.Identifier id, String name) {
        AbstractComponent axis = id instanceof Component.Identifier.Button ? (AbstractComponent)this.getButtons().getComponent(id) : (AbstractComponent)this.getBall().getComponent(id);
        axis.setName(name);
    }

    public boolean poll() {
        return this.pollNative(this.lpDevice, this.mouseData);
    }

    public Controller.Type getType() {
        return this.type;
    }

    public static DirectInputMouse createMouse(long lpDevice, int subtype, String productName, String instanceName) {
        return new DirectInputMouse(lpDevice, subtype, productName, instanceName);
    }

    private native boolean pollNative(long var1, byte[] var3);

    private native boolean renameAxes(long var1);

    private native int getNumButtons(long var1);

    private native int getNumAxes(long var1);

    class BallImpl
    extends Mouse.Ball {
        private int numAxes;

        public BallImpl() {
            super(DirectInputMouse.this, String.valueOf(DirectInputMouse.this.getName()) + " ball");
            this.numAxes = DirectInputMouse.this.getNumAxes(DirectInputMouse.this.lpDevice);
            this.x = new BallAxis((Component.Identifier)Component.Identifier.Axis.X);
            this.y = new BallAxis((Component.Identifier)Component.Identifier.Axis.Y);
            if (this.numAxes > 2) {
                this.wheel = new BallAxis((Component.Identifier)Component.Identifier.Axis.SLIDER);
            }
        }
    }

    class ButtonsImpl
    extends Mouse.Buttons {
        private int numButtons;

        public ButtonsImpl() {
            super(DirectInputMouse.this, String.valueOf(DirectInputMouse.this.getName()) + " buttons");
            this.numButtons = DirectInputMouse.this.getNumButtons(DirectInputMouse.this.lpDevice);
            this.left = new ButtonImpl(Component.Identifier.Button.LEFT);
            this.right = new ButtonImpl(Component.Identifier.Button.RIGHT);
            if (this.numButtons > 2) {
                this.middle = new ButtonImpl(Component.Identifier.Button.MIDDLE);
            }
            if (this.numButtons > 3) {
                this.side = new ButtonImpl(Component.Identifier.Button.SIDE);
            }
            if (this.numButtons > 4) {
                this.extra = new ButtonImpl(Component.Identifier.Button.EXTRA);
            }
            if (this.numButtons > 5) {
                this.forward = new ButtonImpl(Component.Identifier.Button.FORWARD);
            }
            if (this.numButtons > 6) {
                this.back = new ButtonImpl(Component.Identifier.Button.BACK);
            }
        }
    }

    class ButtonImpl
    extends Mouse.Button {
        private final int index;

        public ButtonImpl(Component.Identifier.Button id) {
            super(DirectInputMouse.this, id.getName(), id);
            if (id == Component.Identifier.Button.LEFT) {
                this.index = 12;
            } else if (id == Component.Identifier.Button.RIGHT) {
                this.index = 13;
            } else if (id == Component.Identifier.Button.MIDDLE) {
                this.index = 14;
            } else if (id == Component.Identifier.Button.SIDE) {
                this.index = 15;
            } else if (id == Component.Identifier.Button.EXTRA) {
                this.index = 16;
            } else if (id == Component.Identifier.Button.FORWARD) {
                this.index = 17;
            } else if (id == Component.Identifier.Button.BACK) {
                this.index = 18;
            } else {
                throw new RuntimeException("Unknown button");
            }
        }

        public float getPollData() {
            byte data = DirectInputMouse.this.mouseData[this.index];
            if ((data & 0x80) != 0) {
                return 1.0f;
            }
            return 0.0f;
        }

        public boolean isRelative() {
            return false;
        }
    }

    class BallAxis
    extends AbstractComponent {
        private final int index;

        public BallAxis(Component.Identifier id) {
            super(id.getName(), id);
            if (id == Component.Identifier.Axis.X) {
                this.index = 0;
            } else if (id == Component.Identifier.Axis.Y) {
                this.index = 4;
            } else if (id == Component.Identifier.Axis.SLIDER) {
                this.index = 8;
            } else {
                throw new RuntimeException("Unknown mouse axis");
            }
        }

        public float getPollData() {
            int data = DirectInputMouse.this.mouseData[this.index + 3] << 24 | DirectInputMouse.this.mouseData[this.index + 2] << 16 | DirectInputMouse.this.mouseData[this.index + 1] << 8 | DirectInputMouse.this.mouseData[this.index];
            return data;
        }

        public boolean isRelative() {
            return true;
        }

        public boolean isAnalog() {
            return true;
        }

        public boolean isNormalized() {
            return false;
        }
    }
}

