/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.AbstractComponent;
import net.java.games.input.Component;
import net.java.games.input.Keyboard;
import net.java.games.input.StandardKeyboard;

class DirectInputKeyboard
extends StandardKeyboard {
    private static final int DIDEVTYPEKEYBOARD_UNKNOWN = 0;
    private static final int DIDEVTYPEKEYBOARD_PCXT = 1;
    private static final int DIDEVTYPEKEYBOARD_OLIVETTI = 2;
    private static final int DIDEVTYPEKEYBOARD_PCAT = 3;
    private static final int DIDEVTYPEKEYBOARD_PCENH = 4;
    private static final int DIDEVTYPEKEYBOARD_NOKIA1050 = 5;
    private static final int DIDEVTYPEKEYBOARD_NOKIA9140 = 6;
    private static final int DIDEVTYPEKEYBOARD_NEC98 = 7;
    private static final int DIDEVTYPEKEYBOARD_NEC98LAPTOP = 8;
    private static final int DIDEVTYPEKEYBOARD_NEC98106 = 9;
    private static final int DIDEVTYPEKEYBOARD_JAPAN106 = 10;
    private static final int DIDEVTYPEKEYBOARD_JAPANAX = 11;
    private static final int DIDEVTYPEKEYBOARD_J3100 = 12;
    private static final int[] CROSSTABLE;
    private long lpDevice;
    private int subtype;
    private byte[] keyData = new byte[256];

    static {
        int[] nArray = new int[124];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArray[16] = 16;
        nArray[17] = 17;
        nArray[18] = 18;
        nArray[19] = 19;
        nArray[20] = 20;
        nArray[21] = 21;
        nArray[22] = 22;
        nArray[23] = 23;
        nArray[24] = 24;
        nArray[25] = 25;
        nArray[26] = 26;
        nArray[27] = 27;
        nArray[28] = 28;
        nArray[29] = 29;
        nArray[30] = 30;
        nArray[31] = 31;
        nArray[32] = 32;
        nArray[33] = 33;
        nArray[34] = 34;
        nArray[35] = 35;
        nArray[36] = 36;
        nArray[37] = 37;
        nArray[38] = 38;
        nArray[39] = 39;
        nArray[40] = 40;
        nArray[41] = 41;
        nArray[42] = 42;
        nArray[43] = 43;
        nArray[44] = 44;
        nArray[45] = 45;
        nArray[46] = 46;
        nArray[47] = 47;
        nArray[48] = 48;
        nArray[49] = 49;
        nArray[50] = 50;
        nArray[51] = 51;
        nArray[52] = 52;
        nArray[53] = 53;
        nArray[54] = 54;
        nArray[55] = 55;
        nArray[56] = 56;
        nArray[57] = 57;
        nArray[58] = 58;
        nArray[59] = 59;
        nArray[60] = 60;
        nArray[61] = 61;
        nArray[62] = 62;
        nArray[63] = 63;
        nArray[64] = 64;
        nArray[65] = 65;
        nArray[66] = 66;
        nArray[67] = 67;
        nArray[68] = 68;
        nArray[69] = 69;
        nArray[70] = 70;
        nArray[71] = 71;
        nArray[72] = 72;
        nArray[73] = 73;
        nArray[74] = 74;
        nArray[75] = 75;
        nArray[76] = 76;
        nArray[77] = 77;
        nArray[78] = 78;
        nArray[79] = 79;
        nArray[80] = 80;
        nArray[81] = 81;
        nArray[82] = 82;
        nArray[83] = 83;
        nArray[84] = 87;
        nArray[85] = 88;
        nArray[86] = 100;
        nArray[87] = 101;
        nArray[88] = 102;
        nArray[89] = 112;
        nArray[90] = 121;
        nArray[91] = 123;
        nArray[92] = 125;
        nArray[93] = 141;
        nArray[94] = 144;
        nArray[95] = 145;
        nArray[96] = 146;
        nArray[97] = 147;
        nArray[98] = 148;
        nArray[99] = 149;
        nArray[100] = 150;
        nArray[101] = 151;
        nArray[102] = 156;
        nArray[103] = 157;
        nArray[104] = 179;
        nArray[105] = 181;
        nArray[106] = 183;
        nArray[107] = 184;
        nArray[108] = 197;
        nArray[109] = 199;
        nArray[110] = 200;
        nArray[111] = 201;
        nArray[112] = 203;
        nArray[113] = 205;
        nArray[114] = 207;
        nArray[115] = 208;
        nArray[116] = 209;
        nArray[117] = 210;
        nArray[118] = 211;
        nArray[119] = 219;
        nArray[120] = 220;
        nArray[121] = 221;
        nArray[122] = 222;
        nArray[123] = 223;
        CROSSTABLE = nArray;
    }

    private DirectInputKeyboard(long lpDevice, int subtype, String productName, String instanceName) {
        super(String.valueOf(productName) + " (" + instanceName + ")");
        this.lpDevice = lpDevice;
        this.subtype = subtype;
    }

    private void renameKey(int index, String name) {
        int keyIndex = index;
        if (keyIndex > CROSSTABLE.length) {
            keyIndex = CROSSTABLE.length - 1;
        }
        while (CROSSTABLE[keyIndex] > index) {
            --keyIndex;
        }
        if (CROSSTABLE[keyIndex] == index) {
            Component[] components = this.getComponents();
            AbstractComponent key = (AbstractComponent)components[index];
            if (name != null && name.length() > 0) {
                key.setName(name);
            }
        }
    }

    public boolean poll() {
        return this.pollNative(this.lpDevice, this.keyData);
    }

    protected boolean isKeyPressed(Keyboard.Key key) {
        Component.Identifier.Key id = (Component.Identifier.Key)key.getIdentifier();
        int keyIndex = id.getKeyIndex();
        int crossIndex = CROSSTABLE[keyIndex];
        return (this.keyData[crossIndex] & 0x80) != 0;
    }

    private native boolean pollNative(long var1, byte[] var3);

    private native boolean renameKeys(long var1);

    public static DirectInputKeyboard createKeyboard(long lpDevice, int subtype, String productName, String instanceName) {
        DirectInputKeyboard ret = new DirectInputKeyboard(lpDevice, subtype, productName, instanceName);
        ret.renameKeys(lpDevice);
        return ret;
    }
}

