/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.util.ArrayList;
import java.util.Iterator;
import net.java.games.input.AbstractController;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.DirectInputDevice;
import net.java.games.input.DirectInputKeyboard;
import net.java.games.input.DirectInputMouse;
import net.java.games.util.plugins.Plugin;

public class DirectInputEnvironmentPlugin
extends ControllerEnvironment
implements Plugin {
    private static final int DI8DEVTYPE_DEVICE = 17;
    private static final int DI8DEVTYPE_MOUSE = 18;
    private static final int DI8DEVTYPE_KEYBOARD = 19;
    private static final int DI8DEVTYPE_JOYSTICK = 20;
    private static final int DI8DEVTYPE_GAMEPAD = 21;
    private static final int DI8DEVTYPE_DRIVING = 22;
    private static final int DI8DEVTYPE_FLIGHT = 23;
    private static final int DI8DEVTYPE_1STPERSON = 24;
    private static final int DI8DEVTYPE_DEVICECTRL = 25;
    private static final int DI8DEVTYPE_SCREENPOINTER = 26;
    private static final int DI8DEVTYPE_REMOTE = 27;
    private static final int DI8DEVTYPE_SUPPLEMENTAL = 28;
    private long lpDirectInput;
    private Controller[] controllers;

    static {
        if (DirectInputEnvironmentPlugin.isSupported()) {
            System.loadLibrary("jinput-dxplugin");
        }
    }

    private static int GET_DIDEVICE_TYPE(int dwDevType) {
        return dwDevType & 0xFF;
    }

    private static int GET_DIDEVICE_SUBTYPE(int dwDevType) {
        return (byte)((short)dwDevType >> 8 & 0xFF);
    }

    public DirectInputEnvironmentPlugin() {
        if (DirectInputEnvironmentPlugin.isSupported()) {
            this.lpDirectInput = this.directInputCreate();
            this.enumControllers();
        } else {
            this.controllers = new Controller[0];
        }
    }

    public static boolean isSupported() {
        System.out.println("OS name is: " + System.getProperty("os.name"));
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            System.out.println("DX8 plugin is supported");
            return true;
        }
        System.out.println("DX8 plugin is not supported");
        return false;
    }

    public Controller[] getControllers() {
        return this.controllers;
    }

    private void enumControllers() {
        if (this.lpDirectInput == 0L) {
            this.controllers = new Controller[0];
            return;
        }
        ArrayList tempDevices = new ArrayList();
        this.enumDevices(this.lpDirectInput, tempDevices);
        this.controllers = new Controller[tempDevices.size()];
        Iterator it = tempDevices.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.controllers[i] = (Controller)it.next();
            ++i;
        }
    }

    private void addDevice(ArrayList list, long lpDevice, int type, String productName, String instanceName, boolean polled) {
        int category = DirectInputEnvironmentPlugin.GET_DIDEVICE_TYPE(type);
        int subtype = DirectInputEnvironmentPlugin.GET_DIDEVICE_SUBTYPE(type);
        AbstractController c = category == 18 ? DirectInputMouse.createMouse(lpDevice, subtype, productName, instanceName) : (category == 19 ? DirectInputKeyboard.createKeyboard(lpDevice, subtype, productName, instanceName) : DirectInputDevice.createDevice(lpDevice, subtype, productName, instanceName, polled));
        if (c != null) {
            list.add(c);
        }
    }

    private native long directInputCreate();

    private native boolean enumDevices(long var1, ArrayList var3);
}

