/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.util.ArrayList;
import java.util.Iterator;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.DirectInputAxis;
import net.java.games.input.DirectInputRumbler;
import net.java.games.input.Rumbler;

class DirectInputDevice
extends AbstractController {
    private long lpDevice;
    private Controller.Type type;
    private boolean polled = true;
    int[] data = new int[38];
    private ArrayList rumblerList = new ArrayList();

    private DirectInputDevice(long lpDevice, int subtype, String productName, String instanceName, boolean polled) {
        super(String.valueOf(productName) + " " + instanceName);
        this.lpDevice = lpDevice;
        this.polled = polled;
        System.out.println("Creating " + productName + " polling = " + polled);
        this.type = Controller.Type.STICK;
        this.components = this.initDirectInputAxes();
    }

    private Component[] initDirectInputAxes() {
        ArrayList list = new ArrayList();
        this.enumObjects(this.lpDevice, list);
        Component[] ret = new Component[list.size()];
        Iterator it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = (Component)it.next();
            ++i;
        }
        return ret;
    }

    private void addAxis(ArrayList list, Component.Identifier id, int didft, String name) {
        list.add(DirectInputAxis.createAxis(this, id, didft, name));
    }

    private void addRumbler(long effect, Component.Identifier axisID, String axisName) {
        this.rumblerList.add(new DirectInputRumbler(this, effect, axisID, axisName));
    }

    public boolean poll() {
        return this.pollNative(this.lpDevice, this.data, this.polled);
    }

    public Controller.Type getType() {
        return this.type;
    }

    public int getPortNumber() {
        return 0;
    }

    public Rumbler[] getRumblers() {
        return this.rumblerList.toArray(new Rumbler[0]);
    }

    private native boolean pollNative(long var1, int[] var3, boolean var4);

    private native boolean enumObjects(long var1, ArrayList var3);

    public static DirectInputDevice createDevice(long lpDevice, int subtype, String productName, String instanceName, boolean polled) {
        return new DirectInputDevice(lpDevice, subtype, productName, instanceName, polled);
    }
}

