/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.AbstractComponent;
import net.java.games.input.Component;
import net.java.games.input.DirectInputDevice;

class DirectInputAxis
extends AbstractComponent {
    private static final int DIDFT_ALL = 0;
    private static final int DIDFT_RELAXIS = 1;
    private static final int DIDFT_ABSAXIS = 2;
    private static final int DIDFT_AXIS = 3;
    private static final int DIDFT_PSHBUTTON = 4;
    private static final int DIDFT_TGLBUTTON = 8;
    private static final int DIDFT_BUTTON = 12;
    private static final int DIDFT_POV = 16;
    private static final int DIDFT_COLLECTION = 64;
    private static final int DIDFT_NODATA = 128;
    private static final int DIDFT_ANYINSTANCE = 0xFFFF00;
    private static final int DIDFT_INSTANCEMASK = 0xFFFF00;
    private static final int DIDFT_FFACTUATOR = 0x1000000;
    private static final int DIDFT_FFEFFECTTRIGGER = 0x2000000;
    private static final int DIDFT_OUTPUT = 0x10000000;
    private static final int DIDFT_NOCOLLECTION = 0xFFFF00;
    private DirectInputDevice device;
    private int offset;
    private int type;
    private int instance;
    private int bitmask = -1;
    private int bitshift = 0;

    private static int DIDFT_MAKEINSTANCE(int n) {
        return (n & 0xFFFF) << 8;
    }

    private static int DIDFT_GETTYPE(int n) {
        return n & 0xFF;
    }

    private static int DIDFT_GETINSTANCE(int n) {
        return n >> 8 & 0xFFFF;
    }

    private static int DIDFT_ENUMCOLLECTION(int n) {
        return (n & 0xFFFF) << 8;
    }

    private DirectInputAxis(DirectInputDevice device, Component.Identifier id, int didft, String name) {
        super(name, id);
        this.device = device;
        this.type = DirectInputAxis.DIDFT_GETTYPE(didft);
        this.instance = DirectInputAxis.DIDFT_GETINSTANCE(didft);
        if (id == Component.Identifier.Axis.X) {
            this.offset = 0;
        } else if (id == Component.Identifier.Axis.Y) {
            this.offset = 1;
        } else if (id == Component.Identifier.Axis.Z) {
            this.offset = 2;
        } else if (id == Component.Identifier.Axis.RX) {
            this.offset = 3;
        } else if (id == Component.Identifier.Axis.RY) {
            this.offset = 4;
        } else if (id == Component.Identifier.Axis.RZ) {
            this.offset = 5;
        } else if (id == Component.Identifier.Axis.SLIDER) {
            this.offset = 6 + (this.instance >> 2);
        } else if (id == Component.Identifier.Axis.POV) {
            this.offset = 8 + this.instance;
        } else if (id instanceof Component.Identifier.Button) {
            this.offset = 12 + this.instance / 4;
            this.bitshift = this.instance % 4 * 8;
            this.bitmask = 255;
        }
    }

    public float getPollData() {
        int data = this.device.data[this.offset] >> this.bitshift & this.bitmask;
        if ((this.type & 0xC) != 0) {
            return (data & 0x80) >> 7;
        }
        if ((this.type & 3) != 0) {
            return (float)data / 32768.0f;
        }
        if ((this.type & 0x10) != 0) {
            if (data == -1) {
                return 0.0f;
            }
            if ((double)data == 0.0) {
                return 0.25f;
            }
            if (data == 4500) {
                return 0.375f;
            }
            if (data == 9000) {
                return 0.5f;
            }
            if (data == 13500) {
                return 0.625f;
            }
            if (data == 18000) {
                return 0.75f;
            }
            if (data == 22500) {
                return 0.875f;
            }
            if (data == 27000) {
                return 1.0f;
            }
            if (data == 31500) {
                return 0.125f;
            }
            System.err.print("Unexpected value for DX8 HAT: " + data);
            return 0.0f;
        }
        return data;
    }

    public boolean isRelative() {
        return (this.type & 1) != 0;
    }

    public boolean isAnalog() {
        return (this.type & 3) != 0;
    }

    public boolean isNormalized() {
        return (this.type & 0x1F) != 0;
    }

    public static DirectInputAxis createAxis(DirectInputDevice device, Component.Identifier id, int didft, String name) {
        return new DirectInputAxis(device, id, didft, name);
    }
}

