/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.Component;
import net.java.games.input.Rumbler;

public interface Controller {
    public Controller[] getControllers();

    public Type getType();

    public Component[] getComponents();

    public Component getComponent(Component.Identifier var1);

    public Rumbler[] getRumblers();

    public boolean poll();

    public PortType getPortType();

    public int getPortNumber();

    public String getName();

    public static class Type {
        private final String name;
        public static final Type UNKNOWN = new Type("unknown");
        public static final Type MOUSE = new Type("mouse");
        public static final Type BALL = new Type("ball");
        public static final Type BUTTONS;
        public static final Type KEYBOARD;
        public static final Type FINGERSTICK;
        public static final Type GAMEPAD;
        public static final Type HEADTRACKER;
        public static final Type RUDDER;
        public static final Type STICK;
        public static final Type TRACKBALL;
        public static final Type TRACKPAD;
        public static final Type WHEEL;

        static {
            KEYBOARD = BUTTONS = new Type("buttons");
            FINGERSTICK = new Type("fingerstick");
            GAMEPAD = new Type("gamepad");
            HEADTRACKER = new Type("headtracker");
            RUDDER = new Type("rudder");
            STICK = new Type("stick");
            TRACKBALL = new Type("trackball");
            TRACKPAD = new Type("trackpad");
            WHEEL = new Type("wheel");
        }

        protected Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class PortType {
        private final String name;
        public static final PortType UNKNOWN = new PortType("Unknown");
        public static final PortType USB = new PortType("USB port");
        public static final PortType GAME = new PortType("Game port");
        public static final PortType NETWORK = new PortType("Network port");
        public static final PortType SERIAL = new PortType("Serial port");
        public static final PortType I8042 = new PortType("i8042 (PS/2)");
        public static final PortType PARALLEL = new PortType("Parallel port");

        protected PortType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

