/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

public interface Component {
    public Identifier getIdentifier();

    public boolean isRelative();

    public boolean isAnalog();

    public boolean isNormalized();

    public boolean isPolling();

    public void setPolling(boolean var1);

    public float getDeadZone();

    public float getPollData();

    public String getName();

    public static class Identifier {
        private final String name;

        protected Identifier(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static class Axis
        extends Identifier {
            public static final Axis X = new Axis("x");
            public static final Axis Y = new Axis("y");
            public static final Axis Z = new Axis("z");
            public static final Axis RX = new Axis("rx");
            public static final Axis RY = new Axis("ry");
            public static final Axis RZ = new Axis("rz");
            public static final Axis SLIDER = new Axis("slider");
            public static final Axis SLIDER_ACCELERATION = new Axis("slider-acceleration");
            public static final Axis SLIDER_FORCE = new Axis("slider-force");
            public static final Axis SLIDER_VELOCITY = new Axis("slider-velocity");
            public static final Axis X_ACCELERATION = new Axis("x-acceleration");
            public static final Axis X_FORCE = new Axis("x-force");
            public static final Axis X_VELOCITY = new Axis("x-velocity");
            public static final Axis Y_ACCELERATION = new Axis("y-acceleration");
            public static final Axis Y_FORCE = new Axis("y-force");
            public static final Axis Y_VELOCITY = new Axis("y-velocity");
            public static final Axis Z_ACCELERATION = new Axis("z-acceleration");
            public static final Axis Z_FORCE = new Axis("z-force");
            public static final Axis Z_VELOCITY = new Axis("z-velocity");
            public static final Axis RX_ACCELERATION = new Axis("rx-acceleration");
            public static final Axis RX_FORCE = new Axis("rx-force");
            public static final Axis RX_VELOCITY = new Axis("rx-velocity");
            public static final Axis RY_ACCELERATION = new Axis("ry-acceleration");
            public static final Axis RY_FORCE = new Axis("ry-force");
            public static final Axis RY_VELOCITY = new Axis("ry-velocity");
            public static final Axis RZ_ACCELERATION = new Axis("rz-acceleration");
            public static final Axis RZ_FORCE = new Axis("rz-force");
            public static final Axis RZ_VELOCITY = new Axis("rz-velocity");
            public static final Axis POV = new Axis("pov");

            protected Axis(String name) {
                super(name);
            }
        }

        public static class Button
        extends Identifier {
            public static final Button _0 = new Button("0");
            public static final Button _1 = new Button("1");
            public static final Button _2 = new Button("2");
            public static final Button _3 = new Button("3");
            public static final Button _4 = new Button("4");
            public static final Button _5 = new Button("5");
            public static final Button _6 = new Button("6");
            public static final Button _7 = new Button("7");
            public static final Button _8 = new Button("8");
            public static final Button _9 = new Button("9");
            public static final Button TRIGGER = new Button("Trigger");
            public static final Button THUMB = new Button("Thumb");
            public static final Button THUMB2 = new Button("Thumb 2");
            public static final Button TOP = new Button("Top");
            public static final Button TOP2 = new Button("Top 2");
            public static final Button PINKIE = new Button("Pinkie");
            public static final Button BASE = new Button("Base");
            public static final Button BASE2 = new Button("Base 2");
            public static final Button BASE3 = new Button("Base 3");
            public static final Button BASE4 = new Button("Base 4");
            public static final Button BASE5 = new Button("Base 5");
            public static final Button BASE6 = new Button("Base 6");
            public static final Button DEAD = new Button("Dead");
            public static final Button A = new Button("A");
            public static final Button B = new Button("B");
            public static final Button C = new Button("C");
            public static final Button X = new Button("X");
            public static final Button Y = new Button("Y");
            public static final Button Z = new Button("Z");
            public static final Button LEFT_THUMB = new Button("Left Thumb");
            public static final Button RIGHT_THUMB = new Button("Right Thumb");
            public static final Button LEFT_THUMB2 = new Button("Left Thumb 2");
            public static final Button RIGHT_THUMB2 = new Button("Right Thumb 2");
            public static final Button SELECT = new Button("Select");
            public static final Button MODE = new Button("Mode");
            public static final Button LEFT_THUMB3 = new Button("Left Thumb 3");
            public static final Button RIGHT_THUMB3 = new Button("Right Thumb 3");
            public static final Button TOOL_PEN = new Button("Pen");
            public static final Button TOOL_RUBBER = new Button("Rubber");
            public static final Button TOOL_BRUSH = new Button("Brush");
            public static final Button TOOL_PENCIL = new Button("Pencil");
            public static final Button TOOL_AIRBRUSH = new Button("Airbrush");
            public static final Button TOOL_FINGER = new Button("Finger");
            public static final Button TOOL_MOUSE = new Button("Mouse");
            public static final Button TOOL_LENS = new Button("Lens");
            public static final Button TOUCH = new Button("Touch");
            public static final Button STYLUS = new Button("Stylus");
            public static final Button STYLUS2 = new Button("Stylus 2");
            public static final Button UNKNOWN = new Button("Unknown");
            public static final Button BACK = new Button("Back");
            public static final Button EXTRA = new Button("Extra");
            public static final Button FORWARD = new Button("Forward");
            public static final Button LEFT = new Button("Left");
            public static final Button MIDDLE = new Button("Middle");
            public static final Button RIGHT = new Button("Right");
            public static final Button SIDE = new Button("Side");

            public Button(String name) {
                super(name);
            }
        }

        public static class Key
        extends Identifier {
            private int keyID;
            public static final Key VOID = new Key("Void", 0);
            public static final Key ESCAPE = new Key("Escape", 1);
            public static final Key _1 = new Key("1", 2);
            public static final Key _2 = new Key("2", 3);
            public static final Key _3 = new Key("3", 4);
            public static final Key _4 = new Key("4", 5);
            public static final Key _5 = new Key("5", 6);
            public static final Key _6 = new Key("6", 7);
            public static final Key _7 = new Key("7", 8);
            public static final Key _8 = new Key("8", 9);
            public static final Key _9 = new Key("9", 10);
            public static final Key _0 = new Key("0", 11);
            public static final Key MINUS = new Key("-", 12);
            public static final Key EQUALS = new Key("=", 13);
            public static final Key BACK = new Key("Back", 14);
            public static final Key TAB = new Key("Tab", 15);
            public static final Key Q = new Key("Q", 16);
            public static final Key W = new Key("W", 17);
            public static final Key E = new Key("E", 18);
            public static final Key R = new Key("R", 19);
            public static final Key T = new Key("T", 20);
            public static final Key Y = new Key("Y", 21);
            public static final Key U = new Key("U", 22);
            public static final Key I = new Key("I", 23);
            public static final Key O = new Key("O", 24);
            public static final Key P = new Key("P", 25);
            public static final Key LBRACKET = new Key("[", 26);
            public static final Key RBRACKET = new Key("]", 27);
            public static final Key RETURN = new Key("Return", 28);
            public static final Key LCONTROL = new Key("Left Control", 29);
            public static final Key A = new Key("A", 30);
            public static final Key S = new Key("S", 31);
            public static final Key D = new Key("D", 32);
            public static final Key F = new Key("F", 33);
            public static final Key G = new Key("G", 34);
            public static final Key H = new Key("H", 35);
            public static final Key J = new Key("J", 36);
            public static final Key K = new Key("K", 37);
            public static final Key L = new Key("L", 38);
            public static final Key SEMICOLON = new Key(";", 39);
            public static final Key APOSTROPHE = new Key("'", 40);
            public static final Key GRAVE = new Key("~", 41);
            public static final Key LSHIFT = new Key("Left Shift", 42);
            public static final Key BACKSLASH = new Key("\\", 43);
            public static final Key Z = new Key("Z", 44);
            public static final Key X = new Key("X", 45);
            public static final Key C = new Key("C", 46);
            public static final Key V = new Key("V", 47);
            public static final Key B = new Key("B", 48);
            public static final Key N = new Key("N", 49);
            public static final Key M = new Key("M", 50);
            public static final Key COMMA = new Key(",", 51);
            public static final Key PERIOD = new Key(".", 52);
            public static final Key SLASH = new Key("/", 53);
            public static final Key RSHIFT = new Key("Right Shift", 54);
            public static final Key MULTIPLY = new Key("Multiply", 55);
            public static final Key LALT = new Key("Left Alt", 56);
            public static final Key SPACE = new Key(" ", 57);
            public static final Key CAPITAL = new Key("Caps Lock", 58);
            public static final Key F1 = new Key("F1", 59);
            public static final Key F2 = new Key("F2", 60);
            public static final Key F3 = new Key("F3", 61);
            public static final Key F4 = new Key("F4", 62);
            public static final Key F5 = new Key("F5", 63);
            public static final Key F6 = new Key("F6", 64);
            public static final Key F7 = new Key("F7", 65);
            public static final Key F8 = new Key("F8", 66);
            public static final Key F9 = new Key("F9", 67);
            public static final Key F10 = new Key("F10", 68);
            public static final Key NUMLOCK = new Key("Num Lock", 69);
            public static final Key SCROLL = new Key("Scroll Lock", 70);
            public static final Key NUMPAD7 = new Key("Num 7", 71);
            public static final Key NUMPAD8 = new Key("Num 8", 72);
            public static final Key NUMPAD9 = new Key("Num 9", 73);
            public static final Key SUBTRACT = new Key("Num -", 74);
            public static final Key NUMPAD4 = new Key("Num 4", 75);
            public static final Key NUMPAD5 = new Key("Num 5", 76);
            public static final Key NUMPAD6 = new Key("Num 6", 77);
            public static final Key ADD = new Key("Num +", 78);
            public static final Key NUMPAD1 = new Key("Num 1", 79);
            public static final Key NUMPAD2 = new Key("Num 2", 80);
            public static final Key NUMPAD3 = new Key("Num 3", 81);
            public static final Key NUMPAD0 = new Key("Num 0", 82);
            public static final Key DECIMAL = new Key("Num .", 83);
            public static final Key F11 = new Key("F11", 84);
            public static final Key F12 = new Key("F12", 85);
            public static final Key F13 = new Key("F13", 86);
            public static final Key F14 = new Key("F14", 87);
            public static final Key F15 = new Key("F15", 88);
            public static final Key KANA = new Key(89);
            public static final Key CONVERT = new Key(90);
            public static final Key NOCONVERT = new Key(91);
            public static final Key YEN = new Key(92);
            public static final Key NUMPADEQUAL = new Key("Num =", 93);
            public static final Key CIRCUMFLEX = new Key(94);
            public static final Key AT = new Key(95);
            public static final Key COLON = new Key(96);
            public static final Key UNDERLINE = new Key(97);
            public static final Key KANJI = new Key(98);
            public static final Key STOP = new Key(99);
            public static final Key AX = new Key(100);
            public static final Key UNLABELED = new Key(101);
            public static final Key NUMPADENTER = new Key("Num Enter", 102);
            public static final Key RCONTROL = new Key("Right Control", 103);
            public static final Key NUMPADCOMMA = new Key("Num ,", 104);
            public static final Key DIVIDE = new Key("Num /", 105);
            public static final Key SYSRQ = new Key(106);
            public static final Key RALT = new Key("Right Alt", 107);
            public static final Key PAUSE = new Key("Pause", 108);
            public static final Key HOME = new Key("Home", 109);
            public static final Key UP = new Key("Up", 110);
            public static final Key PAGEUP = new Key("Pg Up", 111);
            public static final Key LEFT = new Key("Left", 112);
            public static final Key RIGHT = new Key("Right", 113);
            public static final Key END = new Key("End", 114);
            public static final Key DOWN = new Key("Down", 115);
            public static final Key PAGEDOWN = new Key("Pg Down", 116);
            public static final Key INSERT = new Key("Insert", 117);
            public static final Key DELETE = new Key("Delete", 118);
            public static final Key LWIN = new Key("Left Windows", 119);
            public static final Key RWIN = new Key("Right Windows", 120);
            public static final Key APPS = new Key(121);
            public static final Key POWER = new Key("Power", 122);
            public static final Key SLEEP = new Key("Sleep", 123);
            public static final Key UNKNOWN = new Key("Unknown", 0);
            protected static final Key FIRST = VOID;
            protected static final Key LAST = SLEEP;

            protected Key(String name, int keyID) {
                super(name);
                this.keyID = keyID;
            }

            protected Key(int keyID) {
                this("Key " + keyID, keyID);
            }

            public int getKeyIndex() {
                return this.keyID;
            }
        }
    }

    public static class POV {
        public static final float OFF = 0.0f;
        public static final float CENTER = 0.0f;
        public static final float UP_LEFT = 0.125f;
        public static final float UP = 0.25f;
        public static final float UP_RIGHT = 0.375f;
        public static final float RIGHT = 0.5f;
        public static final float DOWN_RIGHT = 0.625f;
        public static final float DOWN = 0.75f;
        public static final float DOWN_LEFT = 0.875f;
        public static final float LEFT = 1.0f;
    }
}

