/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Rumbler;

public abstract class AbstractController
implements Controller {
    protected static final Component[] NO_COMPONENTS = new Component[0];
    protected static final Controller[] NO_CONTROLLERS = new Controller[0];
    protected static final Rumbler[] NO_RUMBLERS = new Rumbler[0];
    private final String name;
    protected Component[] components;
    protected Controller[] children;
    protected Rumbler[] rumblers;

    protected AbstractController(String name) {
        this(name, NO_COMPONENTS, NO_CONTROLLERS, NO_RUMBLERS);
    }

    protected AbstractController(String name, Component[] components, Controller[] children, Rumbler[] rumblers) {
        this.name = name;
        this.components = components;
        this.children = children;
        this.rumblers = rumblers;
    }

    public Controller[] getControllers() {
        return this.children;
    }

    public Component[] getComponents() {
        return this.components;
    }

    public Component getComponent(Component.Identifier id) {
        Component[] components = this.getComponents();
        if (components.length == 0) {
            return null;
        }
        int i = 0;
        while (i < components.length) {
            if (components[i].getIdentifier() == id) {
                return components[i];
            }
            ++i;
        }
        return null;
    }

    public Rumbler[] getRumblers() {
        return this.rumblers;
    }

    public Controller.PortType getPortType() {
        return Controller.PortType.UNKNOWN;
    }

    public int getPortNumber() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public Controller.Type getType() {
        return Controller.Type.UNKNOWN;
    }
}

