/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.w3c.dom.Element;

public class MoveCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private static final Vector3i temp = new Vector3i();
    private int deltax;
    private int deltay;
    private boolean relativex;
    private boolean relativey;
    private int duration;

    public boolean execute(Animated target, int tickRate) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick();
        if (currentTick == 0) {
            if (this.relativex) {
                target.getLocation(temp);
                if (this.relativey) {
                    temp.setX(temp.getX() + this.deltax);
                    temp.setY(temp.getY() + this.deltay);
                } else {
                    temp.setX(temp.getX() + this.deltax);
                    temp.setY(this.deltay);
                }
                target.setLocation(temp.getX(), temp.getY(), 0);
            } else if (this.relativey) {
                target.getLocation(temp);
                temp.setX(this.deltax);
                temp.setY(temp.getY() + this.deltay);
                target.setLocation(temp.getX(), temp.getY(), 0);
            } else {
                target.setLocation(this.deltax, this.deltay, 0);
            }
        }
        if (currentTick >= this.duration) {
            target.setSequence(++currentSequence);
            target.setTick(0);
            return true;
        }
        target.setTick(currentTick + tickRate);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        String sx = XMLUtil.getString(element, "x");
        if (sx.startsWith("+")) {
            this.relativex = true;
            this.deltax = Integer.parseInt(sx.substring(1));
        } else if (sx.startsWith("-")) {
            this.relativex = true;
            this.deltax = Integer.parseInt(sx);
        } else {
            this.deltax = Integer.parseInt(sx);
        }
        String sy = XMLUtil.getString(element, "y");
        if (sy.startsWith("+")) {
            this.relativey = true;
            this.deltay = Integer.parseInt(sy.substring(1));
        } else if (sy.startsWith("-")) {
            this.relativey = true;
            this.deltay = Integer.parseInt(sy);
        } else {
            this.deltay = Integer.parseInt(sy);
        }
        this.duration = XMLUtil.getInt(element, "d", 0);
    }

    protected void doCreate() throws Exception {
    }

    protected void doDestroy() {
    }
}

