/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.resources.ColorSequenceWrapper;
import com.shavenpuppy.jglib.resources.Feature;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.WritableColor;

public class ColorPulseResource
extends Feature
implements ColorSequenceWrapper {
    private static final long serialVersionUID = 1L;
    private float baseHue;
    private float pulseHue;
    private float saturation;
    private float brightness;
    private float frequency;
    private transient Color baseColor;
    private transient Color pulseColor;

    public ColorPulseResource(String name, float baseHue, float pulseHue, float saturation, float brightness, float frequency) {
        super(name);
        this.baseHue = baseHue;
        this.pulseHue = pulseHue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.frequency = frequency;
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.baseColor = new Color();
        this.pulseColor = new Color();
        this.baseColor.fromHSB(this.baseHue, this.saturation, this.brightness);
        this.pulseColor.fromHSB(this.pulseHue, this.saturation, this.brightness);
    }

    public Color getColor(int tick, Color dest) {
        if (dest == null) {
            dest = new Color();
        }
        float time = this.frequency * (float)tick;
        float ratio = ((float)Math.cos(time) + 1.0f) / 2.0f;
        ColorInterpolator.interpolate((ReadableColor)this.baseColor, (ReadableColor)this.pulseColor, ratio, (Interpolator)LinearInterpolator.instance, (WritableColor)dest);
        return dest;
    }
}

