/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.MultiBuffer;
import com.shavenpuppy.jglib.opengl.GL;
import com.shavenpuppy.jglib.opengl.GLRenderableObject;
import com.shavenpuppy.jglib.opengl.GLResource;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.util.vector.Vector3f;

public class GLNormalisationCubeMapTexture
extends GLResource
implements GLRenderableObject {
    public static final long serialVersionUID = 1L;
    private final int size;
    private transient int textureId;

    public GLNormalisationCubeMapTexture(int size) {
        this.size = size;
    }

    protected void doGLCreate() throws OpenGLException {
        GL.scratch.ints.clear().limit(1);
        GL11.glGenTextures((IntBuffer)GL.scratch.ints);
        this.textureId = GL.scratch.ints.get(0);
        GL11.glBindTexture((int)34067, (int)this.textureId);
        Vector3f vector = new Vector3f();
        MultiBuffer pixels = new MultiBuffer(this.size * this.size * 3);
        GL11.glTexParameteri((int)34067, (int)10242, (int)33071);
        GL11.glTexParameteri((int)34067, (int)10243, (int)33071);
        GL11.glTexParameteri((int)34067, (int)32882, (int)33071);
        GL11.glTexParameteri((int)34067, (int)10240, (int)9729);
        GL11.glTexParameteri((int)34067, (int)10241, (int)9729);
        int i = 0;
        while (i < 6) {
            pixels.bytes.clear();
            int y = 0;
            while (y < this.size) {
                int x = 0;
                while (x < this.size) {
                    GLNormalisationCubeMapTexture.getCubeVector(i, this.size, x, y, vector);
                    pixels.bytes.put((byte)(127.0f * vector.x + 128.0f));
                    pixels.bytes.put((byte)(127.0f * vector.y + 128.0f));
                    pixels.bytes.put((byte)(127.0f * vector.z + 128.0f));
                    ++x;
                }
                ++y;
            }
            pixels.bytes.flip();
            GL11.glTexImage2D((int)(34069 + i), (int)0, (int)32856, (int)this.size, (int)this.size, (int)0, (int)6407, (int)5121, (ByteBuffer)pixels.bytes);
            ++i;
        }
    }

    protected void doGLDestroy() throws OpenGLException {
        GL.scratch.ints.clear().limit(1);
        GL.scratch.ints.put(0, this.textureId);
        GL11.glDeleteTextures((IntBuffer)GL.scratch.ints);
    }

    private static void getCubeVector(int i, int cubesize, int x, int y, Vector3f vector) {
        float s = ((float)x + 0.5f) / (float)cubesize;
        float t = ((float)y + 0.5f) / (float)cubesize;
        float sc = s * 2.0f - 1.0f;
        float tc = t * 2.0f - 1.0f;
        switch (i) {
            case 0: {
                vector.x = 1.0f;
                vector.y = -tc;
                vector.z = -sc;
                break;
            }
            case 1: {
                vector.x = -1.0f;
                vector.y = -tc;
                vector.z = sc;
                break;
            }
            case 2: {
                vector.x = sc;
                vector.y = 1.0f;
                vector.z = tc;
                break;
            }
            case 3: {
                vector.x = sc;
                vector.y = -1.0f;
                vector.z = -tc;
                break;
            }
            case 4: {
                vector.x = sc;
                vector.y = -tc;
                vector.z = 1.0f;
                break;
            }
            case 5: {
                vector.x = -sc;
                vector.y = -tc;
                vector.z = -1.0f;
            }
        }
        float mag = (float)(1.0 / Math.sqrt(vector.x * vector.x + vector.y * vector.y + vector.z * vector.z));
        vector.x *= mag;
        vector.y *= mag;
        vector.z *= mag;
    }

    public void render() throws OpenGLException {
        GL11.glBindTexture((int)34067, (int)this.textureId);
    }

    public int getID() {
        return this.textureId;
    }
}

