/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.openal;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.AL;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.openal.ALResource;
import com.shavenpuppy.jglib.openal.ALSource;
import com.shavenpuppy.jglib.openal.ALStream;
import com.shavenpuppy.jglib.resources.WaveWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public class ALStreamInstance
extends ALResource {
    private static final int BUFSIZE = 8192;
    private static final int BUFFERS = 4;
    private static int num;
    private transient ALStream sourceStream;
    private final String url;
    private transient ALBuffer[] buffers;
    private transient int writeBuf;
    private transient InputStream inputStream;
    private transient byte[] buf;
    private transient ByteBuffer byteBuf;
    private transient int pos;
    private transient int type;
    private transient int frequency;
    private transient int format;
    private transient int numQueued;
    private transient boolean waitForQueue;
    private transient boolean playing;
    private transient boolean startPlaying;
    private transient boolean looped;
    private ALSource owner;

    ALStreamInstance(ALStream sourceStream) {
        super("StreamInstance " + num++ + " [" + sourceStream + "]");
        this.sourceStream = sourceStream;
        this.url = sourceStream.getURL();
        this.looped = sourceStream.isLooped();
    }

    public ALStream getSourceStream() {
        return this.sourceStream;
    }

    void setOwner(ALSource newOwner) {
        this.owner = newOwner;
    }

    public ALSource getOwner() {
        return this.owner;
    }

    public int getType() {
        return this.type;
    }

    protected void doALCreate() throws Exception {
        if (!org.lwjgl.openal.AL.isCreated()) {
            return;
        }
        this.buffers = new ALBuffer[4];
        int i = 0;
        while (i < this.buffers.length) {
            this.buffers[i] = new ALBuffer("StreamBuffer " + i + "[" + this + "]");
            this.buffers[i].create();
            ++i;
        }
        this.buf = new byte[8192];
        this.byteBuf = BufferUtils.createByteBuffer((int)8192);
        this.initStream();
    }

    private void initStream() throws Exception {
        if (this.url != null && this.url.startsWith("resource:")) {
            WaveWrapper waveResource = (WaveWrapper)((Object)Resources.get(this.url.substring(9)));
            this.inputStream = waveResource.getStream();
            this.type = waveResource.getType();
            this.frequency = waveResource.getFrequency();
        }
        if (this.inputStream == null) {
            throw new Exception("No input stream specified for " + this);
        }
        this.format = AL.translateFormat(this.type);
    }

    protected void doALDestroy() {
        System.out.println("DESTROYED " + this);
        if (this.buffers != null) {
            int i = 0;
            while (i < this.buffers.length) {
                this.buffers[i].destroy();
                ++i;
            }
            this.buffers = null;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            this.inputStream = null;
        }
        this.buf = null;
        this.byteBuf = null;
    }

    public synchronized boolean isPlaying() {
        return this.playing;
    }

    public synchronized void setPlaying(boolean playing) {
        if (this.playing == playing) {
            return;
        }
        this.playing = playing;
        if (!playing) {
            int queued;
            this.numQueued = 0;
            this.waitForQueue = false;
            this.writeBuf = 0;
            this.owner.stop();
            do {
                if ((queued = AL10.alGetSourcei((int)this.owner.getSourceID(), (int)4117)) <= 0) continue;
                this.owner.dequeue();
            } while (queued > 0);
            do {
                int processed;
                if ((processed = AL10.alGetSourcei((int)this.owner.getSourceID(), (int)4118)) <= 0) continue;
                AL.scratch.ints.clear();
                AL.scratch.ints.limit(1);
                AL10.alSourceUnqueueBuffers((int)this.owner.getSourceID(), (IntBuffer)AL.scratch.ints);
            } while (queued > 0);
        } else {
            this.startPlaying = true;
        }
    }

    public synchronized void tick() throws Exception {
        if (!this.buffers[this.writeBuf].isCreated()) {
            Thread.yield();
            return;
        }
        if (!this.isPlaying()) {
            return;
        }
        if (this.waitForQueue) {
            if (!this.isPlaying()) {
                return;
            }
            int processed = AL10.alGetSourcei((int)this.owner.getSourceID(), (int)4118);
            if (processed == 0) {
                return;
            }
            int i = 0;
            while (i < processed) {
                this.owner.dequeue();
                ++i;
            }
            this.numQueued -= processed;
            this.waitForQueue = false;
            return;
        }
        int read = this.inputStream.read(this.buf, this.pos, this.buf.length - this.pos);
        if (read == -1) {
            if (this.looped) {
                this.initStream();
                this.tick();
            } else if (this.numQueued == 0) {
                this.setPlaying(false);
            }
        } else {
            this.pos += read;
            if (this.pos == this.buf.length) {
                this.pos = 0;
                this.byteBuf.put(this.buf);
                this.byteBuf.flip();
                ALBuffer bufToQueue = this.buffers[this.writeBuf++];
                if (this.writeBuf == this.buffers.length) {
                    this.writeBuf = 0;
                }
                ++this.numQueued;
                if (this.numQueued == this.buffers.length) {
                    this.waitForQueue = true;
                }
                if (this.startPlaying) {
                    this.owner.unattach();
                    this.startPlaying = false;
                }
                AL10.alBufferData((int)bufToQueue.getBufferID(), (int)this.format, (ByteBuffer)this.byteBuf, (int)this.frequency);
                this.owner.queue(bufToQueue);
                if (this.owner.getInt(4112) != 4114) {
                    this.owner.play();
                }
            }
        }
    }
}

