/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.resources.WaveWrapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class Wave
implements Serializable,
WaveWrapper {
    static final long serialVersionUID = 4L;
    private transient ByteBuffer data;
    private transient int samples;
    private transient int type;
    private transient int freq;
    public static final int MONO_8BIT = 0;
    public static final int MONO_16BIT = 1;
    public static final int STEREO_8BIT = 2;
    public static final int STEREO_16BIT = 3;
    private static final int[] typeToSize;
    private static final int MAGIC = 45071;
    private static final int VERSION = 1;
    private transient int numRead;
    private transient int numDisposed;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.Wave");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        typeToSize = new int[]{1, 2, 2, 4};
    }

    public Wave() {
    }

    public void dispose() {
        this.data = null;
    }

    public Wave(int samples, int type, int freq) {
        this.samples = samples;
        this.freq = freq;
        this.type = type;
        this.data = ByteBuffer.allocateDirect(samples * typeToSize[type]).order(ByteOrder.nativeOrder());
    }

    public Wave(int samples, int type, int freq, byte[] wave) {
        this.samples = samples;
        this.freq = freq;
        this.type = type;
        if (!$assertionsDisabled && samples * typeToSize[type] != wave.length) {
            throw new AssertionError((Object)"Wave is incorrect size.");
        }
        this.data = ByteBuffer.allocateDirect(wave.length).order(ByteOrder.nativeOrder());
        this.data.put(wave);
    }

    public Wave(int samples, int type, int freq, ByteBuffer waveData) {
        this.samples = samples;
        this.freq = freq;
        this.type = type;
        if (!$assertionsDisabled && samples * typeToSize[type] > waveData.remaining()) {
            throw new AssertionError((Object)("Wave is incorrect size: " + waveData.capacity() + " vs. " + samples * typeToSize[type]));
        }
        this.data = waveData;
    }

    public static Wave read(InputStream is) throws Exception {
        Wave ret = new Wave();
        ret = (Wave)new ObjectInputStream(is).readObject();
        return ret;
    }

    public static void write(Wave wave, OutputStream os) throws Exception {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(wave);
        oos.flush();
        oos.reset();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        this.writeHeader(stream);
        byte[] buf = new byte[this.data.limit()];
        this.data.rewind();
        this.data.get(buf);
        this.data.rewind();
        stream.writeInt(buf.length);
        stream.write(buf);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.readHeader(stream);
        int length = stream.readInt();
        byte[] buf = new byte[length];
        stream.readFully(buf);
        this.data = ByteBuffer.allocateDirect(length).order(ByteOrder.nativeOrder());
        this.data.put(buf);
        this.data.rewind();
    }

    public void readHeader(DataInput is) throws IOException {
        this.samples = is.readInt();
        this.type = is.readInt();
        this.freq = is.readInt();
    }

    public void writeHeader(DataOutput os) throws IOException {
        os.writeInt(this.samples);
        os.writeInt(this.type);
        os.writeInt(this.freq);
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getSamples() {
        return this.samples;
    }

    public int getType() {
        return this.type;
    }

    public static int getBytesPerSample(int type) {
        return typeToSize[type];
    }

    public int getFrequency() {
        return this.freq;
    }

    public String toString() {
        return "Wave[" + this.samples + " samples, type=" + this.type + "]";
    }

    public Wave getWave() {
        return this;
    }

    public InputStream getStream() throws Exception {
        return null;
    }

    public void setData(byte[] newData) {
        this.data.put(newData);
        this.data.rewind();
    }
}

