/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.Resource;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;

public class Memory
extends Resource {
    public static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private static final HashMap allocatorMap;
    private String allocatorName;
    private int length;
    private AllocationHandler.Entry entry;
    private ByteBuffer buffer;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.Memory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        allocatorMap = new HashMap();
    }

    public Memory(String allocatorName, int length) {
        super("Memory allocation (" + length + " bytes)");
        this.allocatorName = allocatorName;
        this.length = length;
    }

    public static synchronized void init(String name, ByteBuffer allocator) {
        AllocationHandler ah = new AllocationHandler(allocator);
        allocatorMap.put(name, ah);
    }

    protected final synchronized void doCreate() {
        AllocationHandler handler = (AllocationHandler)allocatorMap.get(this.allocatorName);
        this.length = Math.max(32, this.length);
        this.entry = handler.allocate(this.length);
        if (this.entry == null) {
            throw new RuntimeException("Couldn't allocate " + this.length + " bytes from " + this.allocatorName);
        }
        this.buffer = this.entry.createBuffer();
    }

    protected void doDestroy() {
        this.entry.merge();
        this.entry = null;
        this.buffer = null;
    }

    public final ByteBuffer getBuffer() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError();
        }
        return this.buffer;
    }

    public static synchronized void cleanup(String name) {
        allocatorMap.remove(name);
    }

    public static ByteBuffer chop(ByteBuffer src, int byteOffset, int length) {
        ByteBuffer ret = src.duplicate();
        ret.clear().position(byteOffset).limit(byteOffset + length);
        ret = ret.slice();
        ret.order(ByteOrder.nativeOrder());
        return ret;
    }

    public static ByteBuffer chop(ByteBuffer src, int byteOffset) {
        ByteBuffer ret = src.duplicate();
        ret.clear().position(byteOffset);
        ret = ret.slice();
        ret.order(ByteOrder.nativeOrder());
        return ret;
    }

    private static class AllocationHandler {
        final ByteBuffer allocator;
        final Entry entry;

        AllocationHandler(ByteBuffer allocator) {
            this.allocator = allocator;
            this.entry = new Entry();
            this.entry.length = allocator.capacity();
        }

        Entry allocate(int size) {
            Entry e = this.entry;
            while (e != null) {
                if (e.allocated || e.length < size) {
                    e = e.next;
                    continue;
                }
                e.split(size);
                return e;
            }
            return null;
        }

        class Entry {
            int position;
            int length;
            boolean allocated;
            Entry next;
            Entry prev;
            static final /* synthetic */ boolean $assertionsDisabled;
            static /* synthetic */ Class class$0;

            static {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.shavenpuppy.jglib.Memory$AllocationHandler$Entry");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                $assertionsDisabled = !clazz.desiredAssertionStatus();
            }

            Entry() {
            }

            void merge() {
                if (!$assertionsDisabled && !this.allocated) {
                    throw new AssertionError();
                }
                this.allocated = false;
                Entry current = this;
                while (current.prev != null && !current.prev.allocated) {
                    current = current.prev;
                }
                while (current.next != null && !current.next.allocated) {
                    current.length += current.next.length;
                    current.next = current.next.next;
                }
                if (current.next != null) {
                    current.next.prev = current;
                }
            }

            void split(int size) {
                if (!$assertionsDisabled && this.allocated) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && size > this.length) {
                    throw new AssertionError();
                }
                this.allocated = true;
                if (size == this.length) {
                    return;
                }
                Entry newEntry = new Entry();
                newEntry.prev = this;
                newEntry.next = this.next;
                newEntry.position = this.position + size;
                newEntry.length = this.length - size;
                this.length = size;
                this.next = newEntry;
            }

            ByteBuffer createBuffer() {
                ByteBuffer dup = AllocationHandler.this.allocator.duplicate();
                dup.clear().limit(this.position + this.length);
                dup.position(this.position);
                return dup.slice().order(ByteOrder.nativeOrder());
            }
        }
    }
}

