/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALCcontext;
import org.lwjgl.openal.ALCdevice;
import org.lwjgl.openal.Util;

public final class ALC {
    public static final int ALC_INVALID = -1;
    public static final int ALC_FALSE = 0;
    public static final int ALC_TRUE = 1;
    public static final int ALC_NO_ERROR = 0;
    public static final int ALC_MAJOR_VERSION = 4096;
    public static final int ALC_MINOR_VERSION = 4097;
    public static final int ALC_ATTRIBUTES_SIZE = 4098;
    public static final int ALC_ALL_ATTRIBUTES = 4099;
    public static final int ALC_DEFAULT_DEVICE_SPECIFIER = 4100;
    public static final int ALC_DEVICE_SPECIFIER = 4101;
    public static final int ALC_EXTENSIONS = 4102;
    public static final int ALC_FREQUENCY = 4103;
    public static final int ALC_REFRESH = 4104;
    public static final int ALC_SYNC = 4105;
    public static final int ALC_INVALID_DEVICE = 40961;
    public static final int ALC_INVALID_CONTEXT = 40962;
    public static final int ALC_INVALID_ENUM = 40963;
    public static final int ALC_INVALID_VALUE = 40964;
    public static final int ALC_OUT_OF_MEMORY = 40965;

    static {
        Sys.initialize();
    }

    private ALC() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static String alcGetString(int pname) {
        String result = ALC.nalcGetString(AL.device.device, pname);
        Util.checkALCError();
        return result;
    }

    private static native String nalcGetString(long var0, int var2);

    public static void alcGetInteger(int pname, IntBuffer integerdata) {
        BufferChecks.checkDirect(integerdata);
        ALC.nalcGetIntegerv(AL.device.device, pname, integerdata.remaining(), integerdata, integerdata.position());
        Util.checkALCError();
    }

    private static native void nalcGetIntegerv(long var0, int var2, int var3, Buffer var4, int var5);

    static native ALCdevice alcOpenDevice(String var0);

    static native void alcCloseDevice(long var0);

    static ALCcontext alcCreateContext(long device, IntBuffer attrList) {
        ALCcontext result = ALC.nalcCreateContext(device, attrList);
        Util.checkALCError();
        return result;
    }

    private static native ALCcontext nalcCreateContext(long var0, IntBuffer var2);

    static native int alcMakeContextCurrent(long var0);

    public static void alcProcessContext() {
        ALC.nalcProcessContext(AL.context.context);
    }

    private static native void nalcProcessContext(long var0);

    static native ALCcontext alcGetCurrentContext();

    static native ALCdevice alcGetContextsDevice(long var0);

    public static void alcSuspendContext() {
        ALC.nalcSuspendContext(AL.context.context);
    }

    private static native void nalcSuspendContext(long var0);

    static native void alcDestroyContext(long var0);

    public static int alcGetError() {
        return ALC.nalcGetError(AL.device.device);
    }

    private static native int nalcGetError(long var0);

    public static boolean alcIsExtensionPresent(String extName) {
        boolean result = ALC.nalcIsExtensionPresent(AL.device.device, extName);
        Util.checkALCError();
        return result;
    }

    private static native boolean nalcIsExtensionPresent(long var0, String var2);

    public static int alcGetEnumValue(String enumName) {
        int result = ALC.nalcGetEnumValue(AL.device.device, enumName);
        Util.checkALCError();
        return result;
    }

    private static native int nalcGetEnumValue(long var0, String var2);
}

