/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCcontext;
import org.lwjgl.openal.ALCdevice;

public final class AL {
    protected static ALCdevice device;
    protected static ALCcontext context;
    private static boolean created;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Sys.initialize();
    }

    private AL() {
    }

    private static native void nCreate(String var0) throws LWJGLException;

    private static native void nCreateDefault() throws LWJGLException;

    private static native void nDestroy();

    public static boolean isCreated() {
        return created;
    }

    public static void create(String deviceArguments, int contextFrequency, int contextRefresh, boolean contextSynchronized) throws LWJGLException {
        if (created) {
            throw new IllegalStateException("Only one OpenAL context may be instantiated at any one time.");
        }
        String[] stringArray = new String[]{"OpenAL32", "OpenAL32.dll", "openal", "libopenal.so", "openal", "openal.dylib"};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lwjgl.openal.AL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String[] oalPaths = LWJGLUtil.getLibraryPaths(stringArray, clazz.getClassLoader());
        LWJGLUtil.log("Found " + oalPaths.length + " OpenAL paths");
        int i = 0;
        while (i < oalPaths.length) {
            try {
                AL.nCreate(oalPaths[i]);
                created = true;
                break;
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Failed to load " + oalPaths[i] + ": " + e.getMessage());
                ++i;
            }
        }
        if (!created && LWJGLUtil.getPlatform() == 2) {
            AL.nCreateDefault();
            created = true;
        }
        if (!created) {
            throw new LWJGLException("Could not locate OpenAL library.");
        }
        try {
            AL10.initNativeStubs();
            ALC.initNativeStubs();
            device = ALC.alcOpenDevice(deviceArguments);
            if (device == null) {
                throw new LWJGLException("Could not open ALC device");
            }
            context = contextFrequency == -1 ? ALC.alcCreateContext(AL.device.device, null) : ALC.alcCreateContext(AL.device.device, ALCcontext.createAttributeList(contextFrequency, contextRefresh, contextSynchronized ? 1 : 0));
            ALC.alcMakeContextCurrent(AL.context.context);
        }
        catch (LWJGLException e) {
            AL.destroy();
            throw e;
        }
    }

    public static void create() throws LWJGLException {
        AL.create(null, 44100, 60, false);
    }

    public static void destroy() {
        Class<?> clazz;
        if (context != null) {
            ALC.alcDestroyContext(AL.context.context);
            context = null;
        }
        if (device != null) {
            ALC.alcCloseDevice(AL.device.device);
            device = null;
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.lwjgl.openal.AL10");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AL.resetNativeStubs(clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.lwjgl.openal.ALC");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AL.resetNativeStubs(clazz2);
        if (created) {
            AL.nDestroy();
        }
        created = false;
    }

    private static native void resetNativeStubs(Class var0);

    public static Object getContext() {
        return context;
    }
}

