/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.SysImplementation;
import org.lwjgl.input.Mouse;

public final class Sys {
    private static final String VERSION = "0.99";
    private static final SysImplementation implementation = Sys.createImplementation();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        String[] library_names = implementation.getNativeLibraryNames();
        UnsatisfiedLinkError last_load_error = null;
        int i = 0;
        while (i < library_names.length) {
            try {
                Sys.loadLibrary(library_names[i]);
                last_load_error = null;
                break;
            }
            catch (UnsatisfiedLinkError e) {
                last_load_error = e;
                ++i;
            }
        }
        if (last_load_error != null) {
            throw last_load_error;
        }
        String native_version = implementation.getNativeLibraryVersion();
        if (!native_version.equals(Sys.getVersion())) {
            throw new LinkageError("Version mismatch: jar version is '" + Sys.getVersion() + "', native libary version is '" + native_version + "'");
        }
        implementation.setDebug(LWJGLUtil.DEBUG);
    }

    private static void loadLibrary(final String name) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary(name);
                return null;
            }
        });
    }

    private static SysImplementation createImplementation() {
        String class_name;
        switch (LWJGLUtil.getPlatform()) {
            case 1: {
                class_name = "org.lwjgl.LinuxSysImplementation";
                break;
            }
            case 3: {
                class_name = "org.lwjgl.Win32SysImplementation";
                break;
            }
            case 2: {
                class_name = "org.lwjgl.MacOSXSysImplementation";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported platform");
            }
        }
        try {
            Class<?> impl_class = Class.forName(class_name);
            return (SysImplementation)impl_class.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Sys() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static void initialize() {
    }

    public static long getTimerResolution() {
        return implementation.getTimerResolution();
    }

    public static long getTime() {
        return implementation.getTime() & Long.MAX_VALUE;
    }

    public static void alert(String title, String message) {
        boolean grabbed = Mouse.isGrabbed();
        if (grabbed) {
            Mouse.setGrabbed(false);
        }
        if (title == null) {
            title = "";
        }
        if (message == null) {
            message = "";
        }
        implementation.alert(title, message);
        if (grabbed) {
            Mouse.setGrabbed(true);
        }
    }

    public static boolean openURL(String url) {
        try {
            final Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    return serviceManagerClass.getMethod("lookup", classArray);
                }
            });
            Object basicService = lookupMethod.invoke(serviceManagerClass, "javax.jnlp.BasicService");
            final Class<?> basicServiceClass = Class.forName("javax.jnlp.BasicService");
            Method showDocumentMethod = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.net.URL");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    return basicServiceClass.getMethod("showDocument", classArray);
                }
            });
            try {
                Boolean ret = (Boolean)showDocumentMethod.invoke(basicService, new URL(url));
                return ret;
            }
            catch (MalformedURLException e) {
                e.printStackTrace(System.err);
                return false;
            }
        }
        catch (Exception ue) {
            return implementation.openURL(url);
        }
    }

    public static String getClipboard() {
        return implementation.getClipboard();
    }
}

