/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vector;

import java.io.Serializable;
import java.nio.FloatBuffer;
import org.lwjgl.util.vector.Matrix;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class Matrix4f
extends Matrix
implements Serializable {
    public float m00 = 1.0f;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11 = 1.0f;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22 = 1.0f;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33 = 1.0f;

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m00).append(' ').append(this.m10).append(' ').append(this.m20).append(' ').append(this.m30).append('\n');
        buf.append(this.m01).append(' ').append(this.m11).append(' ').append(this.m21).append(' ').append(this.m31).append('\n');
        buf.append(this.m02).append(' ').append(this.m12).append(' ').append(this.m22).append(' ').append(this.m32).append('\n');
        buf.append(this.m03).append(' ').append(this.m13).append(' ').append(this.m23).append(' ').append(this.m33).append('\n');
        return buf.toString();
    }

    public Matrix setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        return this;
    }

    public Matrix setZero() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 0.0f;
        return this;
    }

    public Matrix4f load(Matrix4f src) {
        this.m00 = src.m00;
        this.m01 = src.m01;
        this.m02 = src.m02;
        this.m03 = src.m03;
        this.m10 = src.m10;
        this.m11 = src.m11;
        this.m12 = src.m12;
        this.m13 = src.m13;
        this.m20 = src.m20;
        this.m21 = src.m21;
        this.m22 = src.m22;
        this.m23 = src.m23;
        this.m30 = src.m30;
        this.m31 = src.m31;
        this.m32 = src.m32;
        this.m33 = src.m33;
        return this;
    }

    public Matrix load(FloatBuffer buf) {
        this.m00 = buf.get();
        this.m01 = buf.get();
        this.m02 = buf.get();
        this.m03 = buf.get();
        this.m10 = buf.get();
        this.m11 = buf.get();
        this.m12 = buf.get();
        this.m13 = buf.get();
        this.m20 = buf.get();
        this.m21 = buf.get();
        this.m22 = buf.get();
        this.m23 = buf.get();
        this.m30 = buf.get();
        this.m31 = buf.get();
        this.m32 = buf.get();
        this.m33 = buf.get();
        return this;
    }

    public Matrix loadTranspose(FloatBuffer buf) {
        this.m00 = buf.get();
        this.m10 = buf.get();
        this.m20 = buf.get();
        this.m30 = buf.get();
        this.m01 = buf.get();
        this.m11 = buf.get();
        this.m21 = buf.get();
        this.m31 = buf.get();
        this.m02 = buf.get();
        this.m12 = buf.get();
        this.m22 = buf.get();
        this.m32 = buf.get();
        this.m03 = buf.get();
        this.m13 = buf.get();
        this.m23 = buf.get();
        this.m33 = buf.get();
        return this;
    }

    public Matrix store(FloatBuffer buf) {
        buf.put(this.m00);
        buf.put(this.m01);
        buf.put(this.m02);
        buf.put(this.m03);
        buf.put(this.m10);
        buf.put(this.m11);
        buf.put(this.m12);
        buf.put(this.m13);
        buf.put(this.m20);
        buf.put(this.m21);
        buf.put(this.m22);
        buf.put(this.m23);
        buf.put(this.m30);
        buf.put(this.m31);
        buf.put(this.m32);
        buf.put(this.m33);
        return this;
    }

    public Matrix storeTranspose(FloatBuffer buf) {
        buf.put(this.m00);
        buf.put(this.m10);
        buf.put(this.m20);
        buf.put(this.m30);
        buf.put(this.m01);
        buf.put(this.m11);
        buf.put(this.m21);
        buf.put(this.m31);
        buf.put(this.m02);
        buf.put(this.m12);
        buf.put(this.m22);
        buf.put(this.m32);
        buf.put(this.m03);
        buf.put(this.m13);
        buf.put(this.m23);
        buf.put(this.m33);
        return this;
    }

    public static Matrix4f add(Matrix4f left, Matrix4f right, Matrix4f dest) {
        Matrix4f temp = null;
        if (dest == null) {
            dest = new Matrix4f();
        } else if (dest == left || dest == right) {
            temp = dest;
            dest = new Matrix4f();
        }
        dest.m00 = left.m00 + right.m00;
        dest.m01 = left.m01 + right.m01;
        dest.m02 = left.m02 + right.m02;
        dest.m03 = left.m03 + right.m03;
        dest.m10 = left.m10 + right.m10;
        dest.m11 = left.m11 + right.m11;
        dest.m12 = left.m12 + right.m12;
        dest.m13 = left.m13 + right.m13;
        dest.m20 = left.m20 + right.m20;
        dest.m21 = left.m21 + right.m21;
        dest.m22 = left.m22 + right.m22;
        dest.m23 = left.m23 + right.m23;
        dest.m30 = left.m30 + right.m30;
        dest.m31 = left.m31 + right.m31;
        dest.m32 = left.m32 + right.m32;
        dest.m33 = left.m33 + right.m33;
        if (temp != null) {
            temp.load(dest);
            return temp;
        }
        return dest;
    }

    public static Matrix4f sub(Matrix4f left, Matrix4f right, Matrix4f dest) {
        Matrix4f temp = null;
        if (dest == null) {
            dest = new Matrix4f();
        } else if (dest == left || dest == right) {
            temp = dest;
            dest = new Matrix4f();
        }
        dest.m00 = left.m00 - right.m00;
        dest.m01 = left.m01 - right.m01;
        dest.m02 = left.m02 - right.m02;
        dest.m03 = left.m03 - right.m03;
        dest.m10 = left.m10 - right.m10;
        dest.m11 = left.m11 - right.m11;
        dest.m12 = left.m12 - right.m12;
        dest.m13 = left.m13 - right.m13;
        dest.m20 = left.m20 - right.m20;
        dest.m21 = left.m21 - right.m21;
        dest.m22 = left.m22 - right.m22;
        dest.m23 = left.m23 - right.m23;
        dest.m30 = left.m30 - right.m30;
        dest.m31 = left.m31 - right.m31;
        dest.m32 = left.m32 - right.m32;
        dest.m33 = left.m33 - right.m33;
        if (temp != null) {
            temp.load(dest);
            return temp;
        }
        return dest;
    }

    public static Matrix4f mul(Matrix4f left, Matrix4f right, Matrix4f dest) {
        Matrix4f temp = null;
        if (dest == null) {
            dest = new Matrix4f();
        } else if (dest == left || dest == right) {
            temp = dest;
            dest = new Matrix4f();
        }
        dest.m00 = left.m00 * right.m00 + left.m10 * right.m01 + left.m20 * right.m02 + left.m30 * right.m03;
        dest.m01 = left.m01 * right.m00 + left.m11 * right.m01 + left.m21 * right.m02 + left.m31 * right.m03;
        dest.m02 = left.m02 * right.m00 + left.m12 * right.m01 + left.m22 * right.m02 + left.m32 * right.m03;
        dest.m03 = left.m03 * right.m00 + left.m13 * right.m01 + left.m23 * right.m02 + left.m33 * right.m03;
        dest.m10 = left.m00 * right.m10 + left.m10 * right.m11 + left.m20 * right.m12 + left.m30 * right.m13;
        dest.m11 = left.m01 * right.m10 + left.m11 * right.m11 + left.m21 * right.m12 + left.m31 * right.m13;
        dest.m12 = left.m02 * right.m10 + left.m12 * right.m11 + left.m22 * right.m12 + left.m32 * right.m13;
        dest.m13 = left.m03 * right.m10 + left.m13 * right.m11 + left.m23 * right.m12 + left.m33 * right.m13;
        dest.m20 = left.m00 * right.m20 + left.m10 * right.m21 + left.m20 * right.m22 + left.m30 * right.m23;
        dest.m21 = left.m01 * right.m20 + left.m11 * right.m21 + left.m21 * right.m22 + left.m31 * right.m23;
        dest.m22 = left.m02 * right.m20 + left.m12 * right.m21 + left.m22 * right.m22 + left.m32 * right.m23;
        dest.m23 = left.m03 * right.m20 + left.m13 * right.m21 + left.m23 * right.m22 + left.m33 * right.m23;
        dest.m30 = left.m00 * right.m30 + left.m10 * right.m31 + left.m20 * right.m32 + left.m30 * right.m33;
        dest.m31 = left.m01 * right.m30 + left.m11 * right.m31 + left.m21 * right.m32 + left.m31 * right.m33;
        dest.m32 = left.m02 * right.m30 + left.m12 * right.m31 + left.m22 * right.m32 + left.m32 * right.m33;
        dest.m33 = left.m03 * right.m30 + left.m13 * right.m31 + left.m23 * right.m32 + left.m33 * right.m33;
        if (temp != null) {
            temp.load(dest);
            return temp;
        }
        return dest;
    }

    public static Vector4f transform(Matrix4f left, Vector4f right, Vector4f dest) {
        Vector4f temp = null;
        if (dest == null) {
            dest = new Vector4f();
        } else if (dest == right) {
            temp = dest;
            dest = new Vector4f();
        }
        dest.x = left.m00 * right.x + left.m10 * right.y + left.m20 * right.z + left.m30 * right.w;
        dest.y = left.m01 * right.x + left.m11 * right.y + left.m21 * right.z + left.m31 * right.w;
        dest.z = left.m02 * right.x + left.m12 * right.y + left.m22 * right.z + left.m32 * right.w;
        dest.w = left.m03 * right.x + left.m13 * right.y + left.m23 * right.z + left.m33 * right.w;
        if (temp != null) {
            temp.set(dest);
            return temp;
        }
        return dest;
    }

    public Matrix transpose() {
        float f = this.m10;
        this.m10 = this.m01;
        this.m01 = f;
        f = this.m20;
        this.m20 = this.m02;
        this.m02 = f;
        f = this.m30;
        this.m30 = this.m03;
        this.m03 = f;
        f = this.m21;
        this.m21 = this.m12;
        this.m12 = f;
        f = this.m31;
        this.m31 = this.m13;
        this.m13 = f;
        f = this.m32;
        this.m32 = this.m23;
        this.m23 = f;
        return this;
    }

    public Matrix4f translate(Vector2f vec) {
        this.m30 += this.m00 * vec.x + this.m10 * vec.y;
        this.m31 += this.m01 * vec.x + this.m11 * vec.y;
        this.m32 += this.m02 * vec.x + this.m12 * vec.y;
        this.m33 += this.m03 * vec.x + this.m13 * vec.y;
        return this;
    }

    public Matrix4f translate(Vector3f vec) {
        this.m30 += this.m00 * vec.x + this.m10 * vec.y + this.m20 * vec.z;
        this.m31 += this.m01 * vec.x + this.m11 * vec.y + this.m21 * vec.z;
        this.m32 += this.m02 * vec.x + this.m12 * vec.y + this.m22 * vec.z;
        this.m33 += this.m03 * vec.x + this.m13 * vec.y + this.m23 * vec.z;
        return this;
    }

    public Matrix4f scale(Vector3f vec) {
        this.m00 *= vec.x;
        this.m01 *= vec.x;
        this.m02 *= vec.x;
        this.m03 *= vec.x;
        this.m10 *= vec.y;
        this.m11 *= vec.y;
        this.m12 *= vec.y;
        this.m13 *= vec.y;
        this.m20 *= vec.z;
        this.m21 *= vec.z;
        this.m22 *= vec.z;
        this.m23 *= vec.z;
        return this;
    }

    public Matrix4f rotate(float angle, Vector3f axis) {
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        float oneminusc = 1.0f - c;
        float xy = axis.x * axis.y;
        float yz = axis.y * axis.z;
        float xz = axis.x * axis.z;
        float xs = axis.x * s;
        float ys = axis.y * s;
        float zs = axis.z * s;
        float f00 = axis.x * axis.x * oneminusc + c;
        float f01 = xy * oneminusc + zs;
        float f02 = xz * oneminusc - ys;
        float f10 = xy * oneminusc - zs;
        float f11 = axis.y * axis.y * oneminusc + c;
        float f12 = yz * oneminusc + xs;
        float f20 = xz * oneminusc + ys;
        float f21 = yz * oneminusc - xs;
        float f22 = axis.z * axis.z * oneminusc + c;
        float t00 = this.m00 * f00 + this.m10 * f01 + this.m20 * f02;
        float t01 = this.m01 * f00 + this.m11 * f01 + this.m21 * f02;
        float t02 = this.m02 * f00 + this.m12 * f01 + this.m22 * f02;
        float t03 = this.m03 * f00 + this.m13 * f01 + this.m23 * f02;
        float t10 = this.m00 * f10 + this.m10 * f11 + this.m20 * f12;
        float t11 = this.m01 * f10 + this.m11 * f11 + this.m21 * f12;
        float t12 = this.m02 * f10 + this.m12 * f11 + this.m22 * f12;
        float t13 = this.m03 * f10 + this.m13 * f11 + this.m23 * f12;
        this.m20 = this.m00 * f20 + this.m10 * f21 + this.m20 * f22;
        this.m21 = this.m01 * f20 + this.m11 * f21 + this.m21 * f22;
        this.m22 = this.m02 * f20 + this.m12 * f21 + this.m22 * f22;
        this.m23 = this.m03 * f20 + this.m13 * f21 + this.m23 * f22;
        this.m00 = t00;
        this.m01 = t01;
        this.m02 = t02;
        this.m03 = t03;
        this.m10 = t10;
        this.m11 = t11;
        this.m12 = t12;
        this.m13 = t13;
        return this;
    }

    public Matrix4f rotate(float angle, Vector3f axis, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        } else if (dest == this) {
            return this.rotate(angle, axis);
        }
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        float oneminusc = 1.0f - c;
        float xy = axis.x * axis.y;
        float yz = axis.y * axis.z;
        float xz = axis.x * axis.z;
        float xs = axis.x * s;
        float ys = axis.y * s;
        float zs = axis.z * s;
        float f0 = axis.x * axis.x * oneminusc + c;
        float f1 = xy * oneminusc + zs;
        float f2 = xz * oneminusc - ys;
        float f4 = xy * oneminusc - zs;
        float f5 = axis.y * axis.y * oneminusc + c;
        float f6 = yz * oneminusc + xs;
        float f8 = xz * oneminusc + ys;
        float f9 = yz * oneminusc - xs;
        float f10 = axis.z * axis.z * oneminusc + c;
        dest.m00 = this.m00 * f0 + this.m10 * f1 + this.m20 * f2;
        dest.m01 = this.m01 * f0 + this.m11 * f1 + this.m21 * f2;
        dest.m02 = this.m02 * f0 + this.m12 * f1 + this.m22 * f2;
        dest.m03 = this.m03 * f0 + this.m13 * f1 + this.m23 * f2;
        dest.m10 = this.m00 * f4 + this.m10 * f5 + this.m20 * f6;
        dest.m11 = this.m01 * f4 + this.m11 * f5 + this.m21 * f6;
        dest.m12 = this.m02 * f4 + this.m12 * f5 + this.m22 * f6;
        dest.m13 = this.m03 * f4 + this.m13 * f5 + this.m23 * f6;
        dest.m20 = this.m00 * f8 + this.m10 * f9 + this.m20 * f10;
        dest.m21 = this.m01 * f8 + this.m11 * f9 + this.m21 * f10;
        dest.m22 = this.m02 * f8 + this.m12 * f9 + this.m22 * f10;
        dest.m23 = this.m03 * f8 + this.m13 * f9 + this.m23 * f10;
        return dest;
    }

    public Matrix4f translate(Vector3f vec, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        } else if (dest == this) {
            return this.translate(vec);
        }
        dest.m30 += this.m00 * vec.x + this.m10 * vec.y + this.m20 * vec.z;
        dest.m31 += this.m01 * vec.x + this.m11 * vec.y + this.m21 * vec.z;
        dest.m32 += this.m02 * vec.x + this.m12 * vec.y + this.m22 * vec.z;
        dest.m33 += this.m03 * vec.x + this.m13 * vec.y + this.m23 * vec.z;
        return dest;
    }

    public Matrix4f translate(Vector2f vec, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        } else if (dest == this) {
            return this.translate(vec);
        }
        dest.m30 += this.m00 * vec.x + this.m10 * vec.y;
        dest.m31 += this.m01 * vec.x + this.m11 * vec.y;
        dest.m32 += this.m02 * vec.x + this.m12 * vec.y;
        dest.m33 += this.m03 * vec.x + this.m13 * vec.y;
        return dest;
    }

    public Matrix4f transpose(Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        if (this == dest) {
            this.transpose();
        } else {
            dest.m00 = this.m00;
            dest.m01 = this.m10;
            dest.m02 = this.m20;
            dest.m03 = this.m30;
            dest.m10 = this.m01;
            dest.m11 = this.m11;
            dest.m12 = this.m21;
            dest.m13 = this.m31;
            dest.m20 = this.m02;
            dest.m21 = this.m12;
            dest.m22 = this.m22;
            dest.m23 = this.m32;
            dest.m30 = this.m03;
            dest.m31 = this.m13;
            dest.m32 = this.m23;
            dest.m33 = this.m33;
        }
        return dest;
    }

    public float determinant() {
        float f = this.m00 * (this.m11 * this.m22 * this.m33 + this.m12 * this.m23 * this.m31 + this.m13 * this.m21 * this.m32 - this.m13 * this.m22 * this.m31 - this.m11 * this.m23 * this.m32 - this.m12 * this.m21 * this.m33);
        f -= this.m01 * (this.m10 * this.m22 * this.m33 + this.m12 * this.m23 * this.m30 + this.m13 * this.m20 * this.m32 - this.m13 * this.m22 * this.m30 - this.m10 * this.m23 * this.m32 - this.m12 * this.m20 * this.m33);
        f += this.m02 * (this.m10 * this.m21 * this.m33 + this.m11 * this.m23 * this.m30 + this.m13 * this.m20 * this.m31 - this.m13 * this.m21 * this.m30 - this.m10 * this.m23 * this.m31 - this.m11 * this.m20 * this.m33);
        return f -= this.m03 * (this.m10 * this.m21 * this.m32 + this.m11 * this.m22 * this.m30 + this.m12 * this.m20 * this.m31 - this.m12 * this.m21 * this.m30 - this.m10 * this.m22 * this.m31 - this.m11 * this.m20 * this.m32);
    }

    private float determinant3x3(float t00, float t01, float t02, float t10, float t11, float t12, float t20, float t21, float t22) {
        return t00 * (t11 * t22 - t12 * t21) + t01 * (t12 * t20 - t10 * t22) + t02 * (t10 * t21 - t11 * t20);
    }

    public Matrix invert() {
        float determinant = this.determinant();
        if (determinant != 0.0f) {
            float determinant_inv = 1.0f / determinant;
            float t00 = this.determinant3x3(this.m11, this.m12, this.m13, this.m21, this.m22, this.m23, this.m31, this.m32, this.m33);
            float t01 = -this.determinant3x3(this.m10, this.m12, this.m13, this.m20, this.m22, this.m23, this.m30, this.m32, this.m33);
            float t02 = this.determinant3x3(this.m10, this.m11, this.m13, this.m20, this.m21, this.m23, this.m30, this.m31, this.m33);
            float t03 = -this.determinant3x3(this.m10, this.m11, this.m12, this.m20, this.m21, this.m22, this.m30, this.m31, this.m32);
            float t10 = -this.determinant3x3(this.m01, this.m02, this.m03, this.m21, this.m22, this.m23, this.m31, this.m32, this.m33);
            float t11 = this.determinant3x3(this.m00, this.m02, this.m03, this.m20, this.m22, this.m23, this.m30, this.m32, this.m33);
            float t12 = -this.determinant3x3(this.m00, this.m01, this.m03, this.m20, this.m21, this.m23, this.m30, this.m31, this.m33);
            float t13 = this.determinant3x3(this.m00, this.m01, this.m02, this.m20, this.m21, this.m22, this.m30, this.m31, this.m32);
            float t20 = this.determinant3x3(this.m01, this.m02, this.m03, this.m11, this.m12, this.m13, this.m31, this.m32, this.m33);
            float t21 = -this.determinant3x3(this.m00, this.m02, this.m03, this.m10, this.m12, this.m13, this.m30, this.m32, this.m33);
            float t22 = this.determinant3x3(this.m00, this.m01, this.m03, this.m10, this.m11, this.m13, this.m30, this.m31, this.m33);
            float t23 = -this.determinant3x3(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m30, this.m31, this.m32);
            float t30 = -this.determinant3x3(this.m01, this.m02, this.m03, this.m11, this.m12, this.m13, this.m21, this.m22, this.m23);
            float t31 = this.determinant3x3(this.m00, this.m02, this.m03, this.m10, this.m12, this.m13, this.m20, this.m22, this.m23);
            float t32 = -this.determinant3x3(this.m00, this.m01, this.m03, this.m10, this.m11, this.m13, this.m20, this.m21, this.m23);
            float t33 = this.determinant3x3(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
            this.m00 = t00 * determinant_inv;
            this.m11 = t11 * determinant_inv;
            this.m22 = t22 * determinant_inv;
            this.m33 = t33 * determinant_inv;
            this.m01 = t10 * determinant_inv;
            this.m10 = t01 * determinant_inv;
            this.m20 = t02 * determinant_inv;
            this.m02 = t20 * determinant_inv;
            this.m12 = t21 * determinant_inv;
            this.m21 = t12 * determinant_inv;
            this.m03 = t30 * determinant_inv;
            this.m30 = t03 * determinant_inv;
            this.m13 = t31 * determinant_inv;
            this.m31 = t13 * determinant_inv;
            this.m32 = t23 * determinant_inv;
            this.m23 = t32 * determinant_inv;
            return this;
        }
        return null;
    }

    public Matrix negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m03 = -this.m03;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m13 = -this.m13;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
        this.m23 = -this.m23;
        this.m30 = -this.m30;
        this.m31 = -this.m31;
        this.m32 = -this.m32;
        this.m33 = -this.m33;
        return this;
    }

    public Matrix4f negate(Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        dest.m00 = -this.m00;
        dest.m01 = -this.m01;
        dest.m02 = -this.m02;
        dest.m03 = -this.m03;
        dest.m10 = -this.m10;
        dest.m11 = -this.m11;
        dest.m12 = -this.m12;
        dest.m13 = -this.m13;
        dest.m20 = -this.m20;
        dest.m21 = -this.m21;
        dest.m22 = -this.m22;
        dest.m23 = -this.m23;
        dest.m30 = -this.m30;
        dest.m31 = -this.m31;
        dest.m32 = -this.m32;
        dest.m33 = -this.m33;
        return dest;
    }
}

