/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.model.loaders;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.Color;
import org.lwjgl.util.model.BoneFrame;
import org.lwjgl.util.model.BonedModel;
import org.lwjgl.util.model.BonedVertex;
import org.lwjgl.util.model.MeshFrame;
import org.lwjgl.util.model.MeshedModel;
import org.lwjgl.util.model.Model;
import org.lwjgl.util.model.Triangle;
import org.lwjgl.util.model.Vertex;
import org.lwjgl.util.model.Weight;
import org.lwjgl.util.model.loaders.XMLUtil;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLLoader {
    private final Document src;
    private int numVertices;
    private int numBones;

    public XMLLoader(Document src) {
        this.src = src;
    }

    public Model load() throws Exception {
        String name = XMLUtil.getString(this.src.getDocumentElement(), "modelname");
        String material = XMLUtil.getString(this.src.getDocumentElement(), "material");
        this.numVertices = XMLUtil.getInt(this.src.getDocumentElement(), "vertexcount");
        if (XMLUtil.getString(this.src.getDocumentElement(), "type").equals("boned")) {
            this.numBones = XMLUtil.getInt(this.src.getDocumentElement(), "bones", 0);
            return new BonedModel(name, material, this.loadTriangles(), this.loadSkin(), this.loadColor(), this.loadBoneAnimations(), this.loadBonedVertices());
        }
        if (XMLUtil.getString(this.src.getDocumentElement(), "type").equals("meshed")) {
            return new MeshedModel(name, material, this.loadTriangles(), this.loadSkin(), this.loadColor(), this.loadMeshAnimations());
        }
        throw new Exception("Unsupported model type.");
    }

    private BonedVertex[] loadBonedVertices() throws Exception {
        Element verticesElement = XMLUtil.getChild(this.src.getDocumentElement(), "vertices");
        if (verticesElement == null) {
            return null;
        }
        List vertexElements = XMLUtil.getChildren(verticesElement, "vertex");
        if (vertexElements.size() != this.numVertices) {
            throw new Exception("Vertex count incorrect, got " + vertexElements.size() + ", expected " + this.numVertices);
        }
        BonedVertex[] vertices = new BonedVertex[vertexElements.size()];
        int vertexCount = 0;
        Iterator i = vertexElements.iterator();
        while (i.hasNext()) {
            Element vertexElement = (Element)i.next();
            vertices[vertexCount++] = this.loadBonedVertex(vertexElement);
        }
        return vertices;
    }

    private Vector2f[] loadSkin() throws Exception {
        Element skinElement = XMLUtil.getChild(this.src.getDocumentElement(), "skin");
        if (skinElement == null) {
            return null;
        }
        List skinElements = XMLUtil.getChildren(skinElement, "texcoord");
        if (skinElements.size() == 0) {
            return null;
        }
        if (skinElements.size() != this.numVertices) {
            throw new Exception("Skin count incorrect, got " + skinElements.size() + ", expected " + this.numVertices);
        }
        Vector2f[] skins = new Vector2f[skinElements.size()];
        int skinCount = 0;
        Iterator i = skinElements.iterator();
        while (i.hasNext()) {
            Element texCoordElement = (Element)i.next();
            skins[skinCount++] = this.loadTexCoord(texCoordElement);
        }
        return skins;
    }

    private Color[] loadColor() throws Exception {
        Element colorsElement = XMLUtil.getChild(this.src.getDocumentElement(), "colors");
        if (colorsElement == null) {
            return null;
        }
        List colorElements = XMLUtil.getChildren(colorsElement, "color");
        if (colorElements.size() == 0) {
            return null;
        }
        if (colorElements.size() != this.numVertices) {
            throw new Exception("Color count incorrect, got " + colorElements.size() + ", expected " + this.numVertices);
        }
        Color[] colors = new Color[colorElements.size()];
        int colorCount = 0;
        Iterator i = colorElements.iterator();
        while (i.hasNext()) {
            Element colorElement = (Element)i.next();
            colors[colorCount++] = this.loadColor(colorElement);
        }
        return colors;
    }

    private Triangle[] loadTriangles() throws Exception {
        Element meshElement = XMLUtil.getChild(this.src.getDocumentElement(), "mesh");
        if (meshElement == null) {
            return null;
        }
        List triangleElements = XMLUtil.getChildren(meshElement, "triangle");
        Triangle[] triangles = new Triangle[triangleElements.size()];
        int triangleCount = 0;
        Iterator i = triangleElements.iterator();
        while (i.hasNext()) {
            Element triangleElement = (Element)i.next();
            triangles[triangleCount++] = this.loadTriangle(triangleElement);
        }
        return triangles;
    }

    private Map loadBoneAnimations() throws Exception {
        Element animationElement = XMLUtil.getChild(this.src.getDocumentElement(), "animation");
        if (animationElement == null) {
            return null;
        }
        List sequenceElements = XMLUtil.getChildren(this.src.getDocumentElement(), "sequence");
        HashMap<String, BoneFrame[]> animations = new HashMap<String, BoneFrame[]>(sequenceElements.size());
        Iterator i = sequenceElements.iterator();
        while (i.hasNext()) {
            Element sequenceElement = (Element)i.next();
            animations.put(XMLUtil.getString(sequenceElement, "sequencename"), this.loadBonedAnimation(sequenceElement));
        }
        return animations;
    }

    private Map loadMeshAnimations() throws Exception {
        Element animationElement = XMLUtil.getChild(this.src.getDocumentElement(), "animation");
        if (animationElement == null) {
            return null;
        }
        List sequenceElements = XMLUtil.getChildren(animationElement, "sequence");
        HashMap<String, MeshFrame[]> animations = new HashMap<String, MeshFrame[]>(sequenceElements.size());
        Iterator i = sequenceElements.iterator();
        while (i.hasNext()) {
            Element sequenceElement = (Element)i.next();
            animations.put(XMLUtil.getString(sequenceElement, "sequencename"), this.loadMeshAnimation(sequenceElement));
        }
        return animations;
    }

    private BonedVertex loadBonedVertex(Element vertexElement) throws Exception {
        Weight[] weights;
        List weightElements = XMLUtil.getChildren(vertexElement, "weight");
        if (weightElements.size() == 0) {
            weights = null;
        } else {
            weights = new Weight[weightElements.size()];
            int weightCount = 0;
            Iterator i = weightElements.iterator();
            while (i.hasNext()) {
                Element weightElement = (Element)i.next();
                weights[weightCount++] = this.loadWeight(weightElement);
            }
        }
        return new BonedVertex(new Vector3f(XMLUtil.getFloat(vertexElement, "x"), XMLUtil.getFloat(vertexElement, "y"), XMLUtil.getFloat(vertexElement, "z")), XMLUtil.hasAttribute(vertexElement, "nx") ? new Vector3f(XMLUtil.getFloat(vertexElement, "nx"), XMLUtil.getFloat(vertexElement, "ny"), XMLUtil.getFloat(vertexElement, "nz")) : null, weights);
    }

    private Vertex loadMeshVertex(Element vertexElement) throws Exception {
        return new Vertex(new Vector3f(XMLUtil.getFloat(vertexElement, "x"), XMLUtil.getFloat(vertexElement, "y"), XMLUtil.getFloat(vertexElement, "z")), XMLUtil.hasAttribute(vertexElement, "nx") ? new Vector3f(XMLUtil.getFloat(vertexElement, "nx"), XMLUtil.getFloat(vertexElement, "ny"), XMLUtil.getFloat(vertexElement, "nz")) : null);
    }

    private Weight loadWeight(Element element) throws Exception {
        int bone = XMLUtil.getInt(element, "bone");
        if (bone < 0 || bone >= this.numBones) {
            throw new Exception("Bone index out of range");
        }
        return new Weight(bone, XMLUtil.getFloat(element, "weight"));
    }

    private Triangle loadTriangle(Element element) throws Exception {
        int a = XMLUtil.getInt(element, "a");
        if (a < 0 || a >= this.numVertices) {
            throw new Exception("'a' is out of range");
        }
        int b = XMLUtil.getInt(element, "b");
        if (b < 0 || b >= this.numVertices) {
            throw new Exception("'b' is out of range");
        }
        int c = XMLUtil.getInt(element, "c");
        if (c < 0 || c >= this.numVertices) {
            throw new Exception("'c' is out of range");
        }
        if (a == b || a == c || b == c) {
            throw new Exception("Degenerate triangle");
        }
        return new Triangle(a, b, c, XMLUtil.getInt(element, "adjacency", 0));
    }

    private Vector2f loadTexCoord(Element element) throws Exception {
        return new Vector2f(XMLUtil.getFloat(element, "u"), XMLUtil.getFloat(element, "v"));
    }

    private Color loadColor(Element element) throws Exception {
        return new Color(XMLUtil.getInt(element, "red"), XMLUtil.getInt(element, "green"), XMLUtil.getInt(element, "blue"), XMLUtil.getInt(element, "alpha", 255));
    }

    private BoneFrame[] loadBonedAnimation(Element element) throws Exception {
        List frameElements = XMLUtil.getChildren(element, "frame");
        Object[] frames = new BoneFrame[frameElements.size()];
        int frameCount = 0;
        Iterator i = frameElements.iterator();
        while (i.hasNext()) {
            Element frameElement = (Element)i.next();
            frames[frameCount++] = this.loadBoneFrame(frameElement);
        }
        Arrays.sort(frames);
        return frames;
    }

    private MeshFrame[] loadMeshAnimation(Element element) throws Exception {
        List frameElements = XMLUtil.getChildren(element, "frame");
        Object[] frames = new MeshFrame[frameElements.size()];
        int frameCount = 0;
        Iterator i = frameElements.iterator();
        while (i.hasNext()) {
            Element frameElement = (Element)i.next();
            frames[frameCount++] = this.loadMeshFrame(frameElement);
        }
        Arrays.sort(frames);
        return frames;
    }

    private BoneFrame loadBoneFrame(Element element) throws Exception {
        List boneElements = XMLUtil.getChildren(element, "bone");
        if (boneElements.size() != this.numBones) {
            throw new Exception("Expected " + this.numBones + " bones in frame, only got " + boneElements.size());
        }
        Matrix4f[] bones = new Matrix4f[boneElements.size()];
        int boneCount = 0;
        Iterator i = boneElements.iterator();
        while (i.hasNext()) {
            Element boneElement = (Element)i.next();
            bones[boneCount++] = this.loadBone(boneElement);
        }
        return new BoneFrame(XMLUtil.getFloat(element, "time"), XMLUtil.getString(element, "action", null), bones);
    }

    private MeshFrame loadMeshFrame(Element element) throws Exception {
        List vertexElements = XMLUtil.getChildren(element, "vertex");
        Vertex[] vertices = new Vertex[vertexElements.size()];
        if (vertices.length != this.numVertices) {
            throw new Exception("Vertex count incorrect");
        }
        int vertexCount = 0;
        Iterator i = vertexElements.iterator();
        while (i.hasNext()) {
            Element vertexElement = (Element)i.next();
            vertices[vertexCount++] = this.loadMeshVertex(vertexElement);
        }
        return new MeshFrame(XMLUtil.getFloat(element, "time"), XMLUtil.getString(element, "action", null), vertices);
    }

    private Matrix4f loadBone(Element element) throws Exception {
        Matrix4f ret = new Matrix4f();
        ret.m00 = XMLUtil.getFloat(element, "m00");
        ret.m01 = XMLUtil.getFloat(element, "m01");
        ret.m02 = XMLUtil.getFloat(element, "m02");
        ret.m03 = XMLUtil.getFloat(element, "m03");
        ret.m10 = XMLUtil.getFloat(element, "m10");
        ret.m11 = XMLUtil.getFloat(element, "m11");
        ret.m12 = XMLUtil.getFloat(element, "m12");
        ret.m13 = XMLUtil.getFloat(element, "m13");
        ret.m20 = XMLUtil.getFloat(element, "m20");
        ret.m21 = XMLUtil.getFloat(element, "m21");
        ret.m22 = XMLUtil.getFloat(element, "m22");
        ret.m23 = XMLUtil.getFloat(element, "m23");
        ret.m30 = XMLUtil.getFloat(element, "m30", 0.0f);
        ret.m31 = XMLUtil.getFloat(element, "m31", 0.0f);
        ret.m32 = XMLUtil.getFloat(element, "m32", 0.0f);
        ret.m33 = XMLUtil.getFloat(element, "m33", 1.0f);
        return ret;
    }
}

