/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.TypeVisitor;
import java.io.PrintWriter;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.lwjgl.util.generator.Auto;
import org.lwjgl.util.generator.AutoResultSize;
import org.lwjgl.util.generator.BufferObject;
import org.lwjgl.util.generator.CachedResult;
import org.lwjgl.util.generator.Code;
import org.lwjgl.util.generator.Constant;
import org.lwjgl.util.generator.Extension;
import org.lwjgl.util.generator.JavaTypeTranslator;
import org.lwjgl.util.generator.NativeType;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.NoErrorCheck;
import org.lwjgl.util.generator.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String TYPEDEF_POSTFIX = "PROC";
    public static final String FUNCTION_POINTER_VAR_NAME = "function_pointer";
    public static final String FUNCTION_POINTER_POSTFIX = "_pointer";
    public static final String CHECKS_CLASS_NAME = "GLChecks";
    public static final String CONTEXT_CAPS_CLASS_NAME = "ContextCapabilities";
    public static final String STUB_INITIALIZER_NAME = "initNativeStubs";
    public static final String BUFFER_OBJECT_METHOD_POSTFIX = "BO";
    public static final String BUFFER_OBJECT_PARAMETER_POSTFIX = "_buffer_offset";
    public static final String RESULT_SIZE_NAME = "result_size";
    public static final String RESULT_VAR_NAME = "__result";
    public static final String CACHED_BUFFER_NAME = "old_buffer";
    private static final String OVERLOADED_METHOD_PREFIX = "n";

    public static String getTypedefName(MethodDeclaration method) {
        return method.getSimpleName() + TYPEDEF_POSTFIX;
    }

    public static String getFunctionAddressName(InterfaceDeclaration interface_decl, MethodDeclaration method) {
        return interface_decl.getSimpleName() + "_" + method.getSimpleName() + FUNCTION_POINTER_POSTFIX;
    }

    public static boolean isFinal(InterfaceDeclaration d) {
        Extension extension_annotation = (Extension)d.getAnnotation(Extension.class);
        return extension_annotation == null || extension_annotation.isFinal();
    }

    public static Collection<AnnotationMirror> getSortedAnnotations(Collection<AnnotationMirror> annotations) {
        ArrayList<AnnotationMirror> annotation_list = new ArrayList<AnnotationMirror>(annotations);
        Collections.sort(annotation_list, new AnnotationMirrorComparator());
        return annotation_list;
    }

    public static String getReferenceName(InterfaceDeclaration interface_decl, MethodDeclaration method, ParameterDeclaration param) {
        return interface_decl.getSimpleName() + "_" + method.getSimpleName() + "_" + param.getSimpleName();
    }

    public static boolean isAddressableType(TypeMirror type) {
        return Utils.isAddressableType(Utils.getJavaType(type));
    }

    public static boolean isAddressableType(Class type) {
        return Buffer.class.isAssignableFrom(type) || String.class.equals((Object)type);
    }

    public static Class getJavaType(TypeMirror type_mirror) {
        JavaTypeTranslator translator = new JavaTypeTranslator();
        type_mirror.accept((TypeVisitor)translator);
        return translator.getType();
    }

    private static boolean hasParameterMultipleTypes(ParameterDeclaration param) {
        int num_native_annotations = 0;
        for (AnnotationMirror annotation : param.getAnnotationMirrors()) {
            if (NativeTypeTranslator.getAnnotation(annotation, NativeType.class) == null) continue;
            ++num_native_annotations;
        }
        return num_native_annotations > 1;
    }

    public static boolean isParameterMultiTyped(ParameterDeclaration param) {
        boolean result = Buffer.class.equals((Object)Utils.getJavaType(param.getType()));
        if (!result && Utils.hasParameterMultipleTypes(param)) {
            throw new RuntimeException(param + " not defined as java.nio.Buffer but has multiple types");
        }
        return result;
    }

    public static ParameterDeclaration findParameter(MethodDeclaration method, String name) {
        for (ParameterDeclaration param : method.getParameters()) {
            if (!param.getSimpleName().equals(name)) continue;
            return param;
        }
        throw new RuntimeException("Parameter " + name + " not found");
    }

    public static void printDocComment(PrintWriter writer, Declaration decl) {
        String doc_comment = decl.getDocComment();
        if (doc_comment != null) {
            writer.println("\t/**");
            StringTokenizer doc_lines = new StringTokenizer(doc_comment, "\n");
            while (doc_lines.hasMoreTokens()) {
                writer.println("\t *" + doc_lines.nextToken());
            }
            writer.println("\t */");
        }
    }

    public static ParameterDeclaration getAutoResultSizeParameter(MethodDeclaration method) {
        ParameterDeclaration result = null;
        for (ParameterDeclaration param : method.getParameters()) {
            if (param.getAnnotation(AutoResultSize.class) == null) continue;
            if (result != null) {
                throw new RuntimeException(method + " contains multiple AutoResultSize annotations");
            }
            result = param;
        }
        return result;
    }

    public static AnnotationMirror getParameterAutoAnnotation(ParameterDeclaration param) {
        for (AnnotationMirror annotation : param.getAnnotationMirrors()) {
            if (NativeTypeTranslator.getAnnotation(annotation, Auto.class) == null) continue;
            return annotation;
        }
        return null;
    }

    public static boolean isMethodIndirect(boolean generate_error_checks, boolean context_specific, MethodDeclaration method) {
        for (ParameterDeclaration param : method.getParameters()) {
            if (!Utils.isAddressableType(param.getType()) && Utils.getParameterAutoAnnotation(param) == null && param.getAnnotation(Constant.class) == null) continue;
            return true;
        }
        return Utils.hasMethodBufferObjectParameter(method) || method.getAnnotation(Code.class) != null || method.getAnnotation(CachedResult.class) != null || generate_error_checks && method.getAnnotation(NoErrorCheck.class) == null || context_specific;
    }

    public static String getNativeQualifiedName(String qualified_name) {
        return qualified_name.replaceAll("\\.", "_");
    }

    public static String getQualifiedNativeMethodName(String qualified_class_name, String method_name) {
        return "Java_" + Utils.getNativeQualifiedName(qualified_class_name) + "_" + method_name;
    }

    public static String getQualifiedNativeMethodName(String qualified_class_name, MethodDeclaration method, boolean generate_error_checks, boolean context_specific) {
        String method_name = Utils.getSimpleNativeMethodName(method, generate_error_checks, context_specific);
        return Utils.getQualifiedNativeMethodName(qualified_class_name, method_name);
    }

    public static ParameterDeclaration getResultParameter(MethodDeclaration method) {
        ParameterDeclaration result_param = null;
        for (ParameterDeclaration param : method.getParameters()) {
            if (param.getAnnotation(Result.class) == null) continue;
            if (result_param != null) {
                throw new RuntimeException("Multiple parameters annotated with Result in method " + method);
            }
            result_param = param;
        }
        return result_param;
    }

    public static TypeMirror getMethodReturnType(MethodDeclaration method) {
        ParameterDeclaration result_param = Utils.getResultParameter(method);
        TypeMirror result_type = result_param != null ? result_param.getType() : method.getReturnType();
        return result_type;
    }

    public static boolean needResultSize(MethodDeclaration method) {
        return Utils.getNIOBufferType(Utils.getMethodReturnType(method)) != null && Utils.getAutoResultSizeParameter(method) == null;
    }

    public static void printExtraCallArguments(PrintWriter writer, MethodDeclaration method, String size_parameter_name) {
        writer.print(size_parameter_name);
        if (method.getAnnotation(CachedResult.class) != null) {
            writer.print(", old_buffer");
        }
    }

    private static String getClassName(InterfaceDeclaration interface_decl, String opengl_name) {
        Extension extension_annotation = (Extension)interface_decl.getAnnotation(Extension.class);
        if (extension_annotation != null && !"".equals(extension_annotation.className())) {
            return extension_annotation.className();
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < opengl_name.length(); ++i) {
            int ch = opengl_name.codePointAt(i);
            if (ch == 95) {
                result.appendCodePoint(Character.toUpperCase(opengl_name.codePointAt(++i)));
                continue;
            }
            result.appendCodePoint(ch);
        }
        return result.toString();
    }

    public static boolean hasMethodBufferObjectParameter(MethodDeclaration method) {
        for (ParameterDeclaration param : method.getParameters()) {
            if (param.getAnnotation(BufferObject.class) == null) continue;
            return true;
        }
        return false;
    }

    public static String getQualifiedClassName(InterfaceDeclaration interface_decl) {
        return interface_decl.getPackage().getQualifiedName() + "." + Utils.getSimpleClassName(interface_decl);
    }

    public static String getSimpleClassName(InterfaceDeclaration interface_decl) {
        return Utils.getClassName(interface_decl, interface_decl.getSimpleName());
    }

    public static Class<?> getNIOBufferType(TypeMirror t) {
        Class param_type = Utils.getJavaType(t);
        if (Buffer.class.isAssignableFrom(param_type)) {
            return param_type;
        }
        return null;
    }

    public static String getSimpleNativeMethodName(MethodDeclaration method, boolean generate_error_checks, boolean context_specific) {
        String method_name = method.getSimpleName();
        if (Utils.isMethodIndirect(generate_error_checks, context_specific, method)) {
            method_name = OVERLOADED_METHOD_PREFIX + method_name;
        }
        return method_name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationMirrorComparator
    implements Comparator<AnnotationMirror> {
        private AnnotationMirrorComparator() {
        }

        @Override
        public int compare(AnnotationMirror a1, AnnotationMirror a2) {
            String n1 = a1.getAnnotationType().getDeclaration().getQualifiedName();
            String n2 = a2.getAnnotationType().getDeclaration().getQualifiedName();
            int result = n1.compareTo(n2);
            return result;
        }

        public boolean equals(AnnotationMirror a1, AnnotationMirror a2) {
            return this.compare(a1, a2) == 0;
        }
    }
}

