/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.TypeVisitor;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import org.lwjgl.util.generator.Indirect;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.Result;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedefsGenerator {
    private static void generateNativeTypedefs(TypeMap type_map, PrintWriter writer, MethodDeclaration method) {
        TypeMirror return_type = method.getReturnType();
        writer.print("typedef ");
        NativeTypeTranslator translator = new NativeTypeTranslator(type_map, (Declaration)method);
        return_type.accept((TypeVisitor)translator);
        writer.print(translator.getSignature());
        writer.print(" (");
        writer.print(type_map.getTypedefPrefix());
        writer.print(" *" + Utils.getTypedefName(method) + ") (");
        TypedefsGenerator.generateNativeTypedefsParameters(type_map, writer, method.getParameters());
        writer.println(");");
    }

    private static void generateNativeTypedefsParameters(TypeMap type_map, PrintWriter writer, Collection<ParameterDeclaration> params) {
        if (params.size() > 0) {
            Iterator<ParameterDeclaration> it = params.iterator();
            TypedefsGenerator.generateNativeTypedefsParameter(type_map, writer, it.next());
            while (it.hasNext()) {
                writer.print(", ");
                TypedefsGenerator.generateNativeTypedefsParameter(type_map, writer, it.next());
            }
        }
    }

    private static void generateNativeTypedefsParameter(TypeMap type_map, PrintWriter writer, ParameterDeclaration param) {
        NativeTypeTranslator translator = new NativeTypeTranslator(type_map, (Declaration)param);
        param.getType().accept((TypeVisitor)translator);
        writer.print(translator.getSignature());
        if (param.getAnnotation(Result.class) != null || param.getAnnotation(Indirect.class) != null) {
            writer.print("*");
        }
        writer.print(" " + param.getSimpleName());
    }

    public static void generateNativeTypedefs(TypeMap type_map, PrintWriter writer, Collection<? extends MethodDeclaration> methods) {
        for (MethodDeclaration methodDeclaration : methods) {
            TypedefsGenerator.generateNativeTypedefs(type_map, writer, methodDeclaration);
        }
    }
}

