/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.util.generator.NativeType;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.Signedness;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfo {
    public static final String UNSIGNED_PARAMETER_NAME = "unsigned";
    private final Signedness signedness;
    private final Class type;
    private final String auto_type;

    private TypeInfo(Class type, Signedness signedness, String auto_type) {
        this.type = type;
        this.signedness = signedness;
        this.auto_type = auto_type;
    }

    public Class getType() {
        return this.type;
    }

    public Signedness getSignedness() {
        return this.signedness;
    }

    public String getAutoType() {
        if (this.auto_type == null) {
            throw new RuntimeException("No auto type assigned");
        }
        return this.auto_type;
    }

    private static Class getTypeFromPrimitiveKind(PrimitiveType.Kind kind) {
        Class<Number> type;
        switch (kind) {
            case INT: {
                type = Integer.TYPE;
                break;
            }
            case FLOAT: {
                type = Float.TYPE;
                break;
            }
            case DOUBLE: {
                type = Double.TYPE;
                break;
            }
            case SHORT: {
                type = Short.TYPE;
                break;
            }
            case BYTE: {
                type = Byte.TYPE;
                break;
            }
            default: {
                throw new RuntimeException(kind + " is not allowed");
            }
        }
        return type;
    }

    private static Class getBufferTypeFromPrimitiveKind(PrimitiveType.Kind kind) {
        Class type;
        switch (kind) {
            case INT: {
                type = IntBuffer.class;
                break;
            }
            case FLOAT: {
                type = FloatBuffer.class;
                break;
            }
            case DOUBLE: {
                type = DoubleBuffer.class;
                break;
            }
            case SHORT: {
                type = ShortBuffer.class;
                break;
            }
            case BYTE: 
            case BOOLEAN: {
                type = ByteBuffer.class;
                break;
            }
            default: {
                throw new RuntimeException(kind + " is not allowed");
            }
        }
        return type;
    }

    private static TypeInfo getDefaultTypeInfo(TypeMirror t) {
        Class java_type = Utils.getJavaType(t);
        return new TypeInfo(java_type, Signedness.NONE, null);
    }

    public static Map<ParameterDeclaration, TypeInfo> getDefaultTypeInfoMap(MethodDeclaration method) {
        HashMap<ParameterDeclaration, TypeInfo> map = new HashMap<ParameterDeclaration, TypeInfo>();
        for (ParameterDeclaration param : method.getParameters()) {
            TypeInfo type_info = TypeInfo.getDefaultTypeInfo(param.getType());
            map.put(param, type_info);
        }
        return map;
    }

    private static Collection<TypeInfo> getTypeInfos(TypeMap type_map, Declaration param, TypeMirror decl_type) {
        Collection<AnnotationMirror> annotations = Utils.getSortedAnnotations(param.getAnnotationMirrors());
        HashMap types = new HashMap();
        ArrayList<TypeInfo> multityped_result = new ArrayList<TypeInfo>();
        boolean add_default_type = true;
        for (AnnotationMirror annotation : annotations) {
            NativeType native_type_annotation = NativeTypeTranslator.getAnnotation(annotation, NativeType.class);
            if (native_type_annotation == null) continue;
            Class<?> annotation_type = NativeTypeTranslator.getClassFromType((DeclaredType)annotation.getAnnotationType());
            Signedness signedness = type_map.getSignednessFromType(annotation_type);
            Class inverse_type = type_map.getInverseType(annotation_type);
            String auto_type = type_map.getAutoTypeFromAnnotation(annotation);
            if (inverse_type != null && types.containsKey(inverse_type)) {
                TypeInfo inverse_type_info = (TypeInfo)types.get(inverse_type);
                String inverse_auto_type = inverse_type_info.getAutoType();
                auto_type = signedness == Signedness.UNSIGNED ? auto_type + " : " + inverse_auto_type : inverse_auto_type + " : " + auto_type;
                auto_type = "unsigned ? " + auto_type;
                signedness = Signedness.BOTH;
                types.remove(inverse_type);
                multityped_result.remove(inverse_type_info);
            }
            PrimitiveType.Kind kind = type_map.getPrimitiveTypeFromNativeType(annotation_type);
            Class type = Utils.getNIOBufferType(decl_type) != null ? TypeInfo.getBufferTypeFromPrimitiveKind(kind) : TypeInfo.getTypeFromPrimitiveKind(kind);
            TypeInfo type_info = new TypeInfo(type, signedness, auto_type);
            types.put(annotation_type, type_info);
            multityped_result.add(type_info);
            add_default_type = false;
        }
        if (add_default_type) {
            TypeInfo default_type_info = TypeInfo.getDefaultTypeInfo(decl_type);
            ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
            result.add(default_type_info);
            return result;
        }
        return multityped_result;
    }

    private static Map<ParameterDeclaration, Collection<TypeInfo>> getTypeInfoMap(TypeMap type_map, MethodDeclaration method) {
        HashMap<ParameterDeclaration, Collection<TypeInfo>> map = new HashMap<ParameterDeclaration, Collection<TypeInfo>>();
        for (ParameterDeclaration param : method.getParameters()) {
            Collection<TypeInfo> types = TypeInfo.getTypeInfos(type_map, (Declaration)param, param.getType());
            map.put(param, types);
        }
        return map;
    }

    public static Collection<Map<ParameterDeclaration, TypeInfo>> getTypeInfoCrossProduct(TypeMap type_map, MethodDeclaration method) {
        Collection parameter_collection = method.getParameters();
        ParameterDeclaration[] parameters = new ParameterDeclaration[parameter_collection.size()];
        parameter_collection.toArray(parameters);
        ArrayList<Map<ParameterDeclaration, TypeInfo>> cross_product = new ArrayList<Map<ParameterDeclaration, TypeInfo>>();
        TypeInfo.getCrossProductRecursive(0, parameters, TypeInfo.getTypeInfoMap(type_map, method), new HashMap<ParameterDeclaration, TypeInfo>(), cross_product);
        return cross_product;
    }

    private static void getCrossProductRecursive(int index, ParameterDeclaration[] parameters, Map<ParameterDeclaration, Collection<TypeInfo>> typeinfos_map, Map<ParameterDeclaration, TypeInfo> current_instance, Collection<Map<ParameterDeclaration, TypeInfo>> cross_product) {
        if (index == parameters.length) {
            cross_product.add(current_instance);
            return;
        }
        ParameterDeclaration param = parameters[index];
        Collection<TypeInfo> typeinfos = typeinfos_map.get(param);
        if (typeinfos != null) {
            for (TypeInfo typeinfo : typeinfos) {
                HashMap<ParameterDeclaration, TypeInfo> instance = new HashMap<ParameterDeclaration, TypeInfo>(current_instance);
                instance.put(param, typeinfo);
                TypeInfo.getCrossProductRecursive(index + 1, parameters, typeinfos_map, instance, cross_product);
            }
        }
    }
}

