/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.EnumType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.TypeVisitor;
import java.nio.Buffer;
import org.lwjgl.util.generator.NativeTypeTranslator;

class SignatureTranslator
implements TypeVisitor {
    private final boolean add_position_signature;
    private final StringBuilder signature = new StringBuilder();

    SignatureTranslator(boolean add_position_signature) {
        this.add_position_signature = add_position_signature;
    }

    private static String getNativeNameFromClassName(String class_name) {
        return class_name.replaceAll("\\.", "/");
    }

    public String getSignature() {
        return this.signature.toString();
    }

    public void visitAnnotationType(AnnotationType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitArrayType(ArrayType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitClassType(ClassType t) {
        String type_name = SignatureTranslator.getNativeNameFromClassName(t.getDeclaration().getQualifiedName());
        this.signature.append("L");
        this.signature.append(type_name);
        this.signature.append(";");
        if (this.add_position_signature && Buffer.class.isAssignableFrom(NativeTypeTranslator.getClassFromType((DeclaredType)t))) {
            this.signature.append("I");
        }
    }

    public void visitDeclaredType(DeclaredType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitEnumType(EnumType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitInterfaceType(InterfaceType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitPrimitiveType(PrimitiveType t) {
        switch (t.getKind()) {
            case BOOLEAN: {
                this.signature.append("Z");
                break;
            }
            case INT: {
                this.signature.append("I");
                break;
            }
            case FLOAT: {
                this.signature.append("F");
                break;
            }
            case SHORT: {
                this.signature.append("S");
                break;
            }
            case DOUBLE: {
                this.signature.append("D");
                break;
            }
            case BYTE: {
                this.signature.append("B");
                break;
            }
            case LONG: {
                this.signature.append("J");
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type " + t);
            }
        }
    }

    public void visitReferenceType(ReferenceType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitTypeMirror(TypeMirror t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitTypeVariable(TypeVariable t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitVoidType(VoidType t) {
        this.signature.append("V");
    }

    public void visitWildcardType(WildcardType t) {
        throw new RuntimeException(t + " is not allowed");
    }
}

