/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.TypeVisitor;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import org.lwjgl.util.generator.BufferObject;
import org.lwjgl.util.generator.CachedResult;
import org.lwjgl.util.generator.Mode;
import org.lwjgl.util.generator.Platform;
import org.lwjgl.util.generator.PlatformDependent;
import org.lwjgl.util.generator.Result;
import org.lwjgl.util.generator.SignatureTranslator;
import org.lwjgl.util.generator.Utils;

public class RegisterStubsGenerator {
    public static void generateMethodsNativeStubBind(PrintWriter writer, InterfaceDeclaration d, boolean generate_error_checks, boolean context_specific) {
        Iterator it = d.getMethods().iterator();
        while (it.hasNext()) {
            MethodDeclaration method = (MethodDeclaration)it.next();
            PlatformDependent platform_annotation = (PlatformDependent)method.getAnnotation(PlatformDependent.class);
            EnumSet<Platform> platforms = platform_annotation != null ? EnumSet.copyOf(Arrays.asList(platform_annotation.value())) : EnumSet.of(Platform.ALL);
            for (Platform platform : platforms) {
                platform.printPrologue(writer);
                boolean has_buffer_parameter = Utils.hasMethodBufferObjectParameter(method);
                RegisterStubsGenerator.printMethodNativeStubBind(writer, d, method, platform, Mode.NORMAL, it.hasNext() || has_buffer_parameter, generate_error_checks, context_specific);
                if (has_buffer_parameter) {
                    RegisterStubsGenerator.printMethodNativeStubBind(writer, d, method, platform, Mode.BUFFEROBJECT, it.hasNext(), generate_error_checks, context_specific);
                }
                platform.printEpilogue(writer);
            }
        }
        writer.println();
    }

    private static String getTypeSignature(TypeMirror type, boolean add_position_signature) {
        SignatureTranslator v = new SignatureTranslator(add_position_signature);
        type.accept((TypeVisitor)v);
        return v.getSignature();
    }

    private static String getMethodSignature(MethodDeclaration method, Mode mode) {
        Collection params = method.getParameters();
        String signature = "(";
        for (ParameterDeclaration param : params) {
            if (param.getAnnotation(Result.class) != null) continue;
            if (mode == Mode.BUFFEROBJECT && param.getAnnotation(BufferObject.class) != null) {
                signature = signature + "I";
                continue;
            }
            signature = signature + RegisterStubsGenerator.getTypeSignature(param.getType(), true);
        }
        TypeMirror result_type = Utils.getMethodReturnType(method);
        if (Utils.getNIOBufferType(result_type) != null) {
            signature = signature + "I";
        }
        String result_type_signature = RegisterStubsGenerator.getTypeSignature(result_type, false);
        if (method.getAnnotation(CachedResult.class) != null) {
            signature = signature + result_type_signature;
        }
        signature = signature + ")";
        signature = signature + result_type_signature;
        return signature;
    }

    private static void printMethodNativeStubBind(PrintWriter writer, InterfaceDeclaration d, MethodDeclaration method, Platform platform, Mode mode, boolean has_more, boolean generate_error_checks, boolean context_specific) {
        writer.print("\t\t{\"" + Utils.getSimpleNativeMethodName(method, generate_error_checks, context_specific));
        if (mode == Mode.BUFFEROBJECT) {
            writer.print("BO");
        }
        writer.print("\", \"" + RegisterStubsGenerator.getMethodSignature(method, mode) + "\", (void *)&");
        writer.print(Utils.getQualifiedNativeMethodName(Utils.getQualifiedClassName(d), method, generate_error_checks, context_specific));
        if (mode == Mode.BUFFEROBJECT) {
            writer.print("BO");
        }
        String opengl_handle_name = method.getSimpleName().replaceFirst("gl", platform.getPrefix());
        writer.print(", \"" + opengl_handle_name + "\", (void *)&" + method.getSimpleName() + "}");
        if (has_more) {
            writer.println(",");
        }
    }
}

