/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessorListener;
import com.sun.mirror.apt.AnnotationProcessors;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.apt.RoundCompleteEvent;
import com.sun.mirror.apt.RoundCompleteListener;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.DeclarationFilter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.lwjgl.util.generator.CachedReference;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferencesGeneratorProcessorFactory
implements AnnotationProcessorFactory,
RoundCompleteListener {
    private static final String REFERENCES_CLASS_NAME = "References";
    private static final String REFERENCES_PARAMETER_NAME = "references";
    private static boolean first_round = true;
    private static final Collection<String> supportedAnnotations = Collections.unmodifiableCollection(Arrays.asList("*"));

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public Collection<String> supportedOptions() {
        return Collections.emptyList();
    }

    public void roundComplete(RoundCompleteEvent event) {
        first_round = false;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        if (first_round) {
            env.addListener((AnnotationProcessorListener)this);
            return new GeneratorProcessor(env);
        }
        return AnnotationProcessors.NO_OP;
    }

    private static class GeneratorProcessor
    implements AnnotationProcessor {
        private final AnnotationProcessorEnvironment env;

        GeneratorProcessor(AnnotationProcessorEnvironment env) {
            this.env = env;
        }

        public void process() {
            try {
                this.generateReferencesSource();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static void generateCopiesFromParameters(PrintWriter writer, InterfaceDeclaration interface_decl, MethodDeclaration method) {
            for (ParameterDeclaration param : method.getParameters()) {
                CachedReference cached_reference_annotation = (CachedReference)param.getAnnotation(CachedReference.class);
                if (cached_reference_annotation == null) continue;
                Class<?> nio_type = Utils.getNIOBufferType(param.getType());
                String reference_name = Utils.getReferenceName(interface_decl, method, param);
                writer.print("\t\tthis." + reference_name + " = ");
                writer.println("references." + reference_name + ";");
            }
        }

        private static void generateCopiesFromMethods(PrintWriter writer, InterfaceDeclaration interface_decl) {
            for (MethodDeclaration method : interface_decl.getMethods()) {
                GeneratorProcessor.generateCopiesFromParameters(writer, interface_decl, method);
            }
        }

        private static void generateReferencesFromParameters(PrintWriter writer, InterfaceDeclaration interface_decl, MethodDeclaration method) {
            for (ParameterDeclaration param : method.getParameters()) {
                CachedReference cached_reference_annotation = (CachedReference)param.getAnnotation(CachedReference.class);
                if (cached_reference_annotation == null) continue;
                Class<?> nio_type = Utils.getNIOBufferType(param.getType());
                if (nio_type == null) {
                    throw new RuntimeException(param + " in method " + method + " in " + interface_decl + " is annotated with " + cached_reference_annotation.annotationType().getSimpleName() + " but the parameter is not a NIO buffer");
                }
                writer.print("\t" + nio_type.getName() + " " + Utils.getReferenceName(interface_decl, method, param));
                writer.println(";");
            }
        }

        private static void generateReferencesFromMethods(PrintWriter writer, InterfaceDeclaration interface_decl) {
            for (MethodDeclaration method : interface_decl.getMethods()) {
                GeneratorProcessor.generateReferencesFromParameters(writer, interface_decl, method);
            }
        }

        private void generateReferencesSource() throws IOException {
            InterfaceDeclaration interface_decl;
            PrintWriter writer = this.env.getFiler().createTextFile(Filer.Location.SOURCE_TREE, "org.lwjgl.opengl", new File("References.java"), null);
            writer.println("/* MACHINE GENERATED FILE, DO NOT EDIT */");
            writer.println();
            writer.println("package org.lwjgl.opengl;");
            writer.println();
            writer.println("class References {");
            DeclarationFilter filter = DeclarationFilter.getFilter(InterfaceDeclaration.class);
            Collection interface_decls = filter.filter(this.env.getSpecifiedTypeDeclarations());
            for (TypeDeclaration typedecl : interface_decls) {
                interface_decl = (InterfaceDeclaration)typedecl;
                GeneratorProcessor.generateReferencesFromMethods(writer, interface_decl);
            }
            writer.println();
            writer.println("\tvoid copy(References references) {");
            for (TypeDeclaration typedecl : interface_decls) {
                interface_decl = (InterfaceDeclaration)typedecl;
                GeneratorProcessor.generateCopiesFromMethods(writer, interface_decl);
            }
            writer.println("\t}");
            writer.println("}");
            writer.close();
        }
    }
}

