/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.EnumType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.TypeVisitor;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.util.generator.NativeType;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.Utils;

public class PostfixTranslator
implements TypeVisitor {
    private final StringBuilder signature = new StringBuilder();
    private final Declaration declaration;
    private final TypeMap type_map;

    public PostfixTranslator(TypeMap type_map, Declaration declaration) {
        this.declaration = declaration;
        this.type_map = type_map;
    }

    public String getSignature() {
        return this.signature.toString();
    }

    public void visitAnnotationType(AnnotationType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitArrayType(ArrayType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    private static PrimitiveType.Kind getPrimitiveKindFromBufferClass(Class c) {
        if (IntBuffer.class.equals((Object)c)) {
            return PrimitiveType.Kind.INT;
        }
        if (DoubleBuffer.class.equals((Object)c)) {
            return PrimitiveType.Kind.DOUBLE;
        }
        if (ShortBuffer.class.equals((Object)c)) {
            return PrimitiveType.Kind.SHORT;
        }
        if (ByteBuffer.class.equals((Object)c)) {
            return PrimitiveType.Kind.BYTE;
        }
        if (FloatBuffer.class.equals((Object)c)) {
            return PrimitiveType.Kind.FLOAT;
        }
        throw new RuntimeException(c + " is not allowed");
    }

    public void visitClassType(ClassType t) {
        Class<?> c = NativeTypeTranslator.getClassFromType((DeclaredType)t);
        PrimitiveType.Kind kind = PostfixTranslator.getPrimitiveKindFromBufferClass(c);
        this.visitPrimitiveTypeKind(kind);
    }

    public void visitDeclaredType(DeclaredType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitEnumType(EnumType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitInterfaceType(InterfaceType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    private boolean translateAnnotation(AnnotationMirror annotation) {
        NativeType native_type = NativeTypeTranslator.getAnnotation(annotation, NativeType.class);
        if (native_type != null) {
            Class<?> annotation_class = NativeTypeTranslator.getClassFromType((DeclaredType)annotation.getAnnotationType());
            this.signature.append(this.type_map.translateAnnotation(annotation_class));
            return true;
        }
        return false;
    }

    private boolean translateAnnotations() {
        boolean result = false;
        for (AnnotationMirror annotation : Utils.getSortedAnnotations(this.declaration.getAnnotationMirrors())) {
            if (!this.translateAnnotation(annotation)) continue;
            if (result) {
                throw new RuntimeException("Multiple native types");
            }
            result = true;
        }
        return result;
    }

    public void visitPrimitiveType(PrimitiveType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    private void visitPrimitiveTypeKind(PrimitiveType.Kind kind) {
        String type;
        boolean annotated_translation = this.translateAnnotations();
        if (annotated_translation) {
            return;
        }
        switch (kind) {
            case INT: {
                type = "i";
                break;
            }
            case DOUBLE: {
                type = "d";
                break;
            }
            case FLOAT: {
                type = "f";
                break;
            }
            case SHORT: {
                type = "s";
                break;
            }
            case BYTE: {
                type = "b";
                break;
            }
            default: {
                throw new RuntimeException(kind + " is not allowed");
            }
        }
        this.signature.append(type);
    }

    public void visitReferenceType(ReferenceType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitTypeMirror(TypeMirror t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitTypeVariable(TypeVariable t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitVoidType(VoidType t) {
    }

    public void visitWildcardType(WildcardType t) {
        throw new RuntimeException(t + " is not allowed");
    }
}

