/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.EnumType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.TypeVisitor;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.lwjgl.util.generator.Const;
import org.lwjgl.util.generator.NativeType;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeTypeTranslator
implements TypeVisitor {
    private Collection<Class> native_types;
    private boolean is_indirect;
    private final Declaration declaration;
    private final TypeMap type_map;

    public NativeTypeTranslator(TypeMap type_map, Declaration declaration) {
        this.declaration = declaration;
        this.type_map = type_map;
    }

    public String getSignature() {
        StringBuilder signature = new StringBuilder();
        if (this.declaration.getAnnotation(Const.class) != null) {
            signature.append("const ");
        }
        if (this.native_types.size() != 1) {
            throw new RuntimeException("Expected only one native type for declaration " + this.declaration + ", but got " + this.native_types.size());
        }
        signature.append(this.native_types.iterator().next().getSimpleName());
        if (this.is_indirect) {
            signature.append(" *");
        }
        return signature.toString();
    }

    public void visitAnnotationType(AnnotationType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitArrayType(ArrayType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public static PrimitiveType.Kind getPrimitiveKindFromBufferClass(Class c) {
        if (IntBuffer.class.equals((Object)c)) {
            return PrimitiveType.Kind.INT;
        }
        if (DoubleBuffer.class.equals((Object)c)) {
            return PrimitiveType.Kind.DOUBLE;
        }
        if (ShortBuffer.class.equals((Object)c)) {
            return PrimitiveType.Kind.SHORT;
        }
        if (ByteBuffer.class.equals((Object)c)) {
            return PrimitiveType.Kind.BYTE;
        }
        if (FloatBuffer.class.equals((Object)c)) {
            return PrimitiveType.Kind.FLOAT;
        }
        throw new RuntimeException(c + " is not allowed");
    }

    public static Class<?> getClassFromType(DeclaredType t) {
        try {
            return Class.forName(t.getDeclaration().getQualifiedName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void getNativeTypeFromAnnotatedPrimitiveType(PrimitiveType.Kind kind) {
        this.native_types = this.translateAnnotations();
        if (this.native_types.size() == 0) {
            this.native_types.add(this.type_map.getNativeTypeFromPrimitiveType(kind));
        }
    }

    public void visitClassType(ClassType t) {
        Class<?> c = NativeTypeTranslator.getClassFromType((DeclaredType)t);
        if (String.class.equals(c)) {
            this.native_types = new ArrayList<Class>();
            this.native_types.add(this.type_map.getStringElementType());
        } else if (Buffer.class.equals(c)) {
            this.native_types = new ArrayList<Class>();
            this.native_types.add(this.type_map.getVoidType());
        } else if (Buffer.class.isAssignableFrom(c)) {
            PrimitiveType.Kind kind = NativeTypeTranslator.getPrimitiveKindFromBufferClass(c);
            this.getNativeTypeFromAnnotatedPrimitiveType(kind);
        } else {
            throw new RuntimeException(t + " is not allowed");
        }
        this.is_indirect = true;
    }

    public void visitPrimitiveType(PrimitiveType t) {
        this.getNativeTypeFromAnnotatedPrimitiveType(t.getKind());
    }

    public void visitDeclaredType(DeclaredType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitEnumType(EnumType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitInterfaceType(InterfaceType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public static <T extends Annotation> T getAnnotation(AnnotationMirror annotation, Class<T> type) {
        return (T)annotation.getAnnotationType().getDeclaration().getAnnotation(type);
    }

    private static Class translateAnnotation(AnnotationMirror annotation) {
        NativeType native_type = NativeTypeTranslator.getAnnotation(annotation, NativeType.class);
        if (native_type != null) {
            return NativeTypeTranslator.getClassFromType((DeclaredType)annotation.getAnnotationType());
        }
        return null;
    }

    private Collection<Class> translateAnnotations() {
        ArrayList<Class> result = new ArrayList<Class>();
        for (AnnotationMirror annotation : Utils.getSortedAnnotations(this.declaration.getAnnotationMirrors())) {
            Class translated_result = NativeTypeTranslator.translateAnnotation(annotation);
            if (translated_result == null) continue;
            result.add(translated_result);
        }
        return result;
    }

    public void visitReferenceType(ReferenceType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitTypeMirror(TypeMirror t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitTypeVariable(TypeVariable t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitVoidType(VoidType t) {
        this.native_types = this.translateAnnotations();
        if (this.native_types.size() == 0) {
            this.native_types.add(Void.TYPE);
        }
    }

    public void visitWildcardType(WildcardType t) {
        throw new RuntimeException(t + " is not allowed");
    }
}

