/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.TypeVisitor;
import java.io.PrintWriter;
import java.nio.Buffer;
import java.util.Collection;
import java.util.Iterator;
import org.lwjgl.util.generator.BufferObject;
import org.lwjgl.util.generator.CachedResult;
import org.lwjgl.util.generator.Check;
import org.lwjgl.util.generator.GenerateAutos;
import org.lwjgl.util.generator.Indirect;
import org.lwjgl.util.generator.JNITypeTranslator;
import org.lwjgl.util.generator.Mode;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.Result;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeMethodStubsGenerator {
    private static final String BUFFER_ADDRESS_POSTFIX = "_address";
    public static final String BUFFER_POSITION_POSTFIX = "_position";

    public static void generateNativeMethodStubs(AnnotationProcessorEnvironment env, TypeMap type_map, PrintWriter writer, InterfaceDeclaration d, boolean generate_error_checks, boolean context_specific) {
        for (MethodDeclaration method : d.getMethods()) {
            NativeMethodStubsGenerator.generateMethodStub(env, type_map, writer, Utils.getQualifiedClassName(d), method, Mode.NORMAL, generate_error_checks, context_specific);
            if (!Utils.hasMethodBufferObjectParameter(method)) continue;
            NativeMethodStubsGenerator.generateMethodStub(env, type_map, writer, Utils.getQualifiedClassName(d), method, Mode.BUFFEROBJECT, generate_error_checks, context_specific);
        }
    }

    private static void generateParameters(PrintWriter writer, Collection<ParameterDeclaration> params, Mode mode) {
        for (ParameterDeclaration param : params) {
            if (param.getAnnotation(Result.class) != null) continue;
            NativeMethodStubsGenerator.generateParameter(writer, param, mode);
        }
    }

    private static void generateParameter(PrintWriter writer, ParameterDeclaration param, Mode mode) {
        writer.print(", ");
        if (mode == Mode.BUFFEROBJECT && param.getAnnotation(BufferObject.class) != null) {
            writer.print("jint " + param.getSimpleName() + "_buffer_offset");
        } else {
            JNITypeTranslator translator = new JNITypeTranslator();
            param.getType().accept((TypeVisitor)translator);
            writer.print(translator.getSignature() + " " + param.getSimpleName());
            if (Utils.getNIOBufferType(param.getType()) != null) {
                writer.print(", jint " + param.getSimpleName() + BUFFER_POSITION_POSTFIX);
            }
        }
    }

    private static void generateMethodStub(AnnotationProcessorEnvironment env, TypeMap type_map, PrintWriter writer, String interface_name, MethodDeclaration method, Mode mode, boolean generate_error_checks, boolean context_specific) {
        TypeMirror result_type = Utils.getMethodReturnType(method);
        JNITypeTranslator translator = new JNITypeTranslator();
        result_type.accept((TypeVisitor)translator);
        if (!context_specific) {
            writer.print("static ");
        } else {
            writer.print("JNIEXPORT ");
        }
        writer.print(translator.getSignature() + " JNICALL ");
        writer.print(Utils.getQualifiedNativeMethodName(interface_name, method, generate_error_checks, context_specific));
        if (mode == Mode.BUFFEROBJECT) {
            writer.print("BO");
        }
        writer.print("(JNIEnv *env, jclass clazz");
        NativeMethodStubsGenerator.generateParameters(writer, method.getParameters(), mode);
        if (Utils.getNIOBufferType(result_type) != null) {
            writer.print(", jint result_size");
            if (method.getAnnotation(CachedResult.class) != null) {
                writer.print(", jobject old_buffer");
            }
        }
        if (context_specific) {
            writer.print(", jlong function_pointer");
        }
        writer.println(") {");
        NativeMethodStubsGenerator.generateBufferParameterAddresses(type_map, writer, method, mode);
        if (context_specific) {
            String typedef_name = Utils.getTypedefName(method);
            writer.print("\t" + typedef_name + " " + method.getSimpleName());
            writer.print(" = (" + typedef_name + ")((intptr_t)");
            writer.println("function_pointer);");
        }
        writer.print("\t");
        if (!result_type.equals(env.getTypeUtils().getVoidType())) {
            ParameterDeclaration result_param = Utils.getResultParameter(method);
            Object return_declaration = result_param != null ? result_param : method;
            NativeTypeTranslator native_translator = new NativeTypeTranslator(type_map, (Declaration)return_declaration);
            result_type.accept((TypeVisitor)native_translator);
            writer.print(native_translator.getSignature() + " " + "__result");
            if (result_param != null) {
                writer.println(";");
                writer.print("\t");
            } else {
                writer.print(" = ");
            }
        }
        writer.print(method.getSimpleName() + "(");
        NativeMethodStubsGenerator.generateCallParameters(writer, method.getParameters());
        writer.print(")");
        writer.println(";");
        NativeMethodStubsGenerator.generateStringDeallocations(writer, method.getParameters());
        if (!result_type.equals(env.getTypeUtils().getVoidType())) {
            writer.print("\treturn ");
            Class java_result_type = Utils.getJavaType(result_type);
            if (Buffer.class.isAssignableFrom(java_result_type)) {
                if (method.getAnnotation(CachedResult.class) != null) {
                    writer.print("safeNewBufferCached(env, ");
                } else {
                    writer.print("safeNewBuffer(env, ");
                }
            } else if (String.class.equals((Object)java_result_type)) {
                writer.print("NewStringNative(env, ");
            }
            writer.print("__result");
            if (Buffer.class.isAssignableFrom(java_result_type)) {
                writer.print(", ");
                Utils.printExtraCallArguments(writer, method, "result_size");
            }
            if (Buffer.class.isAssignableFrom(java_result_type) || String.class.equals((Object)java_result_type)) {
                writer.print(")");
            }
            writer.println(";");
        }
        writer.println("}");
        writer.println();
    }

    private static void generateCallParameters(PrintWriter writer, Collection<ParameterDeclaration> params) {
        if (params.size() > 0) {
            Iterator<ParameterDeclaration> it = params.iterator();
            NativeMethodStubsGenerator.generateCallParameter(writer, it.next());
            while (it.hasNext()) {
                writer.print(", ");
                NativeMethodStubsGenerator.generateCallParameter(writer, it.next());
            }
        }
    }

    private static void generateCallParameter(PrintWriter writer, ParameterDeclaration param) {
        if (param.getAnnotation(Result.class) != null || param.getAnnotation(Indirect.class) != null) {
            writer.print("&");
        }
        if (param.getAnnotation(Result.class) != null) {
            writer.print("__result");
        } else {
            writer.print(param.getSimpleName());
            if (Utils.isAddressableType(param.getType())) {
                writer.print(BUFFER_ADDRESS_POSTFIX);
            }
        }
    }

    private static void generateStringDeallocations(PrintWriter writer, Collection<ParameterDeclaration> params) {
        for (ParameterDeclaration param : params) {
            if (!Utils.getJavaType(param.getType()).equals(String.class) || param.getAnnotation(Result.class) != null) continue;
            writer.println("\tfree(" + param.getSimpleName() + BUFFER_ADDRESS_POSTFIX + ");");
        }
    }

    private static void generateBufferParameterAddresses(TypeMap type_map, PrintWriter writer, MethodDeclaration method, Mode mode) {
        for (ParameterDeclaration param : method.getParameters()) {
            if (!Utils.isAddressableType(param.getType()) || param.getAnnotation(Result.class) != null) continue;
            NativeMethodStubsGenerator.generateBufferParameterAddress(type_map, writer, method, param, mode);
        }
    }

    private static void generateBufferParameterAddress(TypeMap type_map, PrintWriter writer, MethodDeclaration method, ParameterDeclaration param, Mode mode) {
        NativeTypeTranslator translator = new NativeTypeTranslator(type_map, (Declaration)param);
        param.getType().accept((TypeVisitor)translator);
        writer.print("\t" + translator.getSignature() + param.getSimpleName());
        writer.print("_address = ((");
        writer.print(translator.getSignature());
        Check check_annotation = (Check)param.getAnnotation(Check.class);
        writer.print(")");
        if (mode == Mode.BUFFEROBJECT && param.getAnnotation(BufferObject.class) != null) {
            writer.print("offsetToPointer(" + param.getSimpleName() + "_buffer_offset" + "))");
        } else {
            Class java_type = Utils.getJavaType(param.getType());
            if (Buffer.class.isAssignableFrom(java_type)) {
                boolean explicitly_byte_sized = java_type.equals(Buffer.class);
                if (explicitly_byte_sized) {
                    writer.print("(((char *)");
                }
                if (method.getAnnotation(GenerateAutos.class) != null || check_annotation != null && check_annotation.canBeNull()) {
                    writer.print("safeGetBufferAddress(env, " + param.getSimpleName());
                } else {
                    writer.print("(*env)->GetDirectBufferAddress(env, " + param.getSimpleName());
                }
                writer.print("))");
                writer.print(" + " + param.getSimpleName() + BUFFER_POSITION_POSTFIX);
                if (explicitly_byte_sized) {
                    writer.print("))");
                }
            } else if (java_type.equals(String.class)) {
                writer.print("GetStringNativeChars(env, " + param.getSimpleName() + "))");
            } else {
                throw new RuntimeException("Illegal type " + java_type);
            }
        }
        writer.println(";");
    }
}

