/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.EnumType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.TypeVisitor;
import org.lwjgl.util.generator.NativeTypeTranslator;

public class JavaTypeTranslator
implements TypeVisitor {
    private Class type;

    public Class getType() {
        return this.type;
    }

    public void visitAnnotationType(AnnotationType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitArrayType(ArrayType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitPrimitiveType(PrimitiveType t) {
        switch (t.getKind()) {
            case INT: {
                this.type = Integer.TYPE;
                break;
            }
            case DOUBLE: {
                this.type = Double.TYPE;
                break;
            }
            case FLOAT: {
                this.type = Float.TYPE;
                break;
            }
            case SHORT: {
                this.type = Short.TYPE;
                break;
            }
            case BYTE: {
                this.type = Byte.TYPE;
                break;
            }
            case BOOLEAN: {
                this.type = Boolean.TYPE;
                break;
            }
            default: {
                throw new RuntimeException(t.getKind() + " is not allowed");
            }
        }
    }

    public void visitDeclaredType(DeclaredType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitEnumType(EnumType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitClassType(ClassType t) {
        this.type = NativeTypeTranslator.getClassFromType((DeclaredType)t);
    }

    public void visitInterfaceType(InterfaceType t) {
        this.type = NativeTypeTranslator.getClassFromType((DeclaredType)t);
    }

    public void visitReferenceType(ReferenceType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitTypeMirror(TypeMirror t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitTypeVariable(TypeVariable t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitVoidType(VoidType t) {
        this.type = Void.TYPE;
    }

    public void visitWildcardType(WildcardType t) {
        throw new RuntimeException(t + " is not allowed");
    }
}

