/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.TypeVisitor;
import java.io.PrintWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.lwjgl.util.generator.AutoSize;
import org.lwjgl.util.generator.AutoType;
import org.lwjgl.util.generator.BufferKind;
import org.lwjgl.util.generator.BufferObject;
import org.lwjgl.util.generator.CachedReference;
import org.lwjgl.util.generator.CachedResult;
import org.lwjgl.util.generator.Check;
import org.lwjgl.util.generator.Code;
import org.lwjgl.util.generator.Constant;
import org.lwjgl.util.generator.Extension;
import org.lwjgl.util.generator.GenerateAutos;
import org.lwjgl.util.generator.Mode;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.NoErrorCheck;
import org.lwjgl.util.generator.NullTerminated;
import org.lwjgl.util.generator.PostfixTranslator;
import org.lwjgl.util.generator.Result;
import org.lwjgl.util.generator.Signedness;
import org.lwjgl.util.generator.StripPostfix;
import org.lwjgl.util.generator.TypeInfo;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethodsGenerator {
    public static void generateMethodsJava(AnnotationProcessorEnvironment env, TypeMap type_map, PrintWriter writer, InterfaceDeclaration interface_decl, boolean generate_error_checks, boolean context_specific) {
        for (MethodDeclaration method : interface_decl.getMethods()) {
            JavaMethodsGenerator.generateMethodJava(env, type_map, writer, interface_decl, method, generate_error_checks, context_specific);
        }
    }

    private static void generateMethodJava(AnnotationProcessorEnvironment env, TypeMap type_map, PrintWriter writer, InterfaceDeclaration interface_decl, MethodDeclaration method, boolean generate_error_checks, boolean context_specific) {
        writer.println();
        if (Utils.isMethodIndirect(generate_error_checks, context_specific, method)) {
            if (method.getAnnotation(GenerateAutos.class) != null) {
                JavaMethodsGenerator.printMethodWithMultiType(env, type_map, writer, interface_decl, method, TypeInfo.getDefaultTypeInfoMap(method), Mode.AUTOS, generate_error_checks, context_specific);
            }
            Collection<Map<ParameterDeclaration, TypeInfo>> cross_product = TypeInfo.getTypeInfoCrossProduct(type_map, method);
            for (Map<ParameterDeclaration, TypeInfo> typeinfos_instance : cross_product) {
                JavaMethodsGenerator.printMethodWithMultiType(env, type_map, writer, interface_decl, method, typeinfos_instance, Mode.NORMAL, generate_error_checks, context_specific);
            }
        }
        JavaMethodsGenerator.printJavaNativeStub(writer, method, Mode.NORMAL, generate_error_checks, context_specific);
        if (Utils.hasMethodBufferObjectParameter(method)) {
            JavaMethodsGenerator.printMethodWithMultiType(env, type_map, writer, interface_decl, method, TypeInfo.getDefaultTypeInfoMap(method), Mode.BUFFEROBJECT, generate_error_checks, context_specific);
            JavaMethodsGenerator.printJavaNativeStub(writer, method, Mode.BUFFEROBJECT, generate_error_checks, context_specific);
        }
    }

    private static void printJavaNativeStub(PrintWriter writer, MethodDeclaration method, Mode mode, boolean generate_error_checks, boolean context_specific) {
        if (Utils.isMethodIndirect(generate_error_checks, context_specific, method)) {
            writer.print("\tprivate static native ");
        } else {
            Utils.printDocComment(writer, (Declaration)method);
            writer.print("\tpublic static native ");
        }
        JavaMethodsGenerator.printResultType(writer, method);
        writer.print(" " + Utils.getSimpleNativeMethodName(method, generate_error_checks, context_specific));
        if (mode == Mode.BUFFEROBJECT) {
            writer.print("BO");
        }
        writer.print("(");
        boolean first_parameter = JavaMethodsGenerator.generateParametersJava(writer, method, TypeInfo.getDefaultTypeInfoMap(method), true, mode);
        if (context_specific) {
            if (!first_parameter) {
                writer.print(", ");
            }
            writer.print("long function_pointer");
        }
        writer.println(");");
    }

    private static boolean generateParametersJava(PrintWriter writer, MethodDeclaration method, Map<ParameterDeclaration, TypeInfo> typeinfos_instance, boolean native_stub, Mode mode) {
        boolean first_parameter = true;
        for (ParameterDeclaration param : method.getParameters()) {
            boolean hide_auto_parameter;
            AnnotationMirror auto_annotation_mirror = Utils.getParameterAutoAnnotation(param);
            boolean bl = hide_auto_parameter = mode == Mode.NORMAL && !native_stub && auto_annotation_mirror != null;
            if (hide_auto_parameter) {
                ParameterDeclaration auto_parameter;
                TypeInfo auto_param_type_info;
                AutoType auto_type_annotation = (AutoType)param.getAnnotation(AutoType.class);
                if (auto_type_annotation == null || (auto_param_type_info = typeinfos_instance.get(auto_parameter = Utils.findParameter(method, auto_type_annotation.value()))).getSignedness() != Signedness.BOTH) continue;
                if (!first_parameter) {
                    writer.print(", ");
                }
                first_parameter = false;
                writer.print("boolean unsigned");
                continue;
            }
            if (param.getAnnotation(Result.class) != null || !native_stub && param.getAnnotation(Constant.class) != null || JavaMethodsGenerator.getAutoTypeParameter(method, param) != null && mode == Mode.AUTOS) continue;
            TypeInfo type_info = typeinfos_instance.get(param);
            first_parameter = JavaMethodsGenerator.generateParameterJava(writer, param, type_info, native_stub, first_parameter, mode);
        }
        TypeMirror result_type = Utils.getMethodReturnType(method);
        if (native_stub && Utils.getNIOBufferType(result_type) != null || Utils.needResultSize(method)) {
            if (!first_parameter) {
                writer.print(", ");
            }
            first_parameter = false;
            writer.print("int result_size");
            if (method.getAnnotation(CachedResult.class) != null) {
                writer.print(", ");
                JavaMethodsGenerator.printResultType(writer, method);
                writer.print(" old_buffer");
            }
        }
        return first_parameter;
    }

    private static boolean generateParameterJava(PrintWriter writer, ParameterDeclaration param, TypeInfo type_info, boolean native_stub, boolean first_parameter, Mode mode) {
        BufferObject bo_annotation;
        Class<?> buffer_type = Utils.getNIOBufferType(param.getType());
        if (!first_parameter) {
            writer.print(", ");
        }
        if ((bo_annotation = (BufferObject)param.getAnnotation(BufferObject.class)) != null && mode == Mode.BUFFEROBJECT) {
            if (buffer_type == null) {
                throw new RuntimeException("type of " + param + " is not a nio Buffer parameter but is annotated as buffer object");
            }
            writer.print("int " + param.getSimpleName() + "_buffer_offset");
        } else {
            writer.print(type_info.getType().getSimpleName());
            writer.print(" " + param.getSimpleName());
            if (buffer_type != null && native_stub) {
                writer.print(", int " + param.getSimpleName() + "_position");
            }
        }
        return false;
    }

    private static void printBufferObjectCheck(PrintWriter writer, BufferKind kind, Mode mode) {
        String bo_check_method_name = kind.toString();
        writer.print("\t\tGLChecks.ensure" + bo_check_method_name);
        if (mode == Mode.BUFFEROBJECT) {
            writer.print("enabled");
        } else {
            writer.print("disabled");
        }
        writer.println("();");
    }

    private static void printBufferObjectChecks(PrintWriter writer, MethodDeclaration method, Mode mode) {
        EnumSet<BufferKind> check_set = EnumSet.noneOf(BufferKind.class);
        for (ParameterDeclaration param : method.getParameters()) {
            BufferObject bo_annotation = (BufferObject)param.getAnnotation(BufferObject.class);
            if (bo_annotation == null) continue;
            check_set.add(bo_annotation.value());
        }
        for (BufferKind kind : check_set) {
            JavaMethodsGenerator.printBufferObjectCheck(writer, kind, mode);
        }
    }

    private static void printMethodWithMultiType(AnnotationProcessorEnvironment env, TypeMap type_map, PrintWriter writer, InterfaceDeclaration interface_decl, MethodDeclaration method, Map<ParameterDeclaration, TypeInfo> typeinfos_instance, Mode mode, boolean generate_error_checks, boolean context_specific) {
        boolean has_result;
        Utils.printDocComment(writer, (Declaration)method);
        writer.print("\tpublic static ");
        JavaMethodsGenerator.printResultType(writer, method);
        StripPostfix strip_annotation = (StripPostfix)method.getAnnotation(StripPostfix.class);
        String method_name = method.getSimpleName();
        if (strip_annotation != null && mode == Mode.NORMAL) {
            method_name = JavaMethodsGenerator.getPostfixStrippedName(type_map, interface_decl, method);
        }
        writer.print(" " + method_name + "(");
        JavaMethodsGenerator.generateParametersJava(writer, method, typeinfos_instance, false, mode);
        TypeMirror result_type = Utils.getMethodReturnType(method);
        writer.println(") {");
        Code code_annotation = (Code)method.getAnnotation(Code.class);
        if (code_annotation != null) {
            writer.println(code_annotation.value());
        }
        if (context_specific) {
            writer.print("\t\tlong function_pointer = GLContext.getCapabilities().");
            writer.println(Utils.getFunctionAddressName(interface_decl, method) + ";");
            writer.print("\t\tBufferChecks.checkFunctionAddress(");
            writer.println("function_pointer);");
        }
        JavaMethodsGenerator.printBufferObjectChecks(writer, method, mode);
        JavaMethodsGenerator.printParameterChecks(writer, method, mode);
        JavaMethodsGenerator.printParameterCaching(writer, interface_decl, method, mode);
        writer.print("\t\t");
        boolean bl = has_result = !result_type.equals(env.getTypeUtils().getVoidType());
        if (has_result) {
            JavaMethodsGenerator.printResultType(writer, method);
            writer.print(" __result = ");
        }
        writer.print(Utils.getSimpleNativeMethodName(method, generate_error_checks, context_specific));
        if (mode == Mode.BUFFEROBJECT) {
            writer.print("BO");
        }
        writer.print("(");
        boolean first_parameter = JavaMethodsGenerator.printMethodCallArguments(writer, method, typeinfos_instance, mode);
        if (context_specific) {
            if (!first_parameter) {
                writer.print(", ");
            }
            writer.print("function_pointer");
        }
        writer.println(");");
        if (generate_error_checks && method.getAnnotation(NoErrorCheck.class) == null) {
            writer.println("\t\t" + type_map.getErrorCheckMethodName() + ";");
        }
        if (has_result) {
            writer.println("\t\treturn __result;");
        }
        writer.println("\t}");
    }

    private static String getExtensionPostfix(InterfaceDeclaration interface_decl) {
        String interface_simple_name = interface_decl.getSimpleName();
        Extension extension_annotation = (Extension)interface_decl.getAnnotation(Extension.class);
        if (extension_annotation == null) {
            int underscore_index = interface_simple_name.indexOf("_");
            if (underscore_index != -1) {
                return interface_simple_name.substring(0, underscore_index);
            }
            return "";
        }
        return extension_annotation.postfix();
    }

    private static ParameterDeclaration getAutoTypeParameter(MethodDeclaration method, ParameterDeclaration target_parameter) {
        for (ParameterDeclaration param : method.getParameters()) {
            String parameter_name;
            AnnotationMirror auto_annotation = Utils.getParameterAutoAnnotation(param);
            if (auto_annotation == null) continue;
            Class<?> annotation_type = NativeTypeTranslator.getClassFromType((DeclaredType)auto_annotation.getAnnotationType());
            if (annotation_type.equals(AutoType.class)) {
                parameter_name = ((AutoType)param.getAnnotation(AutoType.class)).value();
            } else if (annotation_type.equals(AutoSize.class)) {
                parameter_name = ((AutoSize)param.getAnnotation(AutoSize.class)).value();
            } else {
                throw new RuntimeException("Unkown annotation type " + annotation_type);
            }
            if (!target_parameter.getSimpleName().equals(parameter_name)) continue;
            return param;
        }
        return null;
    }

    private static boolean hasAnyParameterAutoTypeAnnotation(MethodDeclaration method, ParameterDeclaration target_param) {
        for (ParameterDeclaration param : method.getParameters()) {
            ParameterDeclaration type_target_param;
            AutoType auto_type_annotation = (AutoType)param.getAnnotation(AutoType.class);
            if (auto_type_annotation == null || !target_param.equals(type_target_param = Utils.findParameter(method, auto_type_annotation.value()))) continue;
            return true;
        }
        return false;
    }

    private static String getPostfixStrippedName(TypeMap type_map, InterfaceDeclaration interface_decl, MethodDeclaration method) {
        String result;
        StripPostfix strip_annotation = (StripPostfix)method.getAnnotation(StripPostfix.class);
        ParameterDeclaration postfix_parameter = Utils.findParameter(method, strip_annotation.value());
        PostfixTranslator translator = new PostfixTranslator(type_map, (Declaration)postfix_parameter);
        postfix_parameter.getType().accept((TypeVisitor)translator);
        String postfix = translator.getSignature();
        String method_name = method.getSimpleName();
        String extension_postfix = JavaMethodsGenerator.getExtensionPostfix(interface_decl);
        if (method_name.endsWith(postfix + "v" + extension_postfix)) {
            result = method_name.substring(0, method_name.length() - (postfix.length() + 1 + extension_postfix.length()));
        } else if (method_name.endsWith(postfix + extension_postfix)) {
            result = method_name.substring(0, method_name.length() - (postfix.length() + extension_postfix.length()));
        } else if (method_name.endsWith("v" + extension_postfix)) {
            result = method_name.substring(0, method_name.length() - (1 + extension_postfix.length()));
        } else {
            throw new RuntimeException(method + " is specified as being postfix stripped on parameter " + postfix_parameter + ", but it's postfix is not '" + postfix + "' nor 'v'");
        }
        return result + extension_postfix;
    }

    private static int getBufferElementSizeExponent(Class c) {
        if (IntBuffer.class.equals((Object)c)) {
            return 2;
        }
        if (LongBuffer.class.equals((Object)c)) {
            return 3;
        }
        if (DoubleBuffer.class.equals((Object)c)) {
            return 3;
        }
        if (ShortBuffer.class.equals((Object)c)) {
            return 1;
        }
        if (ByteBuffer.class.equals((Object)c)) {
            return 0;
        }
        if (FloatBuffer.class.equals((Object)c)) {
            return 2;
        }
        throw new RuntimeException(c + " is not allowed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean printMethodCallArgument(PrintWriter writer, MethodDeclaration method, ParameterDeclaration param, Map<ParameterDeclaration, TypeInfo> typeinfos_instance, Mode mode, boolean first_parameter) {
        if (!first_parameter) {
            writer.print(", ");
        }
        AnnotationMirror auto_annotation = Utils.getParameterAutoAnnotation(param);
        Constant constant_annotation = (Constant)param.getAnnotation(Constant.class);
        if (constant_annotation != null) {
            writer.print(constant_annotation.value());
            return false;
        } else if (auto_annotation != null && mode == Mode.NORMAL) {
            Class<?> param_type = NativeTypeTranslator.getClassFromType((DeclaredType)auto_annotation.getAnnotationType());
            if (AutoType.class.equals(param_type)) {
                AutoType auto_type_annotation = (AutoType)param.getAnnotation(AutoType.class);
                String auto_parameter_name = auto_type_annotation.value();
                ParameterDeclaration auto_parameter = Utils.findParameter(method, auto_parameter_name);
                String auto_type = typeinfos_instance.get(auto_parameter).getAutoType();
                if (auto_type == null) {
                    throw new RuntimeException("No auto type for parameter " + param.getSimpleName() + " in method " + method);
                }
                writer.print(auto_type);
                return false;
            } else {
                int shifting;
                boolean shift_remaining;
                if (!AutoSize.class.equals(param_type)) throw new RuntimeException("Unknown auto annotation " + param_type);
                AutoSize auto_type_annotation = (AutoSize)param.getAnnotation(AutoSize.class);
                String auto_parameter_name = auto_type_annotation.value();
                ParameterDeclaration auto_target_param = Utils.findParameter(method, auto_parameter_name);
                TypeInfo auto_target_type_info = typeinfos_instance.get(auto_target_param);
                writer.print("(" + auto_parameter_name + ".remaining()");
                boolean bl = shift_remaining = !JavaMethodsGenerator.hasAnyParameterAutoTypeAnnotation(method, auto_target_param) && Utils.isParameterMultiTyped(auto_target_param);
                if (shift_remaining && (shifting = JavaMethodsGenerator.getBufferElementSizeExponent(auto_target_type_info.getType())) > 0) {
                    writer.print(" << " + shifting);
                }
                writer.print(")");
                writer.print(auto_type_annotation.expression());
            }
            return false;
        } else if (mode == Mode.BUFFEROBJECT && param.getAnnotation(BufferObject.class) != null) {
            writer.print(param.getSimpleName() + "_buffer_offset");
            return false;
        } else {
            boolean hide_buffer;
            boolean bl = hide_buffer = mode == Mode.AUTOS && JavaMethodsGenerator.getAutoTypeParameter(method, param) != null;
            if (hide_buffer) {
                writer.print("null");
            } else {
                writer.print(param.getSimpleName());
            }
            Class<?> buffer_type = Utils.getNIOBufferType(param.getType());
            if (buffer_type == null) return false;
            writer.print(", ");
            if (!hide_buffer) {
                TypeInfo type_info = typeinfos_instance.get(param);
                Check check_annotation = (Check)param.getAnnotation(Check.class);
                int shifting = Utils.getNIOBufferType(param.getType()).equals(Buffer.class) ? JavaMethodsGenerator.getBufferElementSizeExponent(type_info.getType()) : 0;
                writer.print(param.getSimpleName());
                if (check_annotation != null && check_annotation.canBeNull()) {
                    writer.print(" != null ? " + param.getSimpleName());
                }
                writer.print(".position()");
                if (shifting > 0) {
                    writer.print(" << " + shifting);
                }
                if (check_annotation == null || !check_annotation.canBeNull()) return false;
                writer.print(" : 0");
                return false;
            } else {
                writer.print("0");
            }
        }
        return false;
    }

    private static boolean printMethodCallArguments(PrintWriter writer, MethodDeclaration method, Map<ParameterDeclaration, TypeInfo> typeinfos_instance, Mode mode) {
        boolean first_parameter = true;
        for (ParameterDeclaration param : method.getParameters()) {
            if (param.getAnnotation(Result.class) != null) continue;
            first_parameter = JavaMethodsGenerator.printMethodCallArgument(writer, method, param, typeinfos_instance, mode, first_parameter);
        }
        if (Utils.getNIOBufferType(Utils.getMethodReturnType(method)) != null) {
            if (!first_parameter) {
                writer.print(", ");
            }
            first_parameter = false;
            ParameterDeclaration auto_result_size_parameter = Utils.getAutoResultSizeParameter(method);
            String result_size_parameter_name = auto_result_size_parameter == null ? "result_size" : auto_result_size_parameter.getSimpleName();
            Utils.printExtraCallArguments(writer, method, result_size_parameter_name);
        }
        return first_parameter;
    }

    private static void printParameterCaching(PrintWriter writer, InterfaceDeclaration interface_decl, MethodDeclaration method, Mode mode) {
        for (ParameterDeclaration param : method.getParameters()) {
            Class java_type = Utils.getJavaType(param.getType());
            if (!Buffer.class.isAssignableFrom(java_type) || param.getAnnotation(CachedReference.class) == null || mode == Mode.BUFFEROBJECT && param.getAnnotation(BufferObject.class) != null || param.getAnnotation(Result.class) != null) continue;
            writer.print("\t\tGLChecks.getReferences().");
            writer.print(Utils.getReferenceName(interface_decl, method, param) + " = ");
            writer.println(param.getSimpleName() + ";");
        }
    }

    private static void printParameterChecks(PrintWriter writer, MethodDeclaration method, Mode mode) {
        for (ParameterDeclaration param : method.getParameters()) {
            boolean null_terminated;
            Class java_type = Utils.getJavaType(param.getType());
            if (!Utils.isAddressableType(java_type) || mode == Mode.BUFFEROBJECT && param.getAnnotation(BufferObject.class) != null || mode == Mode.AUTOS && JavaMethodsGenerator.getAutoTypeParameter(method, param) != null || param.getAnnotation(Result.class) != null) continue;
            String check_value = null;
            boolean can_be_null = false;
            Check check_annotation = (Check)param.getAnnotation(Check.class);
            if (check_annotation != null) {
                check_value = check_annotation.value();
                can_be_null = check_annotation.canBeNull();
            }
            boolean bl = null_terminated = param.getAnnotation(NullTerminated.class) != null;
            if (Buffer.class.isAssignableFrom(java_type)) {
                JavaMethodsGenerator.printParameterCheck(writer, param.getSimpleName(), check_value, can_be_null, null_terminated);
                continue;
            }
            if (!String.class.equals((Object)java_type) || can_be_null) continue;
            writer.println("\t\tBufferChecks.checkNotNull(" + param.getSimpleName() + ");");
        }
        if (method.getAnnotation(CachedResult.class) != null) {
            JavaMethodsGenerator.printParameterCheck(writer, "old_buffer", null, true, false);
        }
    }

    private static void printParameterCheck(PrintWriter writer, String name, String check_value, boolean can_be_null, boolean null_terminated) {
        if (can_be_null) {
            writer.println("\t\tif (" + name + " != null)");
            writer.print("\t");
        }
        writer.print("\t\tBufferChecks.check");
        if (check_value != null && !"".equals(check_value)) {
            writer.print("Buffer(" + name + ", " + check_value);
        } else {
            writer.print("Direct");
            writer.print("(" + name);
        }
        writer.println(");");
        if (null_terminated) {
            writer.println("\t\tBufferChecks.checkNullTerminated(" + name + ");");
        }
    }

    private static void printResultType(PrintWriter writer, MethodDeclaration method) {
        writer.print(Utils.getMethodReturnType(method).toString());
    }
}

