/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.EnumType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.TypeVisitor;

public class JNITypeTranslator
implements TypeVisitor {
    private final StringBuilder signature = new StringBuilder();

    public String getSignature() {
        return this.signature.toString();
    }

    public void visitAnnotationType(AnnotationType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitArrayType(ArrayType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitClassType(ClassType t) {
        this.signature.append("jobject");
    }

    public void visitDeclaredType(DeclaredType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitEnumType(EnumType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitInterfaceType(InterfaceType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitPrimitiveType(PrimitiveType t) {
        String type;
        switch (t.getKind()) {
            case INT: {
                type = "jint";
                break;
            }
            case FLOAT: {
                type = "jfloat";
                break;
            }
            case SHORT: {
                type = "jshort";
                break;
            }
            case BYTE: {
                type = "jbyte";
                break;
            }
            case DOUBLE: {
                type = "jdouble";
                break;
            }
            case BOOLEAN: {
                type = "jboolean";
                break;
            }
            default: {
                throw new RuntimeException(t + " is not allowed");
            }
        }
        this.signature.append(type);
    }

    public void visitReferenceType(ReferenceType t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitTypeMirror(TypeMirror t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitTypeVariable(TypeVariable t) {
        throw new RuntimeException(t + " is not allowed");
    }

    public void visitVoidType(VoidType t) {
        this.signature.append(t.toString());
    }

    public void visitWildcardType(WildcardType t) {
        throw new RuntimeException(t + " is not allowed");
    }
}

