/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.Buffer;
import java.util.Collection;
import org.lwjgl.util.generator.AutoSize;
import org.lwjgl.util.generator.BufferObject;
import org.lwjgl.util.generator.CachedReference;
import org.lwjgl.util.generator.CachedResult;
import org.lwjgl.util.generator.Check;
import org.lwjgl.util.generator.Constant;
import org.lwjgl.util.generator.FieldsGenerator;
import org.lwjgl.util.generator.JavaMethodsGenerator;
import org.lwjgl.util.generator.NativeMethodStubsGenerator;
import org.lwjgl.util.generator.NativeType;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.NullTerminated;
import org.lwjgl.util.generator.RegisterStubsGenerator;
import org.lwjgl.util.generator.Result;
import org.lwjgl.util.generator.StripPostfix;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.TypedefsGenerator;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorVisitor
extends SimpleDeclarationVisitor {
    private final AnnotationProcessorEnvironment env;
    private final TypeMap type_map;
    private final boolean generate_error_checks;
    private final boolean context_specific;

    public GeneratorVisitor(AnnotationProcessorEnvironment env, TypeMap type_map, boolean generate_error_checks, boolean context_specific) {
        this.env = env;
        this.type_map = type_map;
        this.generate_error_checks = generate_error_checks;
        this.context_specific = context_specific;
    }

    private void validateMethods(InterfaceDeclaration d) {
        for (MethodDeclaration method : d.getMethods()) {
            this.validateMethod(method);
        }
    }

    private void validateMethod(MethodDeclaration method) {
        if (method.isVarArgs()) {
            throw new RuntimeException("Method " + method.getSimpleName() + " is variadic");
        }
        Collection modifiers = method.getModifiers();
        if (!modifiers.contains(Modifier.PUBLIC)) {
            throw new RuntimeException("Method " + method.getSimpleName() + " is not public");
        }
        if (method.getThrownTypes().size() > 0) {
            throw new RuntimeException("Method " + method.getSimpleName() + " throws checked exceptions");
        }
        this.validateParameters(method);
        StripPostfix strip_annotation = (StripPostfix)method.getAnnotation(StripPostfix.class);
        if (strip_annotation != null) {
            String postfix_param_name = strip_annotation.value();
            ParameterDeclaration postfix_param = Utils.findParameter(method, postfix_param_name);
            if (Utils.isParameterMultiTyped(postfix_param)) {
                throw new RuntimeException("Postfix parameter can't be the same as a multityped parameter in method " + method);
            }
            if (Utils.getNIOBufferType(postfix_param.getType()) == null) {
                throw new RuntimeException("Postfix parameter type must be a nio Buffer");
            }
        }
        if (Utils.getResultParameter(method) != null && !method.getReturnType().equals(this.env.getTypeUtils().getVoidType())) {
            throw new RuntimeException(method + " return type is not void but a parameter is annotated with Result");
        }
        if (method.getAnnotation(CachedResult.class) != null && Utils.getNIOBufferType(Utils.getMethodReturnType(method)) == null) {
            throw new RuntimeException(method + " return type is not a Buffer, but is annotated with CachedResult");
        }
        this.validateTypes(method, method.getAnnotationMirrors(), method.getReturnType());
    }

    private void validateType(MethodDeclaration method, Class annotation_type, Class type) {
        Class[] valid_types = this.type_map.getValidAnnotationTypes(type);
        for (int i = 0; i < valid_types.length; ++i) {
            if (!valid_types[i].equals(annotation_type)) continue;
            return;
        }
        throw new RuntimeException(type + " is annotated with invalid native type " + annotation_type + " in method " + method);
    }

    private void validateTypes(MethodDeclaration method, Collection<AnnotationMirror> annotations, TypeMirror type_mirror) {
        for (AnnotationMirror annotation : annotations) {
            NativeType native_type_annotation = NativeTypeTranslator.getAnnotation(annotation, NativeType.class);
            if (native_type_annotation == null) continue;
            Class<?> annotation_type = NativeTypeTranslator.getClassFromType((DeclaredType)annotation.getAnnotationType());
            Class type = Utils.getJavaType(type_mirror);
            if (Buffer.class.equals((Object)type)) continue;
            this.validateType(method, annotation_type, type);
        }
    }

    private void validateParameters(MethodDeclaration method) {
        for (ParameterDeclaration param : method.getParameters()) {
            this.validateTypes(method, param.getAnnotationMirrors(), param.getType());
            if (Utils.getNIOBufferType(param.getType()) != null) {
                Check parameter_check_annotation = (Check)param.getAnnotation(Check.class);
                NullTerminated null_terminated_annotation = (NullTerminated)param.getAnnotation(NullTerminated.class);
                if (parameter_check_annotation == null && null_terminated_annotation == null) {
                    boolean found_auto_size_param = false;
                    for (ParameterDeclaration inner_param : method.getParameters()) {
                        AutoSize auto_size_annotation = (AutoSize)inner_param.getAnnotation(AutoSize.class);
                        if (auto_size_annotation == null || !auto_size_annotation.value().equals(param.getSimpleName())) continue;
                        found_auto_size_param = true;
                        break;
                    }
                    if (!found_auto_size_param && param.getAnnotation(Result.class) == null) {
                        throw new RuntimeException(param + " has no Check, Result nor Constant annotation and no other parameters has" + " an @AutoSize annotation on it in method " + method);
                    }
                }
                if (param.getAnnotation(CachedReference.class) != null && param.getAnnotation(Result.class) != null) {
                    throw new RuntimeException(param + " can't be annotated with both CachedReference and Result");
                }
                if (param.getAnnotation(BufferObject.class) != null && param.getAnnotation(Result.class) != null) {
                    throw new RuntimeException(param + " can't be annotated with both BufferObject and Result");
                }
                if (param.getAnnotation(Constant.class) == null) continue;
                throw new RuntimeException("Buffer parameter " + param + " cannot be Constant");
            }
            if (param.getAnnotation(BufferObject.class) != null) {
                throw new RuntimeException(param + " type is not a buffer, but annotated as a BufferObject");
            }
            if (param.getAnnotation(CachedReference.class) == null) continue;
            throw new RuntimeException(param + " type is not a buffer, but annotated as a CachedReference");
        }
    }

    private static void generateMethodsNativePointers(PrintWriter writer, Collection<? extends MethodDeclaration> methods) {
        for (MethodDeclaration methodDeclaration : methods) {
            GeneratorVisitor.generateMethodNativePointers(writer, methodDeclaration);
        }
    }

    private static void generateMethodNativePointers(PrintWriter writer, MethodDeclaration method) {
        writer.println("static " + Utils.getTypedefName(method) + " " + method.getSimpleName() + ";");
    }

    private void generateJavaSource(InterfaceDeclaration d) throws IOException {
        this.validateMethods(d);
        PrintWriter java_writer = this.env.getFiler().createTextFile(Filer.Location.SOURCE_TREE, d.getPackage().getQualifiedName(), new File(Utils.getSimpleClassName(d) + ".java"), null);
        java_writer.println("/* MACHINE GENERATED FILE, DO NOT EDIT */");
        java_writer.println();
        java_writer.println("package " + d.getPackage().getQualifiedName() + ";");
        java_writer.println();
        java_writer.println("import org.lwjgl.LWJGLException;");
        java_writer.println("import org.lwjgl.BufferChecks;");
        java_writer.println("import java.nio.*;");
        java_writer.println();
        java_writer.print("public ");
        boolean is_final = Utils.isFinal(d);
        if (is_final) {
            java_writer.write("final ");
        }
        java_writer.print("class " + Utils.getSimpleClassName(d));
        Collection super_interfaces = d.getSuperinterfaces();
        if (super_interfaces.size() > 1) {
            throw new RuntimeException(d + " extends more than one interface");
        }
        if (super_interfaces.size() == 1) {
            InterfaceDeclaration super_interface = ((InterfaceType)super_interfaces.iterator().next()).getDeclaration();
            java_writer.print(" extends " + Utils.getSimpleClassName(super_interface));
        }
        java_writer.println(" {");
        FieldsGenerator.generateFields(java_writer, d.getFields());
        java_writer.println();
        if (is_final) {
            java_writer.println("\tprivate " + Utils.getSimpleClassName(d) + "() {");
            java_writer.println("\t}");
            java_writer.println();
        }
        if (d.getMethods().size() > 0 && !this.context_specific) {
            java_writer.println("\tstatic native void initNativeStubs() throws LWJGLException;");
        }
        JavaMethodsGenerator.generateMethodsJava(this.env, this.type_map, java_writer, d, this.generate_error_checks, this.context_specific);
        java_writer.println("}");
        java_writer.close();
        String qualified_interface_name = Utils.getQualifiedClassName(d);
        this.env.getMessager().printNotice("Generated class " + qualified_interface_name);
    }

    private void generateNativeSource(InterfaceDeclaration d) throws IOException {
        String qualified_interface_name = Utils.getQualifiedClassName(d);
        String qualified_native_name = Utils.getNativeQualifiedName(qualified_interface_name) + ".c";
        PrintWriter native_writer = this.env.getFiler().createTextFile(Filer.Location.CLASS_TREE, "", new File(qualified_native_name), "UTF-8");
        native_writer.println("/* MACHINE GENERATED FILE, DO NOT EDIT */");
        native_writer.println();
        native_writer.println("#include <jni.h>");
        this.type_map.printNativeIncludes(native_writer);
        native_writer.println();
        TypedefsGenerator.generateNativeTypedefs(this.type_map, native_writer, d.getMethods());
        native_writer.println();
        if (!this.context_specific) {
            GeneratorVisitor.generateMethodsNativePointers(native_writer, d.getMethods());
            native_writer.println();
        }
        NativeMethodStubsGenerator.generateNativeMethodStubs(this.env, this.type_map, native_writer, d, this.generate_error_checks, this.context_specific);
        if (!this.context_specific) {
            native_writer.print("JNIEXPORT void JNICALL " + Utils.getQualifiedNativeMethodName(qualified_interface_name, "initNativeStubs"));
            native_writer.println("(JNIEnv *env, jclass clazz) {");
            native_writer.println("\tJavaMethodAndExtFunction functions[] = {");
            RegisterStubsGenerator.generateMethodsNativeStubBind(native_writer, d, this.generate_error_checks, this.context_specific);
            native_writer.println("\t};");
            native_writer.println("\tint num_functions = NUMFUNCTIONS(functions);");
            native_writer.print("\t");
            native_writer.print(this.type_map.getRegisterNativesFunctionName());
            native_writer.println("(env, clazz, num_functions, functions);");
            native_writer.println("}");
        }
        native_writer.close();
        this.env.getMessager().printNotice("Generated C source " + qualified_interface_name);
    }

    public void visitInterfaceDeclaration(InterfaceDeclaration d) {
        try {
            if (d.getMethods().size() > 0 || d.getFields().size() > 0) {
                this.generateJavaSource(d);
            }
            if (d.getMethods().size() > 0) {
                this.generateNativeSource(d);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

