/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessorListener;
import com.sun.mirror.apt.AnnotationProcessors;
import com.sun.mirror.apt.RoundCompleteEvent;
import com.sun.mirror.apt.RoundCompleteListener;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.lwjgl.util.generator.GeneratorVisitor;
import org.lwjgl.util.generator.TypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorProcessorFactory
implements AnnotationProcessorFactory,
RoundCompleteListener {
    private static boolean first_round = true;
    private static final Collection<String> supportedAnnotations = Collections.unmodifiableCollection(Arrays.asList("*"));
    private static final Collection<String> supportedOptions = Collections.unmodifiableCollection(Arrays.asList("-Atypemap", "-Ageneratechecks", "-Acontextspecific"));

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public void roundComplete(RoundCompleteEvent event) {
        first_round = false;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        if (first_round) {
            env.addListener((AnnotationProcessorListener)this);
            return new GeneratorProcessor(env);
        }
        return AnnotationProcessors.NO_OP;
    }

    private static class GeneratorProcessor
    implements AnnotationProcessor {
        private final AnnotationProcessorEnvironment env;

        GeneratorProcessor(AnnotationProcessorEnvironment env) {
            this.env = env;
        }

        public void process() {
            Map options = this.env.getOptions();
            String typemap_classname = null;
            boolean generate_error_checks = options.containsKey("-Ageneratechecks");
            boolean context_specific = options.containsKey("-Acontextspecific");
            for (String k : options.keySet()) {
                int delimiter = k.indexOf(61);
                if (delimiter == -1 || !k.startsWith("-Atypemap")) continue;
                typemap_classname = k.substring(delimiter + 1);
            }
            if (typemap_classname == null) {
                throw new RuntimeException("No TypeMap class name specified with -Atypemap=<class-name>");
            }
            try {
                TypeMap type_map = (TypeMap)Class.forName(typemap_classname).newInstance();
                for (TypeDeclaration typedecl : this.env.getSpecifiedTypeDeclarations()) {
                    typedecl.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)new GeneratorVisitor(this.env, type_map, generate_error_checks, context_specific), (DeclarationVisitor)DeclarationVisitors.NO_OP));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

