/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.PrimitiveType;
import java.io.PrintWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.util.generator.GLbitfield;
import org.lwjgl.util.generator.GLboolean;
import org.lwjgl.util.generator.GLbyte;
import org.lwjgl.util.generator.GLchar;
import org.lwjgl.util.generator.GLcharARB;
import org.lwjgl.util.generator.GLclampd;
import org.lwjgl.util.generator.GLclampf;
import org.lwjgl.util.generator.GLdouble;
import org.lwjgl.util.generator.GLenum;
import org.lwjgl.util.generator.GLfloat;
import org.lwjgl.util.generator.GLhalf;
import org.lwjgl.util.generator.GLhandleARB;
import org.lwjgl.util.generator.GLint;
import org.lwjgl.util.generator.GLintptr;
import org.lwjgl.util.generator.GLintptrARB;
import org.lwjgl.util.generator.GLshort;
import org.lwjgl.util.generator.GLsizei;
import org.lwjgl.util.generator.GLsizeiptr;
import org.lwjgl.util.generator.GLsizeiptrARB;
import org.lwjgl.util.generator.GLubyte;
import org.lwjgl.util.generator.GLuint;
import org.lwjgl.util.generator.GLushort;
import org.lwjgl.util.generator.GLvoid;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.Signedness;
import org.lwjgl.util.generator.TypeMap;

public class GLTypeMap
implements TypeMap {
    private static final Map<Class, PrimitiveType.Kind> native_types_to_primitive = new HashMap<Class, PrimitiveType.Kind>();

    public PrimitiveType.Kind getPrimitiveTypeFromNativeType(Class native_type) {
        PrimitiveType.Kind kind = native_types_to_primitive.get(native_type);
        if (kind == null) {
            throw new RuntimeException("Unsupported type " + native_type);
        }
        return kind;
    }

    public String getErrorCheckMethodName() {
        return "Util.checkGLError()";
    }

    public String getRegisterNativesFunctionName() {
        return "extgl_InitializeClass";
    }

    public Signedness getSignednessFromType(Class type) {
        if (GLuint.class.equals((Object)type)) {
            return Signedness.UNSIGNED;
        }
        if (GLint.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        if (GLushort.class.equals((Object)type)) {
            return Signedness.UNSIGNED;
        }
        if (GLshort.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        if (GLubyte.class.equals((Object)type)) {
            return Signedness.UNSIGNED;
        }
        if (GLbyte.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        return Signedness.NONE;
    }

    public String translateAnnotation(Class annotation_type) {
        if (annotation_type.equals(GLuint.class)) {
            return "i";
        }
        if (annotation_type.equals(GLint.class)) {
            return "i";
        }
        if (annotation_type.equals(GLushort.class)) {
            return "s";
        }
        if (annotation_type.equals(GLshort.class)) {
            return "s";
        }
        if (annotation_type.equals(GLubyte.class)) {
            return "b";
        }
        if (annotation_type.equals(GLbyte.class)) {
            return "b";
        }
        if (annotation_type.equals(GLfloat.class)) {
            return "f";
        }
        if (annotation_type.equals(GLdouble.class)) {
            return "d";
        }
        if (annotation_type.equals(GLhalf.class)) {
            return "h";
        }
        if (annotation_type.equals(GLboolean.class) || annotation_type.equals(GLvoid.class)) {
            return "";
        }
        throw new RuntimeException(annotation_type + " is not allowed");
    }

    public Class getNativeTypeFromPrimitiveType(PrimitiveType.Kind kind) {
        Class type;
        switch (kind) {
            case INT: {
                type = GLint.class;
                break;
            }
            case DOUBLE: {
                type = GLdouble.class;
                break;
            }
            case FLOAT: {
                type = GLfloat.class;
                break;
            }
            case SHORT: {
                type = GLshort.class;
                break;
            }
            case BYTE: {
                type = GLbyte.class;
                break;
            }
            case BOOLEAN: {
                type = GLboolean.class;
                break;
            }
            default: {
                throw new RuntimeException(kind + " is not allowed");
            }
        }
        return type;
    }

    public Class getVoidType() {
        return GLvoid.class;
    }

    public Class getStringElementType() {
        return GLubyte.class;
    }

    private static Class[] getValidBufferTypes(Class type) {
        if (type.equals(IntBuffer.class)) {
            return new Class[]{GLbitfield.class, GLenum.class, GLhandleARB.class, GLint.class, GLintptrARB.class, GLintptrARB.class, GLsizei.class, GLsizeiptrARB.class, GLsizeiptr.class, GLuint.class};
        }
        if (type.equals(FloatBuffer.class)) {
            return new Class[]{GLclampf.class, GLfloat.class};
        }
        if (type.equals(ByteBuffer.class)) {
            return new Class[]{GLboolean.class, GLbyte.class, GLcharARB.class, GLchar.class, GLubyte.class, GLvoid.class};
        }
        if (type.equals(ShortBuffer.class)) {
            return new Class[]{GLhalf.class, GLshort.class, GLushort.class};
        }
        if (type.equals(DoubleBuffer.class)) {
            return new Class[]{GLclampd.class, GLdouble.class};
        }
        return new Class[0];
    }

    private static Class[] getValidPrimitiveTypes(Class type) {
        if (type.equals(Integer.TYPE)) {
            return new Class[]{GLbitfield.class, GLenum.class, GLhandleARB.class, GLint.class, GLintptrARB.class, GLuint.class, GLintptr.class, GLintptr.class, GLsizei.class, GLsizeiptrARB.class, GLsizeiptr.class};
        }
        if (type.equals(Double.TYPE)) {
            return new Class[]{GLclampd.class, GLdouble.class};
        }
        if (type.equals(Float.TYPE)) {
            return new Class[]{GLclampf.class, GLfloat.class};
        }
        if (type.equals(Short.TYPE)) {
            return new Class[]{GLhalf.class, GLshort.class, GLushort.class};
        }
        if (type.equals(Byte.TYPE)) {
            return new Class[]{GLbyte.class, GLcharARB.class, GLchar.class, GLubyte.class};
        }
        if (type.equals(Boolean.TYPE)) {
            return new Class[]{GLboolean.class};
        }
        if (type.equals(Void.TYPE)) {
            return new Class[]{GLvoid.class};
        }
        return new Class[0];
    }

    public String getTypedefPrefix() {
        return "APIENTRY";
    }

    public void printNativeIncludes(PrintWriter writer) {
        writer.println("#include \"extgl.h\"");
    }

    public Class[] getValidAnnotationTypes(Class type) {
        Class[] valid_types = Buffer.class.isAssignableFrom(type) ? GLTypeMap.getValidBufferTypes(type) : (type.isPrimitive() ? GLTypeMap.getValidPrimitiveTypes(type) : (String.class.equals((Object)type) ? new Class[]{GLubyte.class} : new Class[]{}));
        return valid_types;
    }

    public Class getInverseType(Class type) {
        if (GLuint.class.equals((Object)type)) {
            return GLint.class;
        }
        if (GLint.class.equals((Object)type)) {
            return GLuint.class;
        }
        if (GLushort.class.equals((Object)type)) {
            return GLshort.class;
        }
        if (GLshort.class.equals((Object)type)) {
            return GLushort.class;
        }
        if (GLubyte.class.equals((Object)type)) {
            return GLbyte.class;
        }
        if (GLbyte.class.equals((Object)type)) {
            return GLubyte.class;
        }
        return null;
    }

    public String getAutoTypeFromAnnotation(AnnotationMirror annotation) {
        Class<?> annotation_class = NativeTypeTranslator.getClassFromType((DeclaredType)annotation.getAnnotationType());
        if (annotation_class.equals(GLint.class)) {
            return "GL11.GL_INT";
        }
        if (annotation_class.equals(GLbyte.class)) {
            return "GL11.GL_BYTE";
        }
        if (annotation_class.equals(GLshort.class)) {
            return "GL11.GL_SHORT";
        }
        if (annotation_class.equals(GLuint.class)) {
            return "GL11.GL_UNSIGNED_INT";
        }
        if (annotation_class.equals(GLubyte.class)) {
            return "GL11.GL_UNSIGNED_BYTE";
        }
        if (annotation_class.equals(GLushort.class)) {
            return "GL11.GL_UNSIGNED_SHORT";
        }
        if (annotation_class.equals(GLfloat.class)) {
            return "GL11.GL_FLOAT";
        }
        if (annotation_class.equals(GLdouble.class)) {
            return "GL11.GL_DOUBLE";
        }
        return null;
    }

    static {
        native_types_to_primitive.put(GLbitfield.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(GLcharARB.class, PrimitiveType.Kind.BYTE);
        native_types_to_primitive.put(GLclampf.class, PrimitiveType.Kind.FLOAT);
        native_types_to_primitive.put(GLfloat.class, PrimitiveType.Kind.FLOAT);
        native_types_to_primitive.put(GLint.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(GLshort.class, PrimitiveType.Kind.SHORT);
        native_types_to_primitive.put(GLsizeiptr.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(GLuint.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(GLboolean.class, PrimitiveType.Kind.BOOLEAN);
        native_types_to_primitive.put(GLchar.class, PrimitiveType.Kind.BYTE);
        native_types_to_primitive.put(GLdouble.class, PrimitiveType.Kind.DOUBLE);
        native_types_to_primitive.put(GLhalf.class, PrimitiveType.Kind.SHORT);
        native_types_to_primitive.put(GLintptrARB.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(GLsizei.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(GLushort.class, PrimitiveType.Kind.SHORT);
        native_types_to_primitive.put(GLbyte.class, PrimitiveType.Kind.BYTE);
        native_types_to_primitive.put(GLclampd.class, PrimitiveType.Kind.DOUBLE);
        native_types_to_primitive.put(GLenum.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(GLhandleARB.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(GLintptr.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(GLsizeiptrARB.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(GLubyte.class, PrimitiveType.Kind.BYTE);
        native_types_to_primitive.put(GLvoid.class, PrimitiveType.Kind.BYTE);
    }
}

