/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import java.io.PrintWriter;
import java.util.Collection;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldsGenerator {
    private static void validateField(FieldDeclaration field) {
        Collection modifiers = field.getModifiers();
        if (!(modifiers.size() == 3 && modifiers.contains(Modifier.PUBLIC) && modifiers.contains(Modifier.STATIC) && modifiers.contains(Modifier.FINAL))) {
            throw new RuntimeException("Field " + field.getSimpleName() + " is not declared public static final");
        }
        TypeMirror field_type = field.getType();
        if (!(field_type instanceof PrimitiveType)) {
            throw new RuntimeException("Field " + field.getSimpleName() + " is not a primitive type");
        }
        PrimitiveType field_type_prim = (PrimitiveType)field_type;
        if (field_type_prim.getKind() != PrimitiveType.Kind.INT) {
            throw new RuntimeException("Field " + field.getSimpleName() + " is not of type 'int'");
        }
        Integer field_value = (Integer)field.getConstantValue();
        if (field_value == null) {
            throw new RuntimeException("Field " + field.getSimpleName() + " has no initial value");
        }
    }

    private static void generateField(PrintWriter writer, FieldDeclaration field) {
        Integer field_value = (Integer)field.getConstantValue();
        FieldsGenerator.validateField(field);
        String field_value_string = Integer.toHexString(field_value);
        Utils.printDocComment(writer, (Declaration)field);
        writer.println("\tpublic static final " + field.getType().toString() + " " + field.getSimpleName() + " = 0x" + field_value_string + ";");
    }

    public static void generateFields(PrintWriter writer, Collection<FieldDeclaration> fields) {
        for (FieldDeclaration field : fields) {
            FieldsGenerator.generateField(writer, field);
        }
    }
}

